/*
 * Decompiled with CFR 0.152.
 */
package com.jellypudding.simpleLifesteal.managers;

import com.jellypudding.offlineStats.api.OfflineStatsAPI;
import com.jellypudding.simpleLifesteal.SimpleLifesteal;
import java.time.Duration;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.title.Title;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class GracePeriodManager {
    private final SimpleLifesteal plugin;
    private OfflineStatsAPI offlineStatsAPI;
    private final boolean enabled;
    private final long gracePeriodMillis;
    private final Map<UUID, Long> activeGracePeriodPlayers = new ConcurrentHashMap<UUID, Long>();

    public GracePeriodManager(SimpleLifesteal plugin, OfflineStatsAPI offlineStatsAPI) {
        this.plugin = plugin;
        this.offlineStatsAPI = offlineStatsAPI;
        this.enabled = plugin.getConfig().getBoolean("grace-period.enabled", false);
        int gracePeriodHours = plugin.getConfig().getInt("grace-period.duration-hours", 1);
        this.gracePeriodMillis = (long)(gracePeriodHours * 60 * 60) * 1000L;
        if (this.enabled && offlineStatsAPI != null) {
            this.startMonitoringTask();
        }
    }

    public long checkPlaytimeAndGetRemaining(UUID playerUuid) {
        if (!this.enabled || this.offlineStatsAPI == null) {
            return -1L;
        }
        try {
            long timePlayed = this.offlineStatsAPI.getPlayerTimePlayed(playerUuid);
            if (timePlayed < 0L || timePlayed >= this.gracePeriodMillis) {
                return -1L;
            }
            return this.gracePeriodMillis - timePlayed;
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Error checking playtime for UUID " + String.valueOf(playerUuid), e);
            return -1L;
        }
    }

    public boolean isPlayerInGracePeriod(UUID playerUuid) {
        return this.activeGracePeriodPlayers.containsKey(playerUuid);
    }

    public boolean checkGracePeriodEligibility(UUID playerUuid) {
        if (!this.enabled || this.offlineStatsAPI == null) {
            return false;
        }
        int existingHearts = this.plugin.getDatabaseManager().getPlayerHearts(playerUuid);
        if (existingHearts != -1) {
            return false;
        }
        long remainingMs = this.checkPlaytimeAndGetRemaining(playerUuid);
        return remainingMs > 0L;
    }

    public boolean handlePlayerJoin(Player player) {
        long remainingMs;
        UUID uuid = player.getUniqueId();
        int existingHearts = this.plugin.getDatabaseManager().getPlayerHearts(uuid);
        if (existingHearts == -1 && (remainingMs = this.checkPlaytimeAndGetRemaining(uuid)) > 0L) {
            this.activeGracePeriodPlayers.put(uuid, System.currentTimeMillis() + remainingMs);
            this.showGracePeriodTitle(player);
            return true;
        }
        return false;
    }

    public boolean handlePlayerQuit(UUID playerUuid) {
        if (this.activeGracePeriodPlayers.containsKey(playerUuid)) {
            this.activeGracePeriodPlayers.remove(playerUuid);
            return true;
        }
        return false;
    }

    private void showGracePeriodTitle(Player player) {
        Long expiryTime = this.activeGracePeriodPlayers.get(player.getUniqueId());
        if (expiryTime == null) {
            return;
        }
        long remainingMs = expiryTime - System.currentTimeMillis();
        int remainingMinutes = (int)(remainingMs / 60000L);
        Object timeText = remainingMinutes <= 0 ? "Lifesteal disabled for a few more moments" : (remainingMinutes == 1 ? "Lifesteal disabled for 1 more minute" : "Lifesteal disabled for " + remainingMinutes + " more minutes");
        Title graceTitle = Title.title((Component)Component.text((String)"Grace Period", (TextColor)NamedTextColor.GREEN, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}), (Component)Component.text((String)timeText, (TextColor)NamedTextColor.YELLOW), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(500L), (Duration)Duration.ofSeconds(4L), (Duration)Duration.ofMillis(500L)));
        player.showTitle(graceTitle);
        Object chatTimeText = remainingMinutes <= 0 ? "in a few moments" : (remainingMinutes == 1 ? "in 1 minute" : "in " + remainingMinutes + " minutes");
        player.sendMessage(((TextComponent)Component.text((String)"You are in your grace period. Lifesteal will activate ", (TextColor)NamedTextColor.GREEN).append((Component)Component.text((String)chatTimeText, (TextColor)NamedTextColor.YELLOW))).append((Component)Component.text((String)".", (TextColor)NamedTextColor.GREEN)));
    }

    private void startMonitoringTask() {
        this.plugin.getServer().getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            long currentTime = System.currentTimeMillis();
            for (Map.Entry<UUID, Long> entry : this.activeGracePeriodPlayers.entrySet()) {
                UUID uuid = entry.getKey();
                long expiryTime = entry.getValue();
                if (currentTime < expiryTime) continue;
                Player player = this.plugin.getServer().getPlayer(uuid);
                if (player != null && player.isOnline()) {
                    this.plugin.getLogger().info("Grace period ended for " + player.getName() + ". Adding to Lifesteal database.");
                    this.plugin.getPlayerDataManager().loadPlayerData(player, loadedHearts -> {
                        if (!player.isOnline()) {
                            return;
                        }
                        Title endTitle = Title.title((Component)Component.text((String)"Grace Period Ended", (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}), (Component)Component.text((String)"Lifesteal is now active", (TextColor)NamedTextColor.YELLOW), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(500L), (Duration)Duration.ofSeconds(4L), (Duration)Duration.ofMillis(500L)));
                        player.showTitle(endTitle);
                        player.sendMessage((Component)Component.text((String)"Your grace period has ended. Lifesteal is now active.", (TextColor)NamedTextColor.RED));
                    });
                }
                this.activeGracePeriodPlayers.remove(uuid);
            }
        }, 600L, 600L);
    }
}

