/*
 * Decompiled with CFR 0.152.
 */
package com.jellypudding.simpleLifesteal.managers;

import com.jellypudding.simpleLifesteal.SimpleLifesteal;
import com.jellypudding.simpleLifesteal.utils.HeartItemUtil;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.plugin.Plugin;

public class CraftingManager {
    private final SimpleLifesteal plugin;
    private final HeartItemUtil heartItemUtil;
    private NamespacedKey recipeKey;

    public CraftingManager(SimpleLifesteal plugin, HeartItemUtil heartItemUtil) {
        this.plugin = plugin;
        this.heartItemUtil = heartItemUtil;
    }

    public void registerHeartRecipe() {
        if (!this.plugin.getConfig().getBoolean("heart-crafting.enabled", false)) {
            this.plugin.getLogger().info("Heart crafting is disabled.");
            return;
        }
        try {
            List recipeConfig = this.plugin.getConfig().getList("heart-crafting.recipe");
            if (recipeConfig == null || recipeConfig.size() != 3) {
                this.plugin.getLogger().warning("Invalid heart crafting recipe configuration. Recipe must have exactly 3 rows.");
                return;
            }
            for (int i = 0; i < recipeConfig.size(); ++i) {
                List row = (List)recipeConfig.get(i);
                if (row.size() == 3) continue;
                this.plugin.getLogger().warning("Invalid heart crafting recipe configuration. Row " + (i + 1) + " must have exactly 3 items.");
                return;
            }
            this.recipeKey = new NamespacedKey((Plugin)this.plugin, "heart_recipe");
            ItemStack heartItem = this.heartItemUtil.createHeartItem(1);
            ShapedRecipe recipe = new ShapedRecipe(this.recipeKey, heartItem);
            recipe.shape(new String[]{"ABC", "DEF", "GHI"});
            String[] positions = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I"};
            int posIndex = 0;
            for (List row : recipeConfig) {
                for (String materialName : row) {
                    String position = positions[posIndex];
                    Material material = this.parseMaterial(materialName);
                    if (material != null && material != Material.AIR) {
                        recipe.setIngredient(position.charAt(0), material);
                    } else {
                        recipe.setIngredient(position.charAt(0), Material.AIR);
                    }
                    ++posIndex;
                }
            }
            this.plugin.getServer().addRecipe((Recipe)recipe);
            this.plugin.getLogger().info("Heart crafting recipe registered successfully!");
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to register heart crafting recipe: " + e.getMessage());
        }
    }

    public void unregisterHeartRecipe() {
        if (this.recipeKey != null) {
            this.plugin.getServer().removeRecipe(this.recipeKey);
            this.plugin.getLogger().info("Heart crafting recipe unregistered.");
        }
    }

    private Material parseMaterial(String materialName) {
        if (materialName == null || materialName.trim().isEmpty() || materialName.equalsIgnoreCase("AIR")) {
            return Material.AIR;
        }
        try {
            return Material.valueOf((String)materialName.toUpperCase().trim());
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid material in heart recipe: " + materialName);
            return null;
        }
    }
}

