/*
 * Decompiled with CFR 0.152.
 */
package com.jellypudding.simpleLifesteal.listeners;

import com.jellypudding.discordRelay.DiscordRelayAPI;
import com.jellypudding.simpleLifesteal.SimpleLifesteal;
import com.jellypudding.simpleLifesteal.managers.PlayerDataManager;
import com.jellypudding.simpleLifesteal.utils.HeartItemUtil;
import com.jellypudding.simpleLifesteal.utils.PlayerNameUtil;
import java.awt.Color;
import java.util.Date;
import java.util.UUID;
import java.util.logging.Level;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;

public class PlayerListener
implements Listener {
    private final SimpleLifesteal plugin;
    private final PlayerDataManager playerDataManager;
    private final HeartItemUtil heartItemUtil;
    private final NamespacedKey battleLockKey;

    public PlayerListener(SimpleLifesteal plugin) {
        this.plugin = plugin;
        this.playerDataManager = plugin.getPlayerDataManager();
        this.heartItemUtil = plugin.getHeartItemUtil();
        this.battleLockKey = new NamespacedKey("battlelock", "combat_log_player_id");
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        UUID playerUuid = player.getUniqueId();
        if (this.plugin.getGracePeriodManager() != null && this.plugin.getGracePeriodManager().handlePlayerJoin(player)) {
            return;
        }
        this.playerDataManager.loadPlayerData(player, loadedHearts -> {
            if (!player.isOnline()) {
                return;
            }
            if (loadedHearts <= 0) {
                int startingHearts = this.plugin.getStartingHearts();
                this.plugin.getLogger().info(player.getName() + " joined with 0 hearts. Resetting to " + startingHearts + ".");
                this.playerDataManager.setPlayerHearts(playerUuid, startingHearts);
                player.sendMessage((Component)Component.text((String)"Your hearts have been reset!", (TextColor)NamedTextColor.GOLD));
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        UUID playerUuid = event.getPlayer().getUniqueId();
        if (this.plugin.getGracePeriodManager() != null && this.plugin.getGracePeriodManager().handlePlayerQuit(playerUuid)) {
            return;
        }
        this.playerDataManager.savePlayerData(playerUuid, true);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerDeath(PlayerDeathEvent event) {
        boolean killerInGracePeriod;
        Player victim = event.getEntity();
        Player killer = victim.getKiller();
        boolean victimInGracePeriod = this.plugin.isPlayerInGracePeriod(victim.getUniqueId());
        boolean bl = killerInGracePeriod = killer != null && this.plugin.isPlayerInGracePeriod(killer.getUniqueId());
        if (victimInGracePeriod) {
            victim.sendMessage((Component)Component.text((String)"Grace period protected you from losing a heart!", (TextColor)NamedTextColor.GREEN));
            if (killer != null && !killer.equals((Object)victim)) {
                killer.sendMessage(victim.displayName().append((Component)Component.text((String)" is in their grace period. No heart stolen.", (TextColor)NamedTextColor.GRAY)));
            }
            return;
        }
        int currentHearts = this.playerDataManager.getPlayerHearts(victim.getUniqueId());
        int newHearts = Math.max(0, currentHearts - 1);
        this.playerDataManager.removeHearts(victim.getUniqueId(), 1);
        if (newHearts > 0) {
            victim.sendMessage((Component)Component.text((String)("You lost a heart! You now have " + newHearts + (newHearts == 1 ? " heart." : " hearts.")), (TextColor)NamedTextColor.RED));
        } else {
            victim.sendMessage((Component)Component.text((String)"You lost your final heart!", (TextColor)NamedTextColor.RED));
            this.banPlayer(victim);
        }
        if (killer != null && !killer.equals((Object)victim)) {
            if (killerInGracePeriod) {
                killer.sendMessage((Component)Component.text((String)"You are in your grace period. No heart gained.", (TextColor)NamedTextColor.GRAY));
            } else {
                this.playerDataManager.addHearts(killer.getUniqueId(), 1);
                int killerNewHearts = this.playerDataManager.getPlayerHearts(killer.getUniqueId());
                killer.sendMessage(((TextComponent)Component.text((String)"You stole a heart! You now have ", (TextColor)NamedTextColor.GREEN).append((Component)Component.text((int)killerNewHearts, (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)(killerNewHearts == 1 ? " heart." : " hearts."), (TextColor)NamedTextColor.GREEN)));
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onNpcDamageByPlayer(EntityDamageByEntityEvent event) {
        Villager npc;
        block25: {
            block24: {
                Entity entity = event.getEntity();
                if (!(entity instanceof Villager)) break block24;
                npc = (Villager)entity;
                if (!(event.getFinalDamage() < npc.getHealth())) break block25;
            }
            return;
        }
        if (!npc.getPersistentDataContainer().has(this.battleLockKey, PersistentDataType.STRING)) {
            return;
        }
        String playerUuidString = (String)npc.getPersistentDataContainer().get(this.battleLockKey, PersistentDataType.STRING);
        try {
            Projectile projectile;
            ProjectileSource projectileSource;
            boolean loggerInGracePeriod;
            UUID combatLoggerUuid = UUID.fromString(playerUuidString);
            OfflinePlayer combatLogger = Bukkit.getOfflinePlayer((UUID)combatLoggerUuid);
            String loggerName = combatLogger.getName() != null ? combatLogger.getName() : combatLoggerUuid.toString();
            Component loggerDisplayName = PlayerNameUtil.getFormattedPlayerName(this.plugin.getChromaTagAPI(), combatLoggerUuid, loggerName);
            int originalLoggerHearts = this.playerDataManager.getPlayerHearts(combatLoggerUuid);
            if (originalLoggerHearts == -1) {
                this.plugin.getLogger().warning("Combat logger " + loggerName + " (UUID: " + String.valueOf(combatLoggerUuid) + ") not found in database during NPC kill processing.");
                return;
            }
            boolean bl = loggerInGracePeriod = this.plugin.getGracePeriodManager() != null && this.plugin.getGracePeriodManager().checkGracePeriodEligibility(combatLoggerUuid);
            if (originalLoggerHearts > 0 && !loggerInGracePeriod) {
                int newLoggerHearts = Math.max(0, originalLoggerHearts - 1);
                this.playerDataManager.removeHearts(combatLoggerUuid, 1);
                if (newLoggerHearts <= 0 && combatLogger != null) {
                    this.plugin.getLogger().info("Combat logger " + loggerName + " reached 0 hearts. Banning...");
                    this.banOfflinePlayer(combatLogger, npc.getLocation());
                }
            } else if (loggerInGracePeriod) {
                this.plugin.getLogger().info("Combat logger " + loggerName + " is in grace period. No heart lost.");
            } else {
                this.plugin.getLogger().warning("Combat logger " + loggerName + " already had 0 or fewer hearts (" + originalLoggerHearts + "). No action taken.");
            }
            Player killer = null;
            Entity damager = event.getDamager();
            if (damager instanceof Player) {
                killer = (Player)damager;
            } else if (damager instanceof Projectile && (projectileSource = (projectile = (Projectile)damager).getShooter()) instanceof Player) {
                Player shooter;
                killer = shooter = (Player)projectileSource;
            }
            if (killer != null) {
                if (!killer.getUniqueId().equals(combatLoggerUuid)) {
                    boolean killerInGracePeriod = this.plugin.isPlayerInGracePeriod(killer.getUniqueId());
                    if (loggerInGracePeriod) {
                        killer.sendMessage(loggerDisplayName.append((Component)Component.text((String)" is in their grace period. No heart stolen.", (TextColor)NamedTextColor.GRAY)));
                    } else if (killerInGracePeriod) {
                        killer.sendMessage((Component)Component.text((String)"You are in your grace period. No heart gained.", (TextColor)NamedTextColor.GRAY));
                    } else {
                        this.playerDataManager.addHearts(killer.getUniqueId(), 1);
                        int killerNewHearts = this.playerDataManager.getPlayerHearts(killer.getUniqueId());
                        killer.sendMessage(((TextComponent)((TextComponent)((TextComponent)Component.text((String)"You killed ", (TextColor)NamedTextColor.GREEN).append(loggerDisplayName)).append((Component)Component.text((String)"'s combat logged NPC and stole a heart! You now have ", (TextColor)NamedTextColor.GREEN))).append((Component)Component.text((int)killerNewHearts, (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)(killerNewHearts == 1 ? " heart." : " hearts."), (TextColor)NamedTextColor.GREEN)));
                    }
                } else {
                    this.plugin.getLogger().warning("Killer was the same as the combat logger. No heart added.");
                }
            }
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error parsing BattleLock NPC UUID from damage event: " + playerUuidString, e);
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "An unexpected error occurred processing BattleLock NPC death from damage event: " + playerUuidString, e);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onNpcDeath(EntityDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Villager)) {
            return;
        }
        Villager npc = (Villager)livingEntity;
        if (!npc.getPersistentDataContainer().has(this.battleLockKey, PersistentDataType.STRING)) {
            return;
        }
        String playerUuidString = (String)npc.getPersistentDataContainer().get(this.battleLockKey, PersistentDataType.STRING);
        try {
            boolean loggerInGracePeriod;
            UUID combatLoggerUuid = UUID.fromString(playerUuidString);
            OfflinePlayer combatLogger = Bukkit.getOfflinePlayer((UUID)combatLoggerUuid);
            String loggerName = combatLogger.getName() != null ? combatLogger.getName() : combatLoggerUuid.toString();
            int originalLoggerHearts = this.playerDataManager.getPlayerHearts(combatLoggerUuid);
            if (originalLoggerHearts == -1) {
                this.plugin.getLogger().warning("Combat logger " + loggerName + " (UUID: " + String.valueOf(combatLoggerUuid) + ") not found in database during NPC death processing.");
                return;
            }
            boolean bl = loggerInGracePeriod = this.plugin.getGracePeriodManager() != null && this.plugin.getGracePeriodManager().checkGracePeriodEligibility(combatLoggerUuid);
            if (originalLoggerHearts > 0 && !loggerInGracePeriod) {
                int newLoggerHearts = Math.max(0, originalLoggerHearts - 1);
                this.playerDataManager.removeHearts(combatLoggerUuid, 1);
                this.plugin.getLogger().info("Combat logger " + loggerName + " lost a heart due to environmental NPC death. Hearts: " + originalLoggerHearts + " -> " + newLoggerHearts);
                if (newLoggerHearts <= 0 && combatLogger != null) {
                    this.plugin.getLogger().info("Combat logger " + loggerName + " reached 0 hearts from environmental death. Banning...");
                    this.banOfflinePlayer(combatLogger, npc.getLocation());
                }
            } else if (loggerInGracePeriod) {
                this.plugin.getLogger().info("Combat logger " + loggerName + " is in grace period. No heart lost from environmental NPC death.");
            } else {
                this.plugin.getLogger().warning("Combat logger " + loggerName + " already had 0 or fewer hearts (" + originalLoggerHearts + "). No action taken.");
            }
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error parsing BattleLock NPC UUID from death event: " + playerUuidString, e);
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "An unexpected error occurred processing BattleLock NPC death from death event: " + playerUuidString, e);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onHeartConsume(PlayerInteractEvent event) {
        Block clickedBlock;
        Player player = event.getPlayer();
        Action action = event.getAction();
        if (action != Action.RIGHT_CLICK_AIR && action != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (action == Action.RIGHT_CLICK_BLOCK && (clickedBlock = event.getClickedBlock()) != null && this.hasBlockInteraction(clickedBlock.getType())) {
            return;
        }
        ItemStack item = event.getItem();
        if (item == null || item.getItemMeta() == null) {
            return;
        }
        if (this.heartItemUtil.isHeartItem(item)) {
            int maxHearts;
            event.setCancelled(true);
            if (this.plugin.isPlayerInGracePeriod(player.getUniqueId())) {
                player.sendMessage((Component)Component.text((String)"You cannot consume hearts during your grace period.", (TextColor)NamedTextColor.RED));
                return;
            }
            int currentHearts = this.playerDataManager.getPlayerHearts(player.getUniqueId());
            if (currentHearts >= (maxHearts = this.plugin.getPlayerMaxHearts(player.getUniqueId()))) {
                player.sendMessage(((TextComponent)Component.text((String)"You are already at maximum hearts (", (TextColor)NamedTextColor.RED).append((Component)Component.text((int)maxHearts, (TextColor)NamedTextColor.YELLOW))).append((Component)Component.text((String)")", (TextColor)NamedTextColor.RED)));
                return;
            }
            if (item.getAmount() > 1) {
                item.setAmount(item.getAmount() - 1);
            } else if (event.getHand() == EquipmentSlot.HAND) {
                player.getInventory().setItemInMainHand(null);
            } else {
                player.getInventory().setItemInOffHand(null);
            }
            this.playerDataManager.addHearts(player.getUniqueId(), 1);
            int newHeartCount = this.playerDataManager.getPlayerHearts(player.getUniqueId());
            player.sendMessage(((TextComponent)Component.text((String)"You consumed a heart. You now have ", (TextColor)NamedTextColor.GREEN).append((Component)Component.text((int)newHeartCount, (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)(" heart" + (newHeartCount == 1 ? "" : "s") + "."), (TextColor)NamedTextColor.GREEN)));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onHeartItemConsume(PlayerItemConsumeEvent event) {
        ItemStack item = event.getItem();
        if (item == null || item.getItemMeta() == null) {
            return;
        }
        if (this.heartItemUtil.isHeartItem(item)) {
            event.setCancelled(true);
        }
    }

    private boolean hasBlockInteraction(Material material) {
        return switch (material) {
            case Material.CHEST, Material.TRAPPED_CHEST, Material.ENDER_CHEST, Material.BARREL, Material.SHULKER_BOX, Material.WHITE_SHULKER_BOX, Material.ORANGE_SHULKER_BOX, Material.MAGENTA_SHULKER_BOX, Material.LIGHT_BLUE_SHULKER_BOX, Material.YELLOW_SHULKER_BOX, Material.LIME_SHULKER_BOX, Material.PINK_SHULKER_BOX, Material.GRAY_SHULKER_BOX, Material.LIGHT_GRAY_SHULKER_BOX, Material.CYAN_SHULKER_BOX, Material.PURPLE_SHULKER_BOX, Material.BLUE_SHULKER_BOX, Material.BROWN_SHULKER_BOX, Material.GREEN_SHULKER_BOX, Material.RED_SHULKER_BOX, Material.BLACK_SHULKER_BOX, Material.COPPER_CHEST, Material.EXPOSED_COPPER_CHEST, Material.WEATHERED_COPPER_CHEST, Material.OXIDIZED_COPPER_CHEST, Material.WAXED_COPPER_CHEST, Material.WAXED_EXPOSED_COPPER_CHEST, Material.WAXED_WEATHERED_COPPER_CHEST, Material.WAXED_OXIDIZED_COPPER_CHEST, Material.CRAFTING_TABLE, Material.ENCHANTING_TABLE, Material.ANVIL, Material.CHIPPED_ANVIL, Material.DAMAGED_ANVIL, Material.FURNACE, Material.BLAST_FURNACE, Material.SMOKER, Material.BREWING_STAND, Material.GRINDSTONE, Material.LOOM, Material.STONECUTTER, Material.CARTOGRAPHY_TABLE, Material.FLETCHING_TABLE, Material.SMITHING_TABLE, Material.CRAFTER, Material.CHISELED_BOOKSHELF, Material.LECTERN, Material.COMPOSTER, Material.DISPENSER, Material.DROPPER, Material.HOPPER, Material.JUKEBOX, Material.NOTE_BLOCK, Material.DECORATED_POT, Material.BEEHIVE, Material.BEE_NEST, Material.CAMPFIRE, Material.SOUL_CAMPFIRE, Material.BELL, Material.RESPAWN_ANCHOR, Material.LODESTONE, Material.ACACIA_DOOR, Material.BIRCH_DOOR, Material.DARK_OAK_DOOR, Material.JUNGLE_DOOR, Material.OAK_DOOR, Material.SPRUCE_DOOR, Material.MANGROVE_DOOR, Material.CHERRY_DOOR, Material.BAMBOO_DOOR, Material.PALE_OAK_DOOR, Material.CRIMSON_DOOR, Material.WARPED_DOOR, Material.IRON_DOOR, Material.COPPER_DOOR, Material.EXPOSED_COPPER_DOOR, Material.WEATHERED_COPPER_DOOR, Material.OXIDIZED_COPPER_DOOR, Material.WAXED_COPPER_DOOR, Material.WAXED_EXPOSED_COPPER_DOOR, Material.WAXED_WEATHERED_COPPER_DOOR, Material.WAXED_OXIDIZED_COPPER_DOOR, Material.ACACIA_TRAPDOOR, Material.BIRCH_TRAPDOOR, Material.DARK_OAK_TRAPDOOR, Material.JUNGLE_TRAPDOOR, Material.OAK_TRAPDOOR, Material.SPRUCE_TRAPDOOR, Material.MANGROVE_TRAPDOOR, Material.CHERRY_TRAPDOOR, Material.BAMBOO_TRAPDOOR, Material.PALE_OAK_TRAPDOOR, Material.CRIMSON_TRAPDOOR, Material.WARPED_TRAPDOOR, Material.IRON_TRAPDOOR, Material.COPPER_TRAPDOOR, Material.EXPOSED_COPPER_TRAPDOOR, Material.WEATHERED_COPPER_TRAPDOOR, Material.OXIDIZED_COPPER_TRAPDOOR, Material.WAXED_COPPER_TRAPDOOR, Material.WAXED_EXPOSED_COPPER_TRAPDOOR, Material.WAXED_WEATHERED_COPPER_TRAPDOOR, Material.WAXED_OXIDIZED_COPPER_TRAPDOOR, Material.LEVER, Material.ACACIA_BUTTON, Material.BIRCH_BUTTON, Material.DARK_OAK_BUTTON, Material.JUNGLE_BUTTON, Material.OAK_BUTTON, Material.SPRUCE_BUTTON, Material.MANGROVE_BUTTON, Material.CHERRY_BUTTON, Material.BAMBOO_BUTTON, Material.PALE_OAK_BUTTON, Material.CRIMSON_BUTTON, Material.WARPED_BUTTON, Material.STONE_BUTTON, Material.POLISHED_BLACKSTONE_BUTTON, Material.ACACIA_FENCE_GATE, Material.BIRCH_FENCE_GATE, Material.DARK_OAK_FENCE_GATE, Material.JUNGLE_FENCE_GATE, Material.OAK_FENCE_GATE, Material.SPRUCE_FENCE_GATE, Material.MANGROVE_FENCE_GATE, Material.CHERRY_FENCE_GATE, Material.BAMBOO_FENCE_GATE, Material.PALE_OAK_FENCE_GATE, Material.CRIMSON_FENCE_GATE, Material.WARPED_FENCE_GATE -> true;
            default -> false;
        };
    }

    private void banPlayer(Player player) {
        String playerName = player.getName();
        UUID playerUUID = player.getUniqueId();
        String rawBanMessage = this.plugin.getBanMessage();
        TextComponent componentMessage = LegacyComponentSerializer.legacyAmpersand().deserialize(rawBanMessage);
        String finalBanMessage = LegacyComponentSerializer.legacySection().serialize((Component)componentMessage);
        String banSource = this.plugin.getName();
        Location playerLocation = player.getLocation();
        player.getWorld().strikeLightningEffect(playerLocation);
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            player.ban(finalBanMessage, (Date)null, banSource, true);
            this.plugin.getDatabaseManager().addPluginBan(playerUUID, finalBanMessage);
            this.plugin.getLogger().info("Banned player " + playerName + " (" + String.valueOf(playerUUID) + ") for running out of hearts.");
            int banCount = this.plugin.getDatabaseManager().getTotalHeartBans();
            Component broadcastMessage = player.displayName().append((Component)Component.text((String)" ran out of hearts and was banned! ", (TextColor)NamedTextColor.GRAY)).append((Component)Component.text((String)"(", (TextColor)NamedTextColor.DARK_GRAY)).append((Component)Component.text((String)"Total bans: ", (TextColor)NamedTextColor.GRAY)).append((Component)Component.text((int)banCount, (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD})).append((Component)Component.text((String)")", (TextColor)NamedTextColor.DARK_GRAY));
            Bukkit.broadcast((Component)broadcastMessage);
            if (this.plugin.isDiscordRelayAPIReady()) {
                DiscordRelayAPI.sendFormattedMessage((String)"Lifesteal Ban", (String)(playerName + " ran out of hearts and was banned! (Total bans: " + banCount + ")"), (Color)Color.RED);
            }
        });
    }

    private void banOfflinePlayer(OfflinePlayer player, Location lightningLocation) {
        UUID playerUUID = player.getUniqueId();
        String playerName = player.getName() != null ? player.getName() : playerUUID.toString();
        String rawBanMessage = this.plugin.getBanMessage();
        TextComponent componentMessage = LegacyComponentSerializer.legacyAmpersand().deserialize(rawBanMessage);
        String finalBanMessage = LegacyComponentSerializer.legacySection().serialize((Component)componentMessage);
        String banSource = this.plugin.getName();
        if (lightningLocation != null) {
            lightningLocation.getWorld().strikeLightningEffect(lightningLocation);
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            player.ban(finalBanMessage, (Date)null, banSource);
            this.plugin.getDatabaseManager().addPluginBan(playerUUID, finalBanMessage);
            this.plugin.getLogger().info("Banned offline player " + playerName + " (" + String.valueOf(playerUUID) + ") for running out of hearts.");
            int banCount = this.plugin.getDatabaseManager().getTotalHeartBans();
            Component playerDisplayName = PlayerNameUtil.getFormattedPlayerName(this.plugin.getChromaTagAPI(), playerUUID, playerName);
            Component broadcastMessage = playerDisplayName.append((Component)Component.text((String)" ran out of hearts and was banned (whilst offline)! ", (TextColor)NamedTextColor.GRAY)).append((Component)Component.text((String)"(", (TextColor)NamedTextColor.DARK_GRAY)).append((Component)Component.text((String)"Total bans: ", (TextColor)NamedTextColor.GRAY)).append((Component)Component.text((int)banCount, (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD})).append((Component)Component.text((String)")", (TextColor)NamedTextColor.DARK_GRAY));
            Bukkit.broadcast((Component)broadcastMessage);
            if (this.plugin.isDiscordRelayAPIReady()) {
                DiscordRelayAPI.sendFormattedMessage((String)"Lifesteal Ban", (String)(playerName + " ran out of hearts and was banned (whilst offline)! (Total bans: " + banCount + ")"), (Color)Color.RED);
            }
        });
    }
}

