/*
 * Decompiled with CFR 0.152.
 */
package com.jellypudding.simpleLifesteal.commands;

import com.jellypudding.simpleLifesteal.SimpleLifesteal;
import com.jellypudding.simpleLifesteal.database.DatabaseManager;
import com.jellypudding.simpleLifesteal.utils.PlayerUUIDUtil;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public class SlUnbanCommand
implements CommandExecutor {
    private final SimpleLifesteal plugin;
    private final DatabaseManager databaseManager;
    private final String bedrockPrefix = ".";

    public SlUnbanCommand(SimpleLifesteal plugin) {
        this.plugin = plugin;
        this.databaseManager = plugin.getDatabaseManager();
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length != 1) {
            sender.sendMessage((Component)Component.text((String)"Usage: /slunban <player>", (TextColor)NamedTextColor.RED));
            return true;
        }
        String playerName = args[0];
        if (playerName.startsWith(".")) {
            sender.sendMessage((Component)Component.text((String)"Attempting to unban Bedrock player via API lookup...", (TextColor)NamedTextColor.GRAY));
            PlayerUUIDUtil.fetchBedrockUUIDAsync(this.plugin, playerName, uuid -> {
                if (uuid != null) {
                    boolean removed = this.databaseManager.removePluginBan((UUID)uuid);
                    if (removed) {
                        sender.sendMessage(Component.text((String)playerName, (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)" has been unbanned from the SimpleLifesteal database.", (TextColor)NamedTextColor.GREEN)));
                        this.plugin.getLogger().info("Admin " + sender.getName() + " unbanned " + playerName + " from the SimpleLifesteal database (via API lookup).");
                    } else {
                        sender.sendMessage(Component.text((String)playerName, (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)" was not found in the SimpleLifesteal ban database.", (TextColor)NamedTextColor.RED)));
                    }
                } else {
                    sender.sendMessage((Component)Component.text((String)("Player '" + playerName + "' not found via Geyser API lookup. Cannot unban."), (TextColor)NamedTextColor.RED));
                }
            });
            return true;
        }
        OfflinePlayer targetPlayer = Bukkit.getOfflinePlayer((String)playerName);
        if (!targetPlayer.hasPlayedBefore() && !targetPlayer.isOnline()) {
            sender.sendMessage((Component)Component.text((String)("Player '" + playerName + "' not found."), (TextColor)NamedTextColor.RED));
            return true;
        }
        boolean removed = this.databaseManager.removePluginBan(targetPlayer.getUniqueId());
        if (removed) {
            sender.sendMessage(Component.text((String)playerName, (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)" has been unbanned from the SimpleLifesteal database.", (TextColor)NamedTextColor.GREEN)));
            this.plugin.getLogger().info("Admin " + sender.getName() + " unbanned " + playerName + " from the SimpleLifesteal database.");
        } else {
            sender.sendMessage(Component.text((String)playerName, (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)" was not found in the SimpleLifesteal ban database.", (TextColor)NamedTextColor.RED)));
        }
        return true;
    }
}

