/*
 * Decompiled with CFR 0.152.
 */
package com.jellypudding.simpleLifesteal.commands;

import com.jellypudding.simpleLifesteal.SimpleLifesteal;
import com.jellypudding.simpleLifesteal.managers.PlayerDataManager;
import com.jellypudding.simpleLifesteal.utils.HeartItemUtil;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class HeartWithdrawCommand
implements CommandExecutor {
    private final SimpleLifesteal plugin;
    private final PlayerDataManager playerDataManager;
    private final HeartItemUtil heartItemUtil;

    public HeartWithdrawCommand(SimpleLifesteal plugin) {
        this.plugin = plugin;
        this.playerDataManager = plugin.getPlayerDataManager();
        this.heartItemUtil = plugin.getHeartItemUtil();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        int currentHearts;
        if (!(sender instanceof Player)) {
            sender.sendMessage((Component)Component.text((String)"This command can only be run by a player.", (TextColor)NamedTextColor.RED));
            return true;
        }
        Player player = (Player)sender;
        if (this.plugin.isPlayerInGracePeriod(player.getUniqueId())) {
            player.sendMessage((Component)Component.text((String)"You cannot withdraw hearts during your grace period.", (TextColor)NamedTextColor.RED));
            return true;
        }
        int heartsToWithdraw = 1;
        if (args.length > 0) {
            try {
                heartsToWithdraw = Integer.parseInt(args[0]);
                if (heartsToWithdraw <= 0) {
                    player.sendMessage((Component)Component.text((String)"You must withdraw at least 1 heart.", (TextColor)NamedTextColor.RED));
                    return true;
                }
            }
            catch (NumberFormatException e) {
                player.sendMessage((Component)Component.text((String)"Invalid number. Usage: /withdrawheart [integer]", (TextColor)NamedTextColor.RED));
                return true;
            }
        }
        if ((currentHearts = this.playerDataManager.getPlayerHearts(player.getUniqueId())) <= heartsToWithdraw) {
            player.sendMessage(((TextComponent)((TextComponent)((TextComponent)Component.text((String)"You cannot withdraw that many hearts. You need at least ", (TextColor)NamedTextColor.RED).append((Component)Component.text((int)(heartsToWithdraw + 1), (TextColor)NamedTextColor.YELLOW))).append((Component)Component.text((String)" hearts to withdraw ", (TextColor)NamedTextColor.RED))).append((Component)Component.text((int)heartsToWithdraw, (TextColor)NamedTextColor.YELLOW))).append((Component)Component.text((String)(" heart" + (heartsToWithdraw == 1 ? "" : "s") + "."), (TextColor)NamedTextColor.RED)));
            return true;
        }
        if (player.getInventory().firstEmpty() == -1) {
            player.sendMessage((Component)Component.text((String)"Your inventory is full. Make some space first.", (TextColor)NamedTextColor.RED));
            return true;
        }
        this.playerDataManager.removeHearts(player.getUniqueId(), heartsToWithdraw);
        ItemStack heartItem = this.heartItemUtil.createHeartItem(heartsToWithdraw);
        player.getInventory().addItem(new ItemStack[]{heartItem});
        int newHeartCount = currentHearts - heartsToWithdraw;
        player.sendMessage(((TextComponent)((TextComponent)((TextComponent)Component.text((String)"You withdrew ", (TextColor)NamedTextColor.GREEN).append((Component)Component.text((int)heartsToWithdraw, (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)(" heart" + (heartsToWithdraw == 1 ? "" : "s") + "! You now have "), (TextColor)NamedTextColor.GREEN))).append((Component)Component.text((int)newHeartCount, (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)(" heart" + (newHeartCount == 1 ? "" : "s") + " remaining."), (TextColor)NamedTextColor.GREEN)));
        return true;
    }
}

