/*
 * Decompiled with CFR 0.152.
 */
package com.jellypudding.simpleLifesteal.database;

import com.jellypudding.simpleLifesteal.SimpleLifesteal;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;
import java.util.logging.Level;

public class DatabaseManager {
    private final SimpleLifesteal plugin;
    private volatile Connection connection;
    private final File dbFile;
    private final Object connectionLock = new Object();

    public DatabaseManager(SimpleLifesteal plugin) {
        this.plugin = plugin;
        this.dbFile = new File(plugin.getDataFolder(), "player_hearts.db");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        Object object = this.connectionLock;
        synchronized (object) {
            if (this.connection == null || this.connection.isClosed()) {
                this.connect();
            }
            return this.connection;
        }
    }

    private void connect() throws SQLException {
        if (!this.plugin.getDataFolder().exists()) {
            this.plugin.getDataFolder().mkdirs();
        }
        if (!this.dbFile.exists()) {
            try {
                this.dbFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Could not create database file!", e);
                throw new SQLException("Could not create database file", e);
            }
        }
        try {
            Class.forName("org.sqlite.JDBC");
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + this.dbFile.getAbsolutePath());
            this.plugin.getLogger().info("Successfully connected to SQLite database.");
            this.initialiseDatabase();
        }
        catch (ClassNotFoundException e) {
            this.plugin.getLogger().log(Level.SEVERE, "SQLite JDBC driver not found!", e);
            this.closeConnectionInternal();
            throw new SQLException("SQLite JDBC driver not found", e);
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not connect to SQLite database!", e);
            this.closeConnectionInternal();
            throw e;
        }
    }

    private void initialiseDatabase() throws SQLException {
        String sql = "CREATE TABLE IF NOT EXISTS player_hearts ( uuid TEXT PRIMARY KEY NOT NULL, current_hearts INTEGER NOT NULL, max_hearts INTEGER);";
        try (Statement stmt = this.connection.createStatement();){
            stmt.execute(sql);
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not initialise player_hearts table!", e);
            throw e;
        }
        String banSql = "CREATE TABLE IF NOT EXISTS plugin_bans ( uuid TEXT PRIMARY KEY NOT NULL, reason TEXT, ban_timestamp INTEGER NOT NULL);";
        try (Statement stmt = this.connection.createStatement();){
            stmt.execute(banSql);
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not initialise plugin_bans table!", e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection() {
        Object object = this.connectionLock;
        synchronized (object) {
            this.closeConnectionInternal();
        }
    }

    private void closeConnectionInternal() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error closing database connection", e);
        }
        finally {
            this.connection = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getPlayerHearts(UUID uuid) {
        String sql = "SELECT current_hearts FROM player_hearts WHERE uuid = ?";
        Object object = this.connectionLock;
        synchronized (object) {
            Connection conn = null;
            try {
                conn = this.getConnection();
                try (PreparedStatement pstmt = conn.prepareStatement(sql);){
                    pstmt.setString(1, uuid.toString());
                    ResultSet rs = pstmt.executeQuery();
                    if (!rs.next()) return -1;
                    int n = rs.getInt("current_hearts");
                    return n;
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Could not retrieve hearts for UUID: " + String.valueOf(uuid), e);
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlayerHearts(UUID uuid, int hearts) {
        String sql = "INSERT OR REPLACE INTO player_hearts (uuid, current_hearts, max_hearts) VALUES (?, ?, COALESCE((SELECT max_hearts FROM player_hearts WHERE uuid = ?), NULL))";
        Object object = this.connectionLock;
        synchronized (object) {
            Connection conn = null;
            try {
                conn = this.getConnection();
                try (PreparedStatement pstmt = conn.prepareStatement(sql);){
                    pstmt.setString(1, uuid.toString());
                    pstmt.setInt(2, hearts);
                    pstmt.setString(3, uuid.toString());
                    pstmt.executeUpdate();
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Could not set hearts for UUID: " + String.valueOf(uuid), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Integer getPlayerMaxHearts(UUID uuid) {
        String sql = "SELECT max_hearts FROM player_hearts WHERE uuid = ?";
        Object object = this.connectionLock;
        synchronized (object) {
            Connection conn = null;
            try {
                conn = this.getConnection();
                try (PreparedStatement pstmt = conn.prepareStatement(sql);){
                    pstmt.setString(1, uuid.toString());
                    ResultSet rs = pstmt.executeQuery();
                    if (!rs.next()) return null;
                    int maxHearts = rs.getInt("max_hearts");
                    Integer n = rs.wasNull() ? null : Integer.valueOf(maxHearts);
                    return n;
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Could not retrieve max hearts for UUID: " + String.valueOf(uuid), e);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlayerMaxHearts(UUID uuid, int maxHearts) {
        String sql = "REPLACE INTO player_hearts (uuid, current_hearts, max_hearts) VALUES (?, ?, ?)";
        int currentHearts = this.getPlayerHearts(uuid);
        if (currentHearts == -1) {
            currentHearts = this.plugin.getStartingHearts();
        }
        Object object = this.connectionLock;
        synchronized (object) {
            Connection conn = null;
            try {
                conn = this.getConnection();
                try (PreparedStatement pstmt = conn.prepareStatement(sql);){
                    pstmt.setString(1, uuid.toString());
                    pstmt.setInt(2, currentHearts);
                    pstmt.setInt(3, maxHearts);
                    pstmt.executeUpdate();
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Could not set max hearts for UUID: " + String.valueOf(uuid), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPluginBan(UUID uuid, String reason) {
        String sql = "REPLACE INTO plugin_bans (uuid, reason, ban_timestamp) VALUES (?, ?, ?)";
        long timestamp = System.currentTimeMillis();
        Object object = this.connectionLock;
        synchronized (object) {
            Connection conn = null;
            try {
                conn = this.getConnection();
                try (PreparedStatement pstmt = conn.prepareStatement(sql);){
                    pstmt.setString(1, uuid.toString());
                    pstmt.setString(2, reason);
                    pstmt.setLong(3, timestamp);
                    pstmt.executeUpdate();
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Could not add plugin ban record for UUID: " + String.valueOf(uuid), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public boolean isPlayerBannedByPlugin(UUID uuid) {
        String sql = "SELECT 1 FROM plugin_bans WHERE uuid = ? LIMIT 1";
        Object object = this.connectionLock;
        synchronized (object) {
            Connection conn = null;
            try {
                conn = this.getConnection();
                try (PreparedStatement pstmt = conn.prepareStatement(sql);){
                    boolean bl;
                    block17: {
                        pstmt.setString(1, uuid.toString());
                        ResultSet rs = pstmt.executeQuery();
                        try {
                            bl = rs.next();
                            if (rs == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return bl;
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Could not check plugin ban status for UUID: " + String.valueOf(uuid), e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePluginBan(UUID uuid) {
        String sql = "DELETE FROM plugin_bans WHERE uuid = ?";
        Object object = this.connectionLock;
        synchronized (object) {
            boolean bl;
            block12: {
                Connection conn = null;
                conn = this.getConnection();
                PreparedStatement pstmt = conn.prepareStatement(sql);
                try {
                    pstmt.setString(1, uuid.toString());
                    int affectedRows = pstmt.executeUpdate();
                    boolean bl2 = bl = affectedRows > 0;
                    if (pstmt == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (pstmt != null) {
                            try {
                                pstmt.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        this.plugin.getLogger().log(Level.SEVERE, "Could not remove plugin ban record for UUID: " + String.valueOf(uuid), e);
                    }
                }
                pstmt.close();
            }
            return bl;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalHeartBans() {
        String sql = "SELECT COUNT(*) AS ban_count FROM plugin_bans";
        int banCount = 0;
        Object object = this.connectionLock;
        synchronized (object) {
            Connection conn = null;
            try {
                conn = this.getConnection();
                try (Statement stmt = conn.createStatement();
                     ResultSet rs = stmt.executeQuery(sql);){
                    if (rs.next()) {
                        banCount = rs.getInt("ban_count");
                    }
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Could not retrieve total heart bans count from database!", e);
            }
        }
        return banCount;
    }
}

