/*
 * Decompiled with CFR 0.152.
 */
package com.jellypudding.simpleLifesteal.commands;

import com.jellypudding.simpleLifesteal.SimpleLifesteal;
import com.jellypudding.simpleLifesteal.database.DatabaseManager;
import com.jellypudding.simpleLifesteal.utils.BanCheckResult;
import com.jellypudding.simpleLifesteal.utils.PlayerUUIDUtil;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public class IsBannedCommand
implements CommandExecutor {
    private final SimpleLifesteal plugin;
    private final DatabaseManager databaseManager;
    private final String bedrockPrefix = ".";

    public IsBannedCommand(SimpleLifesteal plugin) {
        this.plugin = plugin;
        this.databaseManager = plugin.getDatabaseManager();
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length != 1) {
            sender.sendMessage((Component)Component.text((String)"Usage: /isbanned <player>", (TextColor)NamedTextColor.RED));
            return true;
        }
        String playerName = args[0];
        if (playerName.startsWith(".")) {
            sender.sendMessage((Component)Component.text((String)("CHECK_PENDING " + playerName)));
            PlayerUUIDUtil.fetchBedrockUUIDAsync(this.plugin, playerName, uuid -> {
                boolean banned;
                String status = uuid != null ? ((banned = this.databaseManager.isPlayerBannedByPlugin((UUID)uuid)) ? "BANNED" : "NOT_BANNED") : "ERROR";
                this.plugin.getPendingBanResults().put(playerName, new BanCheckResult(status));
            });
            return true;
        }
        OfflinePlayer targetPlayer = Bukkit.getOfflinePlayer((String)playerName);
        if (!targetPlayer.hasPlayedBefore() && !targetPlayer.isOnline()) {
            sender.sendMessage((Component)Component.text((String)("Player '" + playerName + "' not found."), (TextColor)NamedTextColor.RED));
            return true;
        }
        if (targetPlayer.isOnline()) {
            sender.sendMessage(Component.text((String)playerName, (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)" is not banned.", (TextColor)NamedTextColor.GREEN)));
            return true;
        }
        boolean bannedByPluginDB = this.databaseManager.isPlayerBannedByPlugin(targetPlayer.getUniqueId());
        if (bannedByPluginDB) {
            sender.sendMessage(Component.text((String)playerName, (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)" is banned.", (TextColor)NamedTextColor.RED)));
        } else {
            sender.sendMessage(Component.text((String)playerName, (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)" is not banned.", (TextColor)NamedTextColor.GREEN)));
        }
        return true;
    }
}

