/*
 * Decompiled with CFR 0.152.
 */
package com.jellypudding.simpleLifesteal.commands;

import com.jellypudding.simpleLifesteal.SimpleLifesteal;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class HeartRecipeCommand
implements CommandExecutor {
    private final SimpleLifesteal plugin;

    public HeartRecipeCommand(SimpleLifesteal plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!this.plugin.getConfig().getBoolean("heart-crafting.enabled", false)) {
            sender.sendMessage((Component)Component.text((String)"Heart crafting is currently disabled.", (TextColor)NamedTextColor.RED));
            return true;
        }
        try {
            List recipeConfig = this.plugin.getConfig().getList("heart-crafting.recipe");
            if (recipeConfig == null || recipeConfig.size() != 3) {
                sender.sendMessage((Component)Component.text((String)"Heart crafting recipe is not configured correctly.", (TextColor)NamedTextColor.RED));
                return true;
            }
            sender.sendMessage((Component)Component.text((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550", (TextColor)NamedTextColor.GOLD, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}));
            sender.sendMessage((Component)Component.text((String)" Heart Crafting Recipe", (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}));
            sender.sendMessage((Component)Component.text((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550", (TextColor)NamedTextColor.GOLD, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}));
            for (int row = 0; row < 3; ++row) {
                List rowItems = (List)recipeConfig.get(row);
                TextComponent rowComponent = Component.text((String)"  ");
                for (int col = 0; col < 3; ++col) {
                    String materialName = (String)rowItems.get(col);
                    Material material = this.parseMaterial(materialName);
                    if (material != null && material != Material.AIR) {
                        String displayName = this.formatMaterialName(materialName);
                        rowComponent = rowComponent.append((Component)Component.text((String)("[" + displayName + "]"), (TextColor)NamedTextColor.YELLOW));
                    } else {
                        rowComponent = rowComponent.append((Component)Component.text((String)"[Empty]", (TextColor)NamedTextColor.GRAY));
                    }
                    if (col >= 2) continue;
                    rowComponent = rowComponent.append((Component)Component.text((String)" "));
                }
                sender.sendMessage((Component)rowComponent);
            }
            sender.sendMessage((Component)Component.text((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550", (TextColor)NamedTextColor.GOLD, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}));
        }
        catch (Exception e) {
            sender.sendMessage((Component)Component.text((String)"Failed to display heart recipe. Contact an administrator.", (TextColor)NamedTextColor.RED));
            this.plugin.getLogger().severe("Error displaying heart recipe: " + e.getMessage());
        }
        return true;
    }

    private Material parseMaterial(String materialName) {
        if (materialName == null || materialName.trim().isEmpty() || materialName.equalsIgnoreCase("AIR")) {
            return Material.AIR;
        }
        try {
            return Material.valueOf((String)materialName.toUpperCase().trim());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private String formatMaterialName(String materialName) {
        if (materialName == null) {
            return "Empty";
        }
        String[] words = materialName.split("_");
        StringBuilder formatted = new StringBuilder();
        for (int i = 0; i < words.length; ++i) {
            String word = words[i];
            formatted.append(word.charAt(0)).append(word.substring(1).toLowerCase());
            if (i >= words.length - 1) continue;
            formatted.append(" ");
        }
        return formatted.toString();
    }
}

