/*
 * Decompiled with CFR 0.152.
 */
package com.jellypudding.simpleLifesteal.commands;

import com.jellypudding.simpleLifesteal.SimpleLifesteal;
import com.jellypudding.simpleLifesteal.utils.BanCheckResult;
import java.util.Iterator;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public class CheckBanResultCommand
implements CommandExecutor {
    private final SimpleLifesteal plugin;
    private final long resultTimeoutMillis = 15000L;

    public CheckBanResultCommand(SimpleLifesteal plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length != 1) {
            sender.sendMessage((Component)Component.text((String)"Usage: /checkbanresult <player>", (TextColor)NamedTextColor.RED));
            return true;
        }
        String playerName = args[0];
        Map<String, BanCheckResult> pendingResults = this.plugin.getPendingBanResults();
        Iterator<Map.Entry<String, BanCheckResult>> iterator = pendingResults.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, BanCheckResult> entry = iterator.next();
            if (!entry.getValue().isExpired(15000L)) continue;
            iterator.remove();
        }
        BanCheckResult result = pendingResults.get(playerName);
        if (result != null) {
            sender.sendMessage((Component)Component.text((String)result.getStatus()));
        } else {
            sender.sendMessage((Component)Component.text((String)"RESULT_PENDING"));
        }
        return true;
    }
}

