/*
 * Decompiled with CFR 0.152.
 */
package com.jellypudding.simpleLifesteal;

import com.jellypudding.discordRelay.DiscordRelayAPI;
import com.jellypudding.simpleLifesteal.Metrics;
import com.jellypudding.simpleLifesteal.commands.CheckBanResultCommand;
import com.jellypudding.simpleLifesteal.commands.HeartRecipeCommand;
import com.jellypudding.simpleLifesteal.commands.HeartWithdrawCommand;
import com.jellypudding.simpleLifesteal.commands.HeartsCommand;
import com.jellypudding.simpleLifesteal.commands.IsBannedCommand;
import com.jellypudding.simpleLifesteal.commands.SlUnbanCommand;
import com.jellypudding.simpleLifesteal.database.DatabaseManager;
import com.jellypudding.simpleLifesteal.listeners.PlayerListener;
import com.jellypudding.simpleLifesteal.managers.CraftingManager;
import com.jellypudding.simpleLifesteal.managers.PlayerDataManager;
import com.jellypudding.simpleLifesteal.utils.BanCheckResult;
import com.jellypudding.simpleLifesteal.utils.HeartItemUtil;
import java.sql.SQLException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class SimpleLifesteal
extends JavaPlugin {
    private int startingHearts;
    private int maxHearts;
    private String banMessage;
    private DatabaseManager databaseManager;
    private PlayerDataManager playerDataManager;
    private HeartItemUtil heartItemUtil;
    private CraftingManager craftingManager;
    private final Map<String, BanCheckResult> pendingBanResults = new ConcurrentHashMap<String, BanCheckResult>();
    private boolean discordRelayAPIReady = false;

    public void onEnable() {
        block8: {
            this.saveDefaultConfig();
            this.reloadConfig();
            this.startingHearts = this.getConfig().getInt("starting-hearts", 10);
            this.maxHearts = this.getConfig().getInt("maximum-hearts", 20);
            this.banMessage = this.getConfig().getString("ban-message", "You ran out of hearts!");
            this.getLogger().info("SimpleLifesteal enabled!");
            this.databaseManager = new DatabaseManager(this);
            try {
                this.databaseManager.getConnection();
            }
            catch (SQLException e) {
                this.getLogger().severe("Failed to initialise database! Disabling plugin.");
                this.getServer().getPluginManager().disablePlugin((Plugin)this);
                return;
            }
            this.playerDataManager = new PlayerDataManager(this);
            this.heartItemUtil = new HeartItemUtil(this);
            this.craftingManager = new CraftingManager(this, this.heartItemUtil);
            this.craftingManager.registerHeartRecipe();
            this.getCommand("hearts").setExecutor((CommandExecutor)new HeartsCommand(this));
            this.getCommand("withdrawheart").setExecutor((CommandExecutor)new HeartWithdrawCommand(this));
            this.getCommand("heartrecipe").setExecutor((CommandExecutor)new HeartRecipeCommand(this));
            this.getCommand("isbanned").setExecutor((CommandExecutor)new IsBannedCommand(this));
            this.getCommand("slunban").setExecutor((CommandExecutor)new SlUnbanCommand(this));
            this.getCommand("checkbanresult").setExecutor((CommandExecutor)new CheckBanResultCommand(this));
            this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(this), (Plugin)this);
            if (this.getServer().getPluginManager().isPluginEnabled("DiscordRelay")) {
                try {
                    this.discordRelayAPIReady = DiscordRelayAPI.isReady();
                    if (this.discordRelayAPIReady) {
                        this.getLogger().info("Successfully hooked into DiscordRelay.");
                        break block8;
                    }
                    this.getLogger().warning("DiscordRelay is loaded, but its API reported not ready (check DiscordRelay config/status).");
                }
                catch (NoClassDefFoundError e) {
                    this.getLogger().severe("DiscordRelay plugin found, but its API class (DiscordRelayAPI) is incompatible or missing. Cannot integrate. Update DiscordRelay?");
                    this.discordRelayAPIReady = false;
                }
                catch (Exception e) {
                    this.getLogger().log(Level.SEVERE, "An unexpected error occurred while checking DiscordRelay API.", e);
                    this.discordRelayAPIReady = false;
                }
            } else {
                this.getLogger().info("DiscordRelay plugin not found. Discord integration disabled.");
            }
        }
        int pluginId = 27543;
        new Metrics((Plugin)this, pluginId);
        this.getLogger().info("SimpleLifesteal fully enabled.");
    }

    public void onDisable() {
        if (this.playerDataManager != null) {
            this.playerDataManager.saveAllPlayerData();
        }
        if (this.craftingManager != null) {
            this.craftingManager.unregisterHeartRecipe();
        }
        this.getLogger().info("SimpleLifesteal disabled.");
        if (this.databaseManager != null) {
            this.databaseManager.closeConnection();
        }
    }

    public int getStartingHearts() {
        return this.startingHearts;
    }

    public int getMaxHearts() {
        return this.maxHearts;
    }

    public String getBanMessage() {
        return this.banMessage;
    }

    public Map<String, BanCheckResult> getPendingBanResults() {
        return this.pendingBanResults;
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public PlayerDataManager getPlayerDataManager() {
        return this.playerDataManager;
    }

    public HeartItemUtil getHeartItemUtil() {
        return this.heartItemUtil;
    }

    public boolean isDiscordRelayAPIReady() {
        return this.discordRelayAPIReady;
    }

    public boolean addHearts(UUID playerUuid, int amount) {
        if (this.playerDataManager == null) {
            this.getLogger().severe("Attempted to call addHearts API before PlayerDataManager was initialised!");
            return false;
        }
        return this.playerDataManager.givePlayerHearts(playerUuid, amount);
    }

    public int getPlayerHearts(UUID playerUuid) {
        if (this.playerDataManager == null) {
            this.getLogger().severe("Attempted to call getPlayerHearts API before PlayerDataManager was initialised!");
            return this.getStartingHearts();
        }
        return this.playerDataManager.getPlayerHearts(playerUuid);
    }

    public int getPlayerMaxHearts(UUID playerUuid) {
        if (this.playerDataManager == null) {
            this.getLogger().severe("Attempted to call getPlayerMaxHearts API before PlayerDataManager was initialised!");
            return this.getMaxHearts();
        }
        return this.playerDataManager.getPlayerMaxHearts(playerUuid);
    }

    public boolean setPlayerMaxHearts(UUID playerUuid, int maxHearts) {
        if (this.playerDataManager == null) {
            this.getLogger().severe("Attempted to call setPlayerMaxHearts API before PlayerDataManager was initialised!");
            return false;
        }
        if (maxHearts < 1) {
            return false;
        }
        this.playerDataManager.setPlayerMaxHearts(playerUuid, maxHearts);
        return true;
    }

    public boolean increasePlayerMaxHearts(UUID playerUuid, int amount) {
        if (this.playerDataManager == null) {
            this.getLogger().severe("Attempted to call increasePlayerMaxHearts API before PlayerDataManager was initialised!");
            return false;
        }
        return this.playerDataManager.increasePlayerMaxHearts(playerUuid, amount);
    }
}

