/*
 * Decompiled with CFR 0.152.
 */
package com.jellypudding.simpleHome;

import com.jellypudding.simpleHome.DatabaseManager;
import com.jellypudding.simpleHome.Metrics;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SimpleHome
extends JavaPlugin
implements Listener {
    private DatabaseManager databaseManager;
    private final String defaultHomeName = "home";
    private int maxHomeLimit = 10;
    private boolean allowCrossDimensionTeleport = false;

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfigValues();
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        this.databaseManager = new DatabaseManager(this, this.maxHomeLimit);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        Objects.requireNonNull(this.getCommand("sethome")).setExecutor((CommandExecutor)this);
        Objects.requireNonNull(this.getCommand("sethome")).setTabCompleter((TabCompleter)this);
        Objects.requireNonNull(this.getCommand("home")).setExecutor((CommandExecutor)this);
        Objects.requireNonNull(this.getCommand("home")).setTabCompleter((TabCompleter)this);
        Objects.requireNonNull(this.getCommand("delhome")).setExecutor((CommandExecutor)this);
        Objects.requireNonNull(this.getCommand("delhome")).setTabCompleter((TabCompleter)this);
        Objects.requireNonNull(this.getCommand("homes")).setExecutor((CommandExecutor)this);
        Objects.requireNonNull(this.getCommand("homes")).setTabCompleter((TabCompleter)this);
        Objects.requireNonNull(this.getCommand("homeadmin")).setExecutor((CommandExecutor)this);
        Objects.requireNonNull(this.getCommand("homeadmin")).setTabCompleter((TabCompleter)this);
        int pluginId = 27541;
        new Metrics((Plugin)this, pluginId);
        this.getLogger().info("SimpleHome has been enabled!");
    }

    public void onDisable() {
        if (this.databaseManager != null) {
            this.databaseManager.closeConnection();
        }
        this.getLogger().info("SimpleHome has been disabled!");
    }

    private void loadConfigValues() {
        FileConfiguration config = this.getConfig();
        int configuredLimit = config.getInt("max-home-limit", 10);
        if (configuredLimit < 1) {
            this.getLogger().warning("Invalid max-home-limit in config.yml (must be >= 1). Using default value: 10");
            this.maxHomeLimit = 10;
        } else {
            this.maxHomeLimit = configuredLimit;
        }
        this.allowCrossDimensionTeleport = config.getBoolean("allow-cross-dimension-teleport", false);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        String commandName = command.getName().toLowerCase();
        if (commandName.equals("homeadmin")) {
            this.handleHomeAdmin(sender, args);
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(Component.text((String)"This command can only be used by players!").color((TextColor)NamedTextColor.RED));
            return true;
        }
        Player player = (Player)sender;
        switch (commandName) {
            case "sethome": {
                this.handleSetHome(player, args);
                break;
            }
            case "home": {
                this.handleHome(player, args);
                break;
            }
            case "delhome": {
                this.handleDelHome(player, args);
                break;
            }
            case "homes": {
                this.handleHomes(player);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        String commandName = command.getName().toLowerCase();
        if (commandName.equals("homeadmin")) {
            if (!sender.hasPermission("simplehome.admin")) {
                return Collections.emptyList();
            }
            if (args.length == 1) {
                String currentArg = args[0].toLowerCase();
                return List.of("increase", "decrease", "get", "visit").stream().filter(action -> action.startsWith(currentArg)).collect(Collectors.toList());
            }
            if (args.length == 2 && (args[0].equalsIgnoreCase("increase") || args[0].equalsIgnoreCase("decrease") || args[0].equalsIgnoreCase("get") || args[0].equalsIgnoreCase("visit"))) {
                String currentArg = args[1].toLowerCase();
                return this.getServer().getOnlinePlayers().stream().map(p -> p.getName()).filter(name -> name.toLowerCase().startsWith(currentArg)).collect(Collectors.toList());
            }
            if (args.length == 3 && args[0].equalsIgnoreCase("visit")) {
                String currentArg = args[2].toLowerCase();
                UUID targetUUID = this.getPlayerUUID(args[1]);
                if (targetUUID != null) {
                    List<String> homeNames = this.databaseManager.getHomes(targetUUID);
                    return homeNames.stream().filter(name -> name.toLowerCase().startsWith(currentArg)).collect(Collectors.toList());
                }
            }
        }
        if (!(sender instanceof Player)) {
            return Collections.emptyList();
        }
        Player player = (Player)sender;
        if ((commandName.equals("home") || commandName.equals("delhome")) && args.length == 1) {
            String currentArg = args[0].toLowerCase();
            List<String> homeNames = this.databaseManager.getHomes(player.getUniqueId());
            return homeNames.stream().filter(name -> name.toLowerCase().startsWith(currentArg)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private void handleSetHome(Player player, String[] args) {
        String homeName;
        String string = homeName = args.length > 0 ? args[0] : "home";
        if (!this.isValidHomeName(homeName)) {
            player.sendMessage(Component.text((String)"Invalid home name. Use letters, numbers, underscores, or hyphens.").color((TextColor)NamedTextColor.RED));
            return;
        }
        int currentHomeCount = this.databaseManager.getHomeCount(player.getUniqueId());
        int homeLimit = this.databaseManager.getHomeLimit(player.getUniqueId());
        boolean isUpdating = this.databaseManager.getHomes(player.getUniqueId()).contains(homeName.toLowerCase());
        if (!isUpdating && currentHomeCount >= homeLimit) {
            player.sendMessage(Component.text((String)("You have reached your home limit of " + homeLimit + ".")).color((TextColor)NamedTextColor.RED));
            return;
        }
        Location location = player.getLocation();
        if (this.databaseManager.setHome(player.getUniqueId(), homeName, location)) {
            player.sendMessage(Component.text((String)"Home set.").color((TextColor)NamedTextColor.GREEN));
        } else {
            player.sendMessage(Component.text((String)("Failed to set home '" + homeName + ".")).color((TextColor)NamedTextColor.RED));
        }
    }

    private void handleHome(Player player, String[] args) {
        String homeName = args.length > 0 ? args[0] : "home";
        Location location = this.databaseManager.getHome(player.getUniqueId(), homeName);
        if (location == null) {
            player.sendMessage(Component.text((String)("Home '" + homeName + "' not found or its world is not loaded.")).color((TextColor)NamedTextColor.RED));
            return;
        }
        if (!this.allowCrossDimensionTeleport && !player.getWorld().equals((Object)location.getWorld())) {
            player.sendMessage(Component.text((String)"You cannot teleport to this home as it is in a different dimension.").color((TextColor)NamedTextColor.RED));
            return;
        }
        player.teleportAsync(location).thenAccept(success -> {
            if (success.booleanValue()) {
                player.sendMessage(Component.text((String)"Teleported to your home.").color((TextColor)NamedTextColor.GREEN));
            } else {
                player.sendMessage(Component.text((String)"Teleportation failed.").color((TextColor)NamedTextColor.RED));
            }
        });
    }

    private void handleDelHome(Player player, String[] args) {
        if (args.length == 0) {
            player.sendMessage(Component.text((String)"Usage: /delhome <name>").color((TextColor)NamedTextColor.RED));
            return;
        }
        String homeName = args[0];
        if (this.databaseManager.deleteHome(player.getUniqueId(), homeName)) {
            player.sendMessage(Component.text((String)("Home '" + homeName + "' deleted.")).color((TextColor)NamedTextColor.GREEN));
        } else {
            player.sendMessage(Component.text((String)("Home '" + homeName + "' not found.")).color((TextColor)NamedTextColor.RED));
        }
    }

    private void handleHomes(Player player) {
        List<String> homeNames = this.databaseManager.getHomes(player.getUniqueId());
        int homeLimit = this.databaseManager.getHomeLimit(player.getUniqueId());
        if (homeNames.isEmpty()) {
            player.sendMessage(Component.text((String)"You have no homes set. Use /sethome [name]").color((TextColor)NamedTextColor.YELLOW));
        } else {
            TextComponent homesText = (TextComponent)Component.text((String)("Your homes (" + homeNames.size() + "/" + homeLimit + "): ")).color((TextColor)NamedTextColor.GOLD);
            int size = homeNames.size();
            for (int i = 0; i < size; ++i) {
                String name = homeNames.get(i);
                TextComponent homesNameText = (TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)name).clickEvent(ClickEvent.suggestCommand((String)("/home " + name)))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to use command.")))).decoration(TextDecoration.UNDERLINED, true)).color((TextColor)NamedTextColor.WHITE);
                homesText = (TextComponent)homesText.append((Component)homesNameText);
                if (i >= size - 1) continue;
                homesText = (TextComponent)homesText.append(Component.text((String)", ").color((TextColor)NamedTextColor.WHITE));
            }
            player.sendMessage((Component)homesText);
        }
    }

    private void handleHomeAdmin(CommandSender sender, String[] args) {
        if (!sender.hasPermission("simplehome.admin")) {
            sender.sendMessage(Component.text((String)"You don't have permission to use this command.").color((TextColor)NamedTextColor.RED));
            return;
        }
        if (args.length < 2) {
            sender.sendMessage(Component.text((String)"Usage: /homeadmin <increase|decrease|get|visit> <player> [home_name]").color((TextColor)NamedTextColor.RED));
            return;
        }
        String action = args[0].toLowerCase();
        String playerName = args[1];
        switch (action) {
            case "increase": 
            case "decrease": {
                UUID targetUUID = this.getPlayerUUID(playerName);
                if (targetUUID == null) {
                    sender.sendMessage(Component.text((String)("Player '" + playerName + "' not found. Make sure the name is spelled correctly.")).color((TextColor)NamedTextColor.RED));
                    return;
                }
                Player onlinePlayer = this.getServer().getPlayer(playerName);
                this.handleHomeLimitChange(sender, playerName, targetUUID, onlinePlayer, action);
                break;
            }
            case "get": 
            case "visit": {
                UUID targetUUID2 = this.getPlayerUUID(playerName);
                if (targetUUID2 == null) {
                    sender.sendMessage(Component.text((String)("Player '" + playerName + "' not found. Make sure the name is spelled correctly.")).color((TextColor)NamedTextColor.RED));
                    return;
                }
                if (action.equals("get")) {
                    this.handleHomeInfo(sender, playerName, targetUUID2);
                    break;
                }
                this.handleHomeVisit(sender, args, playerName, targetUUID2);
                break;
            }
            default: {
                sender.sendMessage(Component.text((String)"Invalid action. Use 'increase', 'decrease', 'get', or 'visit'.").color((TextColor)NamedTextColor.RED));
            }
        }
    }

    private void handleHomeLimitChange(CommandSender sender, String playerName, UUID targetUUID, Player onlinePlayer, String action) {
        int currentLimit = this.databaseManager.getHomeLimit(targetUUID);
        if (action.equals("increase")) {
            if (currentLimit >= this.maxHomeLimit) {
                sender.sendMessage(Component.text((String)(playerName + " is already at the maximum home limit (" + this.maxHomeLimit + ").")).color((TextColor)NamedTextColor.RED));
                return;
            }
            if (this.databaseManager.setHomeLimit(targetUUID, currentLimit + 1)) {
                sender.sendMessage(Component.text((String)("Increased " + playerName + "'s home limit from " + currentLimit + " to " + (currentLimit + 1) + ".")).color((TextColor)NamedTextColor.GREEN));
                if (onlinePlayer != null) {
                    onlinePlayer.sendMessage(Component.text((String)("Your home limit has been increased to " + (currentLimit + 1) + ".")).color((TextColor)NamedTextColor.GREEN));
                }
            } else {
                sender.sendMessage(Component.text((String)("Failed to increase " + playerName + "'s home limit.")).color((TextColor)NamedTextColor.RED));
            }
        } else {
            int newLimit;
            if (currentLimit <= 1) {
                sender.sendMessage(Component.text((String)(playerName + " is already at the minimum home limit (1).")).color((TextColor)NamedTextColor.RED));
                return;
            }
            int currentHomes = this.databaseManager.getHomeCount(targetUUID);
            if (currentHomes > (newLimit = currentLimit - 1)) {
                List<String> homeNames = this.databaseManager.getHomes(targetUUID);
                int homesToDelete = currentHomes - newLimit;
                for (int i = homeNames.size() - 1; i >= homeNames.size() - homesToDelete; --i) {
                    String homeToDelete = homeNames.get(i);
                    if (!this.databaseManager.deleteHome(targetUUID, homeToDelete)) continue;
                    sender.sendMessage(Component.text((String)("Auto-deleted home '" + homeToDelete + "' from " + playerName + ".")).color((TextColor)NamedTextColor.YELLOW));
                    if (onlinePlayer == null) continue;
                    onlinePlayer.sendMessage(Component.text((String)("Your home '" + homeToDelete + "' was deleted due to a limit decrease.")).color((TextColor)NamedTextColor.YELLOW));
                }
            }
            if (this.databaseManager.setHomeLimit(targetUUID, newLimit)) {
                sender.sendMessage(Component.text((String)("Decreased " + playerName + "'s home limit from " + currentLimit + " to " + newLimit + ".")).color((TextColor)NamedTextColor.GREEN));
                if (onlinePlayer != null) {
                    onlinePlayer.sendMessage(Component.text((String)("Your home limit has been decreased to " + newLimit + ".")).color((TextColor)NamedTextColor.YELLOW));
                }
            } else {
                sender.sendMessage(Component.text((String)("Failed to decrease " + playerName + "'s home limit.")).color((TextColor)NamedTextColor.RED));
            }
        }
    }

    private void handleHomeInfo(CommandSender sender, String playerName, UUID targetUUID) {
        int currentLimit = this.databaseManager.getHomeLimit(targetUUID);
        int homeCount = this.databaseManager.getHomeCount(targetUUID);
        List<String> homeNames = this.databaseManager.getHomes(targetUUID);
        sender.sendMessage(Component.text((String)(playerName + "'s home info:")).color((TextColor)NamedTextColor.GOLD));
        sender.sendMessage(Component.text((String)("  Current homes: " + homeCount + " / " + currentLimit)).color((TextColor)NamedTextColor.YELLOW));
        if (homeNames.isEmpty()) {
            sender.sendMessage(Component.text((String)"  No homes set.").color((TextColor)NamedTextColor.GRAY));
        } else {
            TextComponent homesText = (TextComponent)Component.text((String)"  Home names: ").color((TextColor)NamedTextColor.AQUA);
            int size = homeNames.size();
            for (int i = 0; i < size; ++i) {
                String name = homeNames.get(i);
                TextComponent homeNameComponent = (TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)name).clickEvent(ClickEvent.suggestCommand((String)("/homeadmin visit " + playerName + " " + name)))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to teleport to this home")))).decoration(TextDecoration.UNDERLINED, true)).color((TextColor)NamedTextColor.WHITE);
                homesText = (TextComponent)homesText.append((Component)homeNameComponent);
                if (i >= size - 1) continue;
                homesText = (TextComponent)homesText.append(Component.text((String)", ").color((TextColor)NamedTextColor.WHITE));
            }
            sender.sendMessage((Component)homesText);
        }
    }

    private void handleHomeVisit(CommandSender sender, String[] args, String playerName, UUID targetUUID) {
        if (args.length < 3) {
            sender.sendMessage(Component.text((String)"Usage: /homeadmin visit <player> <home_name>").color((TextColor)NamedTextColor.RED));
            return;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(Component.text((String)"This command can only be used by players!").color((TextColor)NamedTextColor.RED));
            return;
        }
        Player adminPlayer = (Player)sender;
        String homeName = args[2];
        Location homeLocation = this.databaseManager.getHome(targetUUID, homeName);
        if (homeLocation == null) {
            sender.sendMessage(Component.text((String)("Home '" + homeName + "' not found for player '" + playerName + "' or its world is not loaded.")).color((TextColor)NamedTextColor.RED));
            return;
        }
        adminPlayer.teleportAsync(homeLocation).thenAccept(success -> {
            if (success.booleanValue()) {
                adminPlayer.sendMessage(Component.text((String)("Teleported to " + playerName + "'s home '" + homeName + "'.")).color((TextColor)NamedTextColor.GREEN));
            } else {
                adminPlayer.sendMessage(Component.text((String)"Teleportation failed.").color((TextColor)NamedTextColor.RED));
            }
        });
    }

    private boolean isValidHomeName(String name) {
        return name != null && !name.isEmpty() && name.matches("^[a-zA-Z0-9_-]+$") && name.length() <= 30;
    }

    private UUID getPlayerUUID(String playerName) {
        Player onlinePlayer = this.getServer().getPlayer(playerName);
        if (onlinePlayer != null) {
            return onlinePlayer.getUniqueId();
        }
        OfflinePlayer offlinePlayer = this.getServer().getOfflinePlayer(playerName);
        if (offlinePlayer != null && offlinePlayer.hasPlayedBefore()) {
            return offlinePlayer.getUniqueId();
        }
        return null;
    }

    public int getHomeLimit(UUID playerUUID) {
        if (this.databaseManager == null) {
            this.getLogger().warning("Attempted to get home limit, but DatabaseManager is null.");
            return 1;
        }
        return this.databaseManager.getHomeLimit(playerUUID);
    }

    public boolean increaseHomeLimit(UUID playerUUID) {
        if (this.databaseManager == null) {
            this.getLogger().severe("Attempted to increase home limit, but DatabaseManager is null.");
            return false;
        }
        if (this.getHomeLimit(playerUUID) >= this.maxHomeLimit) {
            return false;
        }
        boolean success = this.databaseManager.increaseHomeLimit(playerUUID);
        return success;
    }

    public int getCurrentHomeCount(UUID playerUUID) {
        if (this.databaseManager == null) {
            this.getLogger().warning("Attempted to get home count, but DatabaseManager is null.");
            return 0;
        }
        return this.databaseManager.getHomeCount(playerUUID);
    }
}

