/*
 * Decompiled with CFR 0.152.
 */
package com.jellypudding.simpleHome;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.plugin.java.JavaPlugin;

public class DatabaseManager {
    private final JavaPlugin plugin;
    private Connection connection;
    private final String databasePath;
    private int maxHomeLimit;

    public DatabaseManager(JavaPlugin plugin, int maxHomeLimit) {
        this.plugin = plugin;
        this.maxHomeLimit = maxHomeLimit;
        if (!plugin.getDataFolder().exists()) {
            plugin.getDataFolder().mkdirs();
        }
        this.databasePath = "jdbc:sqlite:" + new File(plugin.getDataFolder(), "homes.db").getAbsolutePath();
        this.connect();
        this.initialisedatabase(this.maxHomeLimit);
    }

    private void connect() {
        try {
            Class.forName("org.sqlite.JDBC");
            this.connection = DriverManager.getConnection(this.databasePath);
            this.plugin.getLogger().info("Successfully connected to SQLite database.");
        }
        catch (ClassNotFoundException | SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not connect to SQLite database: " + e.getMessage(), e);
            this.connection = null;
        }
    }

    private void initialisedatabase(int limit) {
        if (this.connection == null) {
            return;
        }
        String sqlHomes = "CREATE TABLE IF NOT EXISTS player_homes ( uuid TEXT NOT NULL, home_name TEXT NOT NULL COLLATE NOCASE, world TEXT NOT NULL, x REAL NOT NULL, y REAL NOT NULL, z REAL NOT NULL, yaw REAL NOT NULL, pitch REAL NOT NULL, PRIMARY KEY (uuid, home_name));";
        String sqlLimits = "CREATE TABLE IF NOT EXISTS player_home_limits ( uuid TEXT PRIMARY KEY NOT NULL, max_homes INTEGER NOT NULL DEFAULT 1 CHECK(max_homes >= 1 AND max_homes <= " + limit + "));";
        try (Statement stmt = this.connection.createStatement();){
            stmt.execute(sqlHomes);
            this.plugin.getLogger().info("Database table 'player_homes' initialised.");
            stmt.execute(sqlLimits);
            this.plugin.getLogger().info("Database table 'player_home_limits' initialised.");
            this.migrateHomeLimitsSchema(limit);
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not create database tables: " + e.getMessage(), e);
        }
    }

    private void migrateHomeLimitsSchema(int newLimit) {
        block30: {
            if (this.connection == null) {
                return;
            }
            try {
                String testSql = "INSERT OR IGNORE INTO player_home_limits (uuid, max_homes) VALUES (?, ?)";
                String testUuid = "test-constraint-check-uuid";
                try (PreparedStatement testStmt = this.connection.prepareStatement(testSql);){
                    testStmt.setString(1, testUuid);
                    testStmt.setInt(2, newLimit);
                    testStmt.executeUpdate();
                    String checkSql = "SELECT max_homes FROM player_home_limits WHERE uuid = ?";
                    try (PreparedStatement checkStmt = this.connection.prepareStatement(checkSql);){
                        checkStmt.setString(1, testUuid);
                        ResultSet rs = checkStmt.executeQuery();
                        if (!rs.next() || rs.getInt("max_homes") != newLimit) break block30;
                        String deleteSql = "DELETE FROM player_home_limits WHERE uuid = ?";
                        try (PreparedStatement deleteStmt = this.connection.prepareStatement(deleteSql);){
                            deleteStmt.setString(1, testUuid);
                            deleteStmt.executeUpdate();
                        }
                        this.plugin.getLogger().info("Database schema is compatible with max home limit: " + newLimit);
                        return;
                    }
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().info("Database constraint needs updating for new max home limit: " + newLimit);
            }
        }
        try (Statement stmt = this.connection.createStatement();){
            this.plugin.getLogger().info("Migrating player_home_limits table for new max limit: " + newLimit);
            String createTempSql = "CREATE TABLE player_home_limits_temp ( uuid TEXT PRIMARY KEY NOT NULL, max_homes INTEGER NOT NULL DEFAULT 1 CHECK(max_homes >= 1 AND max_homes <= " + newLimit + "));";
            stmt.execute(createTempSql);
            String copySql = "INSERT INTO player_home_limits_temp (uuid, max_homes) SELECT uuid, MIN(max_homes, " + newLimit + ") FROM player_home_limits";
            stmt.execute(copySql);
            stmt.execute("DROP TABLE player_home_limits");
            stmt.execute("ALTER TABLE player_home_limits_temp RENAME TO player_home_limits");
            this.plugin.getLogger().info("Successfully migrated player_home_limits table to support max limit: " + newLimit);
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to migrate database schema: " + e.getMessage(), e);
        }
    }

    public void closeConnection() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
                this.plugin.getLogger().info("Database connection closed.");
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not close database connection: " + e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getHomeLimit(UUID uuid) {
        if (this.connection == null) {
            return 1;
        }
        String sql = "SELECT max_homes FROM player_home_limits WHERE uuid = ?";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, uuid.toString());
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) return 1;
            int n = rs.getInt("max_homes");
            return n;
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not retrieve home limit for " + String.valueOf(uuid) + ": " + e.getMessage(), e);
        }
        return 1;
    }

    public boolean increaseHomeLimit(UUID uuid) {
        boolean bl;
        block10: {
            if (this.connection == null) {
                return false;
            }
            int currentLimit = this.getHomeLimit(uuid);
            if (currentLimit >= this.maxHomeLimit) {
                return false;
            }
            int newLimit = currentLimit + 1;
            String sql = "INSERT OR REPLACE INTO player_home_limits (uuid, max_homes) VALUES (?, ?)";
            PreparedStatement pstmt = this.connection.prepareStatement(sql);
            try {
                pstmt.setString(1, uuid.toString());
                pstmt.setInt(2, newLimit);
                pstmt.executeUpdate();
                this.plugin.getLogger().info("Increased home limit for " + String.valueOf(uuid) + " to " + newLimit);
                bl = true;
                if (pstmt == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (pstmt != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.plugin.getLogger().log(Level.SEVERE, "Could not increase home limit for " + String.valueOf(uuid) + ": " + e.getMessage(), e);
                    return false;
                }
            }
            pstmt.close();
        }
        return bl;
    }

    public boolean setHomeLimit(UUID uuid, int limit) {
        boolean bl;
        block10: {
            if (this.connection == null) {
                return false;
            }
            if (limit < 1 || limit > this.maxHomeLimit) {
                return false;
            }
            String sql = "INSERT OR REPLACE INTO player_home_limits (uuid, max_homes) VALUES (?, ?)";
            PreparedStatement pstmt = this.connection.prepareStatement(sql);
            try {
                pstmt.setString(1, uuid.toString());
                pstmt.setInt(2, limit);
                pstmt.executeUpdate();
                this.plugin.getLogger().info("Set home limit for " + String.valueOf(uuid) + " to " + limit);
                bl = true;
                if (pstmt == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (pstmt != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.plugin.getLogger().log(Level.SEVERE, "Could not set home limit for " + String.valueOf(uuid) + ": " + e.getMessage(), e);
                    return false;
                }
            }
            pstmt.close();
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getHomeCount(UUID uuid) {
        if (this.connection == null) {
            return 0;
        }
        String sql = "SELECT COUNT(*) FROM player_homes WHERE uuid = ?";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, uuid.toString());
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) return 0;
            int n = rs.getInt(1);
            return n;
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not retrieve home count for " + String.valueOf(uuid) + ": " + e.getMessage(), e);
        }
        return 0;
    }

    public boolean setHome(UUID uuid, String homeName, Location location) {
        boolean bl;
        block9: {
            if (this.connection == null) {
                return false;
            }
            String sql = "REPLACE INTO player_homes (uuid, home_name, world, x, y, z, yaw, pitch) VALUES(?, ?, ?, ?, ?, ?, ?, ?)";
            PreparedStatement pstmt = this.connection.prepareStatement(sql);
            try {
                pstmt.setString(1, uuid.toString());
                pstmt.setString(2, homeName.toLowerCase());
                pstmt.setString(3, location.getWorld().getName());
                pstmt.setDouble(4, location.getX());
                pstmt.setDouble(5, location.getY());
                pstmt.setDouble(6, location.getZ());
                pstmt.setFloat(7, location.getYaw());
                pstmt.setFloat(8, location.getPitch());
                pstmt.executeUpdate();
                bl = true;
                if (pstmt == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (pstmt != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.plugin.getLogger().log(Level.SEVERE, "Could not save home '" + homeName + "' for " + String.valueOf(uuid) + ": " + e.getMessage(), e);
                    return false;
                }
            }
            pstmt.close();
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Location getHome(UUID uuid, String homeName) {
        if (this.connection == null) {
            return null;
        }
        String sql = "SELECT world, x, y, z, yaw, pitch FROM player_homes WHERE uuid = ? AND home_name = ?";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, uuid.toString());
            pstmt.setString(2, homeName.toLowerCase());
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) return null;
            String worldName = rs.getString("world");
            World world = this.plugin.getServer().getWorld(worldName);
            if (world == null) {
                this.plugin.getLogger().warning("World '" + worldName + "' not found for home '" + homeName + "' of " + String.valueOf(uuid));
                Location location = null;
                return location;
            }
            double x = rs.getDouble("x");
            double y = rs.getDouble("y");
            double z = rs.getDouble("z");
            float yaw = rs.getFloat("yaw");
            float pitch = rs.getFloat("pitch");
            Location location = new Location(world, x, y, z, yaw, pitch);
            return location;
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not retrieve home '" + homeName + "' for " + String.valueOf(uuid) + ": " + e.getMessage(), e);
        }
        return null;
    }

    public List<String> getHomes(UUID uuid) {
        if (this.connection == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> homeNames = new ArrayList<String>();
        String sql = "SELECT home_name FROM player_homes WHERE uuid = ? ORDER BY home_name";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, uuid.toString());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                homeNames.add(rs.getString("home_name"));
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not retrieve home list for " + String.valueOf(uuid) + ": " + e.getMessage(), e);
        }
        return homeNames;
    }

    public boolean deleteHome(UUID uuid, String homeName) {
        boolean bl;
        block9: {
            if (this.connection == null) {
                return false;
            }
            String sql = "DELETE FROM player_homes WHERE uuid = ? AND home_name = ?";
            PreparedStatement pstmt = this.connection.prepareStatement(sql);
            try {
                pstmt.setString(1, uuid.toString());
                pstmt.setString(2, homeName.toLowerCase());
                int affectedRows = pstmt.executeUpdate();
                boolean bl2 = bl = affectedRows > 0;
                if (pstmt == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (pstmt != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.plugin.getLogger().log(Level.SEVERE, "Could not delete home '" + homeName + "' for " + String.valueOf(uuid) + ": " + e.getMessage(), e);
                    return false;
                }
            }
            pstmt.close();
        }
        return bl;
    }
}

