/*
 * Decompiled with CFR 0.152.
 */
package com.jellypudding.scheduledAnnouncements;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import com.jellypudding.scheduledAnnouncements.Metrics;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class ScheduledAnnouncements
extends JavaPlugin
implements TabCompleter {
    private Map<String, AnnouncementConfig> announcements;
    private CronParser cronParser;
    private String globalPrefixText;
    private NamedTextColor globalPrefixColor;
    private NamedTextColor globalMessageColor;

    public void onEnable() {
        this.saveDefaultConfig();
        this.cronParser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor(CronType.QUARTZ));
        this.announcements = new HashMap<String, AnnouncementConfig>();
        this.loadConfig();
        this.startAnnouncementTask();
        Objects.requireNonNull(this.getCommand("scheduledannouncements")).setExecutor((CommandExecutor)this);
        Objects.requireNonNull(this.getCommand("scheduledannouncements")).setTabCompleter((TabCompleter)this);
        int pluginId = 27565;
        new Metrics((Plugin)this, pluginId);
        this.getLogger().info("ScheduledAnnouncements plugin has been enabled!");
    }

    public void onDisable() {
        Bukkit.getScheduler().cancelTasks((Plugin)this);
        this.getLogger().info("ScheduledAnnouncements plugin has been disabled.");
    }

    private void loadConfig() {
        ConfigurationSection announcementsSection;
        this.reloadConfig();
        this.announcements.clear();
        FileConfiguration config = this.getConfig();
        ConfigurationSection settingsSection = config.getConfigurationSection("settings");
        if (settingsSection != null) {
            ConfigurationSection prefixSection = settingsSection.getConfigurationSection("prefix");
            if (prefixSection != null) {
                this.globalPrefixText = prefixSection.getString("text", "[Announcement]");
                String prefixColorName = prefixSection.getString("color", "gold");
                this.globalPrefixColor = (NamedTextColor)NamedTextColor.NAMES.value((Object)prefixColorName.toLowerCase());
                if (this.globalPrefixColor == null) {
                    this.globalPrefixColor = NamedTextColor.GOLD;
                }
            }
            String messageColorName = settingsSection.getString("message_color", "yellow");
            this.globalMessageColor = (NamedTextColor)NamedTextColor.NAMES.value((Object)messageColorName.toLowerCase());
            if (this.globalMessageColor == null) {
                this.globalMessageColor = NamedTextColor.YELLOW;
            }
        }
        if ((announcementsSection = config.getConfigurationSection("announcements")) != null) {
            for (String key : announcementsSection.getKeys(false)) {
                String cronExpression = announcementsSection.getString(key + ".cron");
                String message = announcementsSection.getString(key + ".message");
                if (cronExpression == null || message == null) continue;
                try {
                    Cron cron = this.cronParser.parse(cronExpression);
                    ExecutionTime executionTime = ExecutionTime.forCron(cron);
                    String prefixText = this.globalPrefixText;
                    NamedTextColor prefixColor = this.globalPrefixColor;
                    NamedTextColor messageColor = this.globalMessageColor;
                    ConfigurationSection annSection = announcementsSection.getConfigurationSection(key);
                    if (annSection != null) {
                        NamedTextColor annMessageColor;
                        String annMessageColorName;
                        ConfigurationSection annPrefixSection = annSection.getConfigurationSection("prefix");
                        if (annPrefixSection != null) {
                            NamedTextColor annPrefixColor;
                            prefixText = annPrefixSection.getString("text", this.globalPrefixText);
                            String annPrefixColorName = annPrefixSection.getString("color");
                            if (annPrefixColorName != null && (annPrefixColor = (NamedTextColor)NamedTextColor.NAMES.value((Object)annPrefixColorName.toLowerCase())) != null) {
                                prefixColor = annPrefixColor;
                            }
                        }
                        if ((annMessageColorName = annSection.getString("message_color")) != null && (annMessageColor = (NamedTextColor)NamedTextColor.NAMES.value((Object)annMessageColorName.toLowerCase())) != null) {
                            messageColor = annMessageColor;
                        }
                    }
                    this.announcements.put(key, new AnnouncementConfig(message, executionTime, prefixText, prefixColor, messageColor));
                }
                catch (IllegalArgumentException e) {
                    this.getLogger().warning("Invalid cron expression for announcement: " + key);
                }
            }
        }
    }

    private void startAnnouncementTask() {
        Bukkit.getScheduler().runTaskTimer((Plugin)this, this::checkAndBroadcastAnnouncements, 20L, 20L);
    }

    private void checkAndBroadcastAnnouncements() {
        ZonedDateTime now = ZonedDateTime.now();
        for (Map.Entry<String, AnnouncementConfig> entry : this.announcements.entrySet()) {
            if (!entry.getValue().executionTime.isMatch(now)) continue;
            this.broadcastAnnouncement(entry.getValue());
        }
    }

    private void broadcastAnnouncement(AnnouncementConfig config) {
        Component message = this.parseAnnouncement(config);
        Bukkit.getServer().broadcast(message);
    }

    private Component parseAnnouncement(AnnouncementConfig config) {
        String[] parts = config.message.split("\\|");
        TextComponent message = Component.empty();
        if (!config.prefixText.isEmpty()) {
            message = message.append((Component)Component.text((String)(config.prefixText + " "), (TextColor)config.prefixColor));
        }
        TextComponent contentComponent = Component.text((String)parts[0].trim(), (TextColor)config.messageColor);
        if (parts.length > 1) {
            String url = parts[1].trim();
            contentComponent = contentComponent.clickEvent(ClickEvent.openUrl((String)url));
        }
        message = message.append((Component)contentComponent);
        return message;
    }

    public boolean onCommand(@NotNull CommandSender sender, Command command, @NotNull String label, String[] args) {
        if (command.getName().equalsIgnoreCase("scheduledannouncements") && args.length > 0 && args[0].equalsIgnoreCase("reload")) {
            if (sender.hasPermission("scheduledannouncements.reload")) {
                this.loadConfig();
                sender.sendMessage((Component)Component.text((String)"ScheduledAnnouncements config reloaded!", (TextColor)NamedTextColor.GREEN));
                return true;
            }
            sender.sendMessage((Component)Component.text((String)"You don't have permission to reload the config.", (TextColor)NamedTextColor.RED));
            return true;
        }
        return false;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, Command command, @NotNull String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (command.getName().equalsIgnoreCase("scheduledannouncements") && args.length == 1) {
            completions.add("reload");
        }
        return completions;
    }

    private static class AnnouncementConfig {
        String message;
        ExecutionTime executionTime;
        String prefixText;
        NamedTextColor prefixColor;
        NamedTextColor messageColor;

        AnnouncementConfig(String message, ExecutionTime executionTime, String prefixText, NamedTextColor prefixColor, NamedTextColor messageColor) {
            this.message = message;
            this.executionTime = executionTime;
            this.prefixText = prefixText;
            this.prefixColor = prefixColor;
            this.messageColor = messageColor;
        }
    }
}

