/*
 * Decompiled with CFR 0.152.
 */
package com.jellypudding.netherRoofBlocker;

import com.jellypudding.netherRoofBlocker.NetherRoofBlocker;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class NetherRoofListener
extends BukkitRunnable {
    private static final int NETHER_ROOF_Y = 128;
    private static final int SEARCH_START_Y = 120;
    private static final int MAX_HORIZONTAL_SEARCH = 5;
    private final Set<Material> unsafeBlocks;
    private final NetherRoofBlocker plugin;

    public NetherRoofListener(Set<Material> unsafeBlocks, NetherRoofBlocker plugin) {
        this.unsafeBlocks = unsafeBlocks;
        this.plugin = plugin;
    }

    public void start(Plugin plugin) {
        this.runTaskTimer(plugin, 20L, 100L);
    }

    public void run() {
        if (!this.plugin.isBlockingActive()) {
            return;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            Location safeLocation;
            World world = player.getWorld();
            if (world.getEnvironment() != World.Environment.NETHER || player.getLocation().getY() < 128.0 || (safeLocation = this.findSafeLocation(player.getLocation())) == null) continue;
            safeLocation.setYaw(player.getLocation().getYaw());
            safeLocation.setPitch(player.getLocation().getPitch());
            player.teleport(safeLocation);
            player.sendMessage("\u00a7cThe nether roof is disabled.");
        }
    }

    private Location findSafeLocation(Location origin) {
        World world = origin.getWorld();
        int originX = origin.getBlockX();
        int originZ = origin.getBlockZ();
        for (int dx = 0; dx <= 5; ++dx) {
            for (int dz = 0; dz <= 5; ++dz) {
                int[] nArray;
                int[] nArray2;
                if (dx == 0) {
                    int[] nArray3 = new int[1];
                    nArray2 = nArray3;
                    nArray3[0] = 0;
                } else {
                    int[] nArray4 = new int[2];
                    nArray4[0] = dx;
                    nArray2 = nArray4;
                    nArray4[1] = -dx;
                }
                int[] xOffsets = nArray2;
                if (dz == 0) {
                    int[] nArray5 = new int[1];
                    nArray = nArray5;
                    nArray5[0] = 0;
                } else {
                    int[] nArray6 = new int[2];
                    nArray6[0] = dz;
                    nArray = nArray6;
                    nArray6[1] = -dz;
                }
                int[] zOffsets = nArray;
                for (int xOff : xOffsets) {
                    for (int zOff : zOffsets) {
                        Location loc = this.findSafeY(world, originX + xOff, originZ + zOff);
                        if (loc == null) continue;
                        return loc;
                    }
                }
            }
        }
        return world.getSpawnLocation();
    }

    private Location findSafeY(World world, int x, int z) {
        for (int y = 120; y > world.getMinHeight(); --y) {
            Block feet = world.getBlockAt(x, y, z);
            Block head = world.getBlockAt(x, y + 1, z);
            Block ground = world.getBlockAt(x, y - 1, z);
            if (!this.isPassable(feet) || !this.isPassable(head) || !this.isSafeToStandOn(ground)) continue;
            return new Location(world, (double)x + 0.5, (double)y, (double)z + 0.5);
        }
        return null;
    }

    private boolean isPassable(Block block) {
        Material type = block.getType();
        if (type.isAir()) {
            return true;
        }
        return !type.isSolid() && !this.unsafeBlocks.contains(type);
    }

    private boolean isSafeToStandOn(Block block) {
        Material type = block.getType();
        return type.isSolid() && !this.unsafeBlocks.contains(type);
    }
}

