/*
 * Decompiled with CFR 0.152.
 */
package com.jellypudding.netherRoofBlocker;

import com.jellypudding.netherRoofBlocker.Metrics;
import com.jellypudding.netherRoofBlocker.NetherRoofListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class NetherRoofBlocker
extends JavaPlugin {
    private final Set<Material> unsafeBlocks = new HashSet<Material>();
    private NetherRoofListener roofChecker;
    private boolean blockingActive;

    private void loadConfigValues() {
        FileConfiguration config = this.getConfig();
        this.blockingActive = config.getBoolean("enabled", true);
        this.unsafeBlocks.clear();
        List unsafeBlocksList = config.getStringList("unsafe-blocks");
        for (String blockName : unsafeBlocksList) {
            try {
                Material material = Material.valueOf((String)blockName.toUpperCase());
                this.unsafeBlocks.add(material);
            }
            catch (IllegalArgumentException e) {
                this.getLogger().warning("Invalid material name in config: " + blockName);
            }
        }
    }

    public void onEnable() {
        int pluginId = 28683;
        new Metrics((Plugin)this, pluginId);
        this.saveDefaultConfig();
        this.loadConfigValues();
        this.roofChecker = new NetherRoofListener(this.unsafeBlocks, this);
        this.roofChecker.start((Plugin)this);
        this.getLogger().info("NetherRoofBlocker enabled. Ensure nether-ceiling-void-damage-height is set to 'disabled' in config/paper-world-defaults.yml");
    }

    public void onDisable() {
        if (this.roofChecker != null) {
            this.roofChecker.cancel();
        }
        this.getLogger().info("NetherRoofBlocker disabled.");
    }

    public boolean isBlockingActive() {
        return this.blockingActive;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String @NotNull [] args) {
        if (!command.getName().equalsIgnoreCase("netherroofblocker")) {
            return false;
        }
        if (args.length == 0) {
            sender.sendMessage("Usage: /netherroofblocker <reload|toggle>");
            return true;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            this.reloadConfig();
            this.loadConfigValues();
            sender.sendMessage("\u00a7aNetherRoofBlocker configuration reloaded.");
            return true;
        }
        if (args[0].equalsIgnoreCase("toggle")) {
            this.blockingActive = !this.blockingActive;
            String status = this.blockingActive ? "\u00a7aenabled" : "\u00a7cdisabled";
            sender.sendMessage("\u00a77NetherRoofBlocker is now " + status + "\u00a77.");
            return true;
        }
        return false;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String @NotNull [] args) {
        if (command.getName().equalsIgnoreCase("netherroofblocker") && args.length == 1) {
            ArrayList<String> completions = new ArrayList<String>();
            String input = args[0].toLowerCase();
            if ("reload".startsWith(input)) {
                completions.add("reload");
            }
            if ("toggle".startsWith(input)) {
                completions.add("toggle");
            }
            return completions;
        }
        return new ArrayList<String>();
    }
}

