/*
 * Decompiled with CFR 0.152.
 */
package com.jellypudding.goodnight;

import com.jellypudding.goodnight.Metrics;
import java.util.HashSet;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class GoodnightPlugin
extends JavaPlugin
implements Listener {
    private final Set<Player> playersWhoSlept = new HashSet<Player>();
    private double sleepPercentage;
    private static final long MORNING_TIME = 1000L;

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfigValues();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        int pluginId = 27564;
        new Metrics((Plugin)this, pluginId);
        this.getLogger().info("Goodnight plugin has been enabled.");
    }

    public void onDisable() {
        this.getLogger().info("Goodnight plugin has been disabled.");
    }

    private void loadConfigValues() {
        FileConfiguration config = this.getConfig();
        this.sleepPercentage = config.getDouble("sleep-percentage", 66.6) / 100.0;
    }

    private World getOverworld() {
        return Bukkit.getWorlds().stream().filter(world -> world.getEnvironment() == World.Environment.NORMAL).findFirst().orElse(null);
    }

    public boolean onCommand(@NotNull CommandSender sender, Command command, @NotNull String label, String[] args) {
        if (command.getName().equalsIgnoreCase("goodnight") && sender instanceof Player) {
            Player player = (Player)sender;
            World overworld = this.getOverworld();
            if (overworld == null) {
                player.sendMessage((Component)Component.text((String)"Cannot find the overworld!", (TextColor)NamedTextColor.RED));
                return true;
            }
            long time = overworld.getTime();
            long timeInDay = time % 24000L;
            if (timeInDay > 500L && timeInDay < 11000L) {
                player.sendMessage((Component)Component.text((String)"You cannot say goodnight during the day!", (TextColor)NamedTextColor.RED));
                return true;
            }
            if (!this.playersWhoSlept.contains(player)) {
                this.playersWhoSlept.add(player);
                String customMessage = args.length > 0 ? String.join((CharSequence)" ", args) : null;
                int[] sleepData = this.calculateSleepData();
                Component message = this.createGoodnightMessage(player, customMessage, sleepData);
                Bukkit.getServer().broadcast(message);
                this.updateTimeIfNeeded(overworld, sleepData[0], sleepData[1], false, null);
            } else {
                player.sendMessage((Component)Component.text((String)"You have already said goodnight!", (TextColor)NamedTextColor.RED));
            }
            return true;
        }
        return false;
    }

    private Component createGoodnightMessage(Player player, String customMessage, int[] sleepData) {
        Component playerName = player.displayName();
        TextComponent baseMessage = Component.text((String)" says goodnight", (TextColor)NamedTextColor.WHITE);
        if (customMessage != null) {
            return playerName.append((Component)baseMessage).append((Component)Component.text((String)(" " + customMessage), (TextColor)NamedTextColor.WHITE));
        }
        Component infoMessage = this.getDefaultInfoMessage(sleepData[0], sleepData[1], sleepData[2]);
        return playerName.append((Component)baseMessage).append(infoMessage);
    }

    private int[] calculateSleepData() {
        HashSet onlinePlayers = new HashSet(Bukkit.getOnlinePlayers());
        int totalPlayers = onlinePlayers.size();
        int sleepingPlayers = (int)this.playersWhoSlept.stream().filter(onlinePlayers::contains).count();
        int requiredPlayers = (int)Math.ceil((double)totalPlayers * this.sleepPercentage);
        return new int[]{totalPlayers, sleepingPlayers, requiredPlayers};
    }

    @NotNull
    private Component getDefaultInfoMessage(int totalPlayers, int sleepingPlayers, int requiredPlayers) {
        int morePlayersNeeded = Math.max(0, requiredPlayers - sleepingPlayers);
        if (morePlayersNeeded > 0) {
            double currentPercentage = totalPlayers > 0 ? (double)sleepingPlayers / (double)totalPlayers / this.sleepPercentage * 100.0 : 0.0;
            return Component.text((String)String.format(" (%d more needed to make it day, %.1f%% / 100%%)", morePlayersNeeded, currentPercentage), (TextColor)NamedTextColor.GRAY);
        }
        return ((TextComponent)Component.text((String)" (Making it ", (TextColor)NamedTextColor.WHITE).append((Component)Component.text((String)"day", (TextColor)NamedTextColor.GREEN))).append((Component)Component.text((String)")!", (TextColor)NamedTextColor.WHITE));
    }

    private void updateTimeIfNeeded(World overworld, int totalPlayers, int sleepingPlayers, boolean isPlayerLeaveEvent, Player leavePlayer) {
        if (totalPlayers > 0 && (double)sleepingPlayers / (double)totalPlayers >= this.sleepPercentage) {
            long currentTime = overworld.getTime();
            long timeInDay = currentTime % 24000L;
            long timeToAdd = 24000L - timeInDay + 1000L;
            long newTime = currentTime + timeToAdd;
            overworld.setTime(newTime);
            if (isPlayerLeaveEvent && leavePlayer != null) {
                double percentageNeeded = this.sleepPercentage * 100.0;
                Component message = ((TextComponent)((TextComponent)Component.text((String)"", (TextColor)NamedTextColor.WHITE).append(leavePlayer.displayName())).append((Component)Component.text((String)" left and made it morning! ", (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)String.format("(%.1f%% needed, %d/%d players voted)", percentageNeeded, sleepingPlayers, totalPlayers), (TextColor)NamedTextColor.GRAY));
                Bukkit.getServer().broadcast(message);
            }
            this.playersWhoSlept.clear();
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.playersWhoSlept.remove(player);
        Bukkit.getScheduler().runTask((Plugin)this, () -> {
            World overworld = this.getOverworld();
            if (overworld != null) {
                double currentSleepPercentage;
                long time = overworld.getTime();
                long timeInDay = time % 24000L;
                if (timeInDay > 500L && timeInDay < 11000L) {
                    return;
                }
                int[] sleepData = this.calculateSleepData();
                double d = currentSleepPercentage = sleepData[0] > 0 ? (double)sleepData[1] / (double)sleepData[0] : 0.0;
                if (currentSleepPercentage >= this.sleepPercentage) {
                    this.updateTimeIfNeeded(overworld, sleepData[0], sleepData[1], true, player);
                }
            }
        });
    }
}

