/*
 * Decompiled with CFR 0.152.
 */
package com.jellypudding.battleLock;

import com.jellypudding.battleLock.Metrics;
import com.jellypudding.battleLock.listeners.CombatListener;
import com.jellypudding.battleLock.listeners.CommandListener;
import com.jellypudding.battleLock.listeners.PlayerListener;
import com.jellypudding.battleLock.managers.CombatLogManager;
import com.jellypudding.battleLock.managers.CombatManager;
import com.jellypudding.battleLock.managers.DataManager;
import com.jellypudding.discordRelay.DiscordRelayAPI;
import java.util.logging.Level;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class BattleLock
extends JavaPlugin {
    private CombatManager combatManager;
    private CombatLogManager combatLogManager;
    private DataManager dataManager;
    private boolean discordRelayAPIReady = false;

    public void onEnable() {
        block6: {
            this.saveDefaultConfig();
            this.dataManager = new DataManager(this);
            this.combatManager = new CombatManager(this);
            this.combatLogManager = new CombatLogManager(this, this.combatManager, this.dataManager);
            this.getServer().getPluginManager().registerEvents((Listener)new CombatListener(this, this.combatManager), (Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)new CommandListener(this, this.combatManager), (Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(this, this.combatManager, this.combatLogManager), (Plugin)this);
            if (this.getServer().getPluginManager().isPluginEnabled("DiscordRelay")) {
                try {
                    this.discordRelayAPIReady = DiscordRelayAPI.isReady();
                    if (this.discordRelayAPIReady) {
                        this.getLogger().info("Successfully hooked into DiscordRelay.");
                        break block6;
                    }
                    this.getLogger().warning("DiscordRelay is loaded, but its API reported not ready (check DiscordRelay config/status).");
                }
                catch (NoClassDefFoundError e) {
                    this.getLogger().severe("DiscordRelay plugin found, but its API class (DiscordRelayAPI) is incompatible or missing.");
                    this.discordRelayAPIReady = false;
                }
                catch (Exception e) {
                    this.getLogger().log(Level.SEVERE, "An unexpected error occurred while checking DiscordRelay API.", e);
                    this.discordRelayAPIReady = false;
                }
            } else {
                this.getLogger().info("DiscordRelay plugin not found. Discord integration disabled.");
            }
        }
        int pluginId = 27551;
        new Metrics((Plugin)this, pluginId);
        this.getLogger().info("BattleLock has been enabled! Combat logging protection is now active.");
    }

    public void onDisable() {
        if (this.combatLogManager != null) {
            this.combatLogManager.removeAllCombatLogs();
        }
        this.getLogger().info("BattleLock has been disabled.");
    }

    public CombatManager getCombatManager() {
        return this.combatManager;
    }

    public CombatLogManager getCombatLogManager() {
        return this.combatLogManager;
    }

    public DataManager getDataManager() {
        return this.dataManager;
    }

    public boolean isDiscordRelayAPIReady() {
        return this.discordRelayAPIReady;
    }
}

