/*
 * Decompiled with CFR 0.152.
 */
package com.jellypudding.battleLock.managers;

import com.jellypudding.battleLock.BattleLock;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.configuration.file.YamlConfiguration;

public class DataManager {
    private final BattleLock plugin;
    private final File dataFolder;

    public DataManager(BattleLock plugin) {
        this.plugin = plugin;
        this.dataFolder = new File(plugin.getDataFolder(), "playerdata");
        if (!this.dataFolder.exists()) {
            this.dataFolder.mkdirs();
        }
    }

    public void markNpcKilled(UUID playerUuid) {
        File playerFile = this.getPlayerFile(playerUuid);
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)playerFile);
        config.set("killed", (Object)true);
        config.set("timestamp", (Object)System.currentTimeMillis());
        try {
            config.save(playerFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not save player data for " + String.valueOf(playerUuid), e);
        }
    }

    public boolean wasNpcKilled(UUID playerUuid) {
        File playerFile = this.getPlayerFile(playerUuid);
        if (playerFile.exists()) {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)playerFile);
            return config.getBoolean("killed", false);
        }
        return false;
    }

    public void removeKilledNpcRecord(UUID playerUuid) {
        File playerFile = this.getPlayerFile(playerUuid);
        if (playerFile.exists()) {
            if (playerFile.delete()) {
                this.plugin.getLogger().fine("Deleted player data file for " + String.valueOf(playerUuid));
            } else {
                this.plugin.getLogger().warning("Failed to delete player data file for " + String.valueOf(playerUuid));
            }
        }
    }

    private File getPlayerFile(UUID playerUuid) {
        return new File(this.dataFolder, playerUuid.toString() + ".yml");
    }
}

