/*
 * Decompiled with CFR 0.152.
 */
package com.jellypudding.battleLock.managers;

import com.jellypudding.battleLock.BattleLock;
import com.jellypudding.battleLock.managers.CombatManager;
import com.jellypudding.battleLock.managers.DataManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class CombatLogManager {
    private final BattleLock plugin;
    private final CombatManager combatManager;
    private final DataManager dataManager;
    private final Map<UUID, Integer> combatLogNPCs;
    private final Map<Integer, UUID> entityPlayerMap;
    private final Map<UUID, ItemStack[]> playerInventories;
    private final Map<UUID, Boolean> processingNPCDeath;
    private final Map<UUID, Integer> scheduledTasks;
    private final Map<UUID, Location> npcLocations;
    private final int logoutDespawnTime;
    private final NamespacedKey combatLogKey;

    public CombatLogManager(BattleLock plugin, CombatManager combatManager, DataManager dataManager) {
        this.plugin = plugin;
        this.combatManager = combatManager;
        this.dataManager = dataManager;
        this.combatLogNPCs = new ConcurrentHashMap<UUID, Integer>();
        this.entityPlayerMap = new ConcurrentHashMap<Integer, UUID>();
        this.playerInventories = new ConcurrentHashMap<UUID, ItemStack[]>();
        this.processingNPCDeath = new ConcurrentHashMap<UUID, Boolean>();
        this.scheduledTasks = new ConcurrentHashMap<UUID, Integer>();
        this.npcLocations = new ConcurrentHashMap<UUID, Location>();
        this.logoutDespawnTime = plugin.getConfig().getInt("combat-log-despawn-time", 30) * 20;
        this.combatLogKey = new NamespacedKey((Plugin)plugin, "combat_log_player_id");
    }

    public void createCombatLogNPC(Player player) {
        UUID playerId = player.getUniqueId();
        if (this.combatLogNPCs.containsKey(playerId)) {
            return;
        }
        if (this.scheduledTasks.containsKey(playerId)) {
            Bukkit.getScheduler().cancelTask(this.scheduledTasks.get(playerId).intValue());
            this.scheduledTasks.remove(playerId);
        }
        Location location = player.getLocation();
        ItemStack[] inventory = (ItemStack[])player.getInventory().getContents().clone();
        this.playerInventories.put(playerId, inventory);
        Villager npc = (Villager)location.getWorld().spawnEntity(location, EntityType.VILLAGER);
        npc.customName(player.displayName());
        npc.setCustomNameVisible(true);
        npc.setAI(false);
        npc.setInvulnerable(false);
        npc.setSilent(true);
        npc.setHealth(Math.min(player.getHealth(), 20.0));
        npc.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, Integer.MAX_VALUE, 10, false, false));
        npc.getPersistentDataContainer().set(this.combatLogKey, PersistentDataType.STRING, (Object)playerId.toString());
        this.combatLogNPCs.put(playerId, npc.getEntityId());
        this.entityPlayerMap.put(npc.getEntityId(), playerId);
        this.npcLocations.put(playerId, npc.getLocation());
        int taskId = Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.removeCombatLogNPC(playerId, false), (long)this.logoutDespawnTime);
        this.scheduledTasks.put(playerId, taskId);
        this.plugin.getLogger().info(player.getName() + " logged out during combat! Created NPC at " + location.getBlockX() + ", " + location.getBlockY() + ", " + location.getBlockZ());
    }

    public void removeCombatLogNPC(UUID playerId, boolean died) {
        if (!this.combatLogNPCs.containsKey(playerId)) {
            return;
        }
        if (this.scheduledTasks.containsKey(playerId)) {
            Bukkit.getScheduler().cancelTask(this.scheduledTasks.get(playerId).intValue());
            this.scheduledTasks.remove(playerId);
        }
        int entityId = this.combatLogNPCs.get(playerId);
        if (died && this.playerInventories.containsKey(playerId)) {
            Location dropLocation = null;
            ItemStack[] itemStackArray = Bukkit.getWorlds().stream().flatMap(world -> world.getEntities().stream()).filter(e -> e.getEntityId() == entityId).toList().iterator();
            if (itemStackArray.hasNext()) {
                Entity entity = itemStackArray.next();
                dropLocation = entity.getLocation();
            }
            if (dropLocation == null) {
                dropLocation = this.npcLocations.get(playerId);
            }
            if (dropLocation != null) {
                for (ItemStack item : this.playerInventories.get(playerId)) {
                    if (item == null) continue;
                    dropLocation.getWorld().dropItemNaturally(dropLocation, item);
                }
            }
            this.dataManager.markNpcKilled(playerId);
        }
        for (Entity entity : Bukkit.getWorlds().stream().flatMap(world -> world.getEntities().stream()).filter(e -> e.getEntityId() == entityId).toList()) {
            entity.remove();
        }
        this.combatLogNPCs.remove(playerId);
        this.entityPlayerMap.remove(entityId);
        this.playerInventories.remove(playerId);
        this.processingNPCDeath.remove(playerId);
        this.npcLocations.remove(playerId);
        String playerName = Bukkit.getOfflinePlayer((UUID)playerId).getName();
        this.plugin.getLogger().info(playerName + "'s combat log NPC has been " + (died ? "killed" : "despawned"));
    }

    public void handlePlayerReturn(Player player) {
        UUID playerId = player.getUniqueId();
        if (this.combatLogNPCs.containsKey(playerId)) {
            boolean wasKilled = !this.playerInventories.containsKey(playerId);
            this.removeCombatLogNPC(playerId, false);
            if (wasKilled) {
                player.getInventory().clear();
                this.combatManager.untagPlayer(player);
                player.sendMessage((Component)Component.text((String)"Your combat log NPC was killed while you were offline. You have lost your items.", (TextColor)NamedTextColor.RED));
                this.plugin.getLogger().info(player.getName() + " lost items due to a killed combat log NPC.");
            } else {
                ItemStack[] storedInventory = this.playerInventories.get(playerId);
                if (storedInventory != null) {
                    player.getInventory().clear();
                    player.getInventory().setContents(storedInventory);
                }
                if (this.combatManager.isPlayerTagged(player)) {
                    int timeRemaining = this.combatManager.getTimeUntilTagExpires(player);
                    player.sendMessage((Component)Component.text((String)("Your combat log NPC has been removed. You are still in combat for " + timeRemaining + " more seconds."), (TextColor)NamedTextColor.RED));
                } else {
                    player.sendMessage((Component)Component.text((String)"Your combat log NPC has been removed. You are no longer in combat and may log out safely.", (TextColor)NamedTextColor.GREEN));
                }
            }
            return;
        }
        if (this.dataManager.wasNpcKilled(playerId)) {
            player.getInventory().clear();
            this.combatManager.untagPlayer(player);
            player.sendMessage((Component)Component.text((String)"Your combat log NPC was killed while you were offline. You have lost your items.", (TextColor)NamedTextColor.RED));
            this.dataManager.removeKilledNpcRecord(playerId);
            this.plugin.getLogger().info(player.getName() + " lost items due to a killed combat log NPC (previous session).");
        }
    }

    public void handleNPCDeath(int entityId) {
        if (!this.entityPlayerMap.containsKey(entityId)) {
            return;
        }
        UUID playerId = this.entityPlayerMap.get(entityId);
        if (this.processingNPCDeath.putIfAbsent(playerId, true) != null) {
            return;
        }
        this.removeCombatLogNPC(playerId, true);
    }

    public void removeAllCombatLogs() {
        Iterator<Comparable<Integer>> iterator = this.scheduledTasks.values().iterator();
        while (iterator.hasNext()) {
            int taskId = iterator.next();
            Bukkit.getScheduler().cancelTask(taskId);
        }
        for (UUID playerId : new HashMap<UUID, Integer>(this.combatLogNPCs).keySet()) {
            this.removeCombatLogNPC(playerId, false);
        }
        this.scheduledTasks.clear();
        this.npcLocations.clear();
    }

    public boolean hasCombatLogNPC(UUID playerId) {
        return this.combatLogNPCs.containsKey(playerId);
    }

    public boolean isCombatLogNPC(int entityId) {
        return this.entityPlayerMap.containsKey(entityId);
    }

    public NamespacedKey getCombatLogKey() {
        return this.combatLogKey;
    }
}

