/*
 * Decompiled with CFR 0.152.
 */
package com.jellypudding.battleLock.managers;

import com.jellypudding.battleLock.BattleLock;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.entity.Player;

public class CombatManager {
    private final BattleLock plugin;
    private final Map<UUID, Long> taggedPlayers;
    private final int combatTagDuration;

    public CombatManager(BattleLock plugin) {
        this.plugin = plugin;
        this.taggedPlayers = new HashMap<UUID, Long>();
        this.combatTagDuration = plugin.getConfig().getInt("combat-tag-duration", 15) * 1000;
    }

    public void tagPlayer(Player player) {
        UUID playerId = player.getUniqueId();
        boolean wasTagged = this.isPlayerTagged(player);
        this.taggedPlayers.put(playerId, System.currentTimeMillis() + (long)this.combatTagDuration);
        if (!wasTagged) {
            player.sendMessage((Component)Component.text((String)"You are now in combat! Do not log out or you will be punished!", (TextColor)NamedTextColor.RED));
        }
    }

    public void untagPlayer(Player player) {
        UUID playerId = player.getUniqueId();
        if (this.taggedPlayers.containsKey(playerId)) {
            this.taggedPlayers.remove(playerId);
            player.sendMessage((Component)Component.text((String)"You are no longer in combat. You may now log out safely.", (TextColor)NamedTextColor.GREEN));
        }
    }

    public boolean isPlayerTagged(Player player) {
        UUID playerId = player.getUniqueId();
        if (!this.taggedPlayers.containsKey(playerId)) {
            return false;
        }
        long expireTime = this.taggedPlayers.get(playerId);
        if (System.currentTimeMillis() > expireTime) {
            this.taggedPlayers.remove(playerId);
            player.sendMessage((Component)Component.text((String)"You are no longer in combat. You may now log out safely.", (TextColor)NamedTextColor.GREEN));
            return false;
        }
        return true;
    }

    public int getTimeUntilTagExpires(Player player) {
        UUID playerId = player.getUniqueId();
        if (!this.taggedPlayers.containsKey(playerId)) {
            return 0;
        }
        long expireTime = this.taggedPlayers.get(playerId);
        long currentTime = System.currentTimeMillis();
        if (currentTime > expireTime) {
            this.taggedPlayers.remove(playerId);
            return 0;
        }
        return (int)((expireTime - currentTime) / 1000L);
    }
}

