/*
 * Decompiled with CFR 0.152.
 */
package com.jellypudding.battleLock.listeners;

import com.jellypudding.battleLock.BattleLock;
import com.jellypudding.battleLock.managers.CombatLogManager;
import com.jellypudding.battleLock.managers.CombatManager;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class PlayerListener
implements Listener {
    private final BattleLock plugin;
    private final CombatManager combatManager;
    private final CombatLogManager combatLogManager;

    public PlayerListener(BattleLock plugin, CombatManager combatManager, CombatLogManager combatLogManager) {
        this.plugin = plugin;
        this.combatManager = combatManager;
        this.combatLogManager = combatLogManager;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (this.combatManager.isPlayerTagged(player)) {
            this.combatLogManager.createCombatLogNPC(player);
            this.plugin.getLogger().info(player.getName() + " logged out during combat and will be punished if their NPC is killed");
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.combatLogManager.handlePlayerReturn(event.getPlayer());
    }
}

