/*
 * Decompiled with CFR 0.152.
 */
package com.jellypudding.battleLock.listeners;

import com.jellypudding.battleLock.BattleLock;
import com.jellypudding.battleLock.managers.CombatManager;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;

public class CommandListener
implements Listener {
    private final BattleLock plugin;
    private final CombatManager combatManager;
    private final List<String> allowedCommands;

    public CommandListener(BattleLock plugin, CombatManager combatManager) {
        this.plugin = plugin;
        this.combatManager = combatManager;
        List<String> configAllowedCommands = plugin.getConfig().getStringList("allowed-commands");
        this.allowedCommands = configAllowedCommands.isEmpty() ? new ArrayList<String>(List.of("tell", "msg", "r", "me")) : configAllowedCommands;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        if (this.combatManager.isPlayerTagged(player)) {
            String command = event.getMessage().substring(1).split(" ")[0].toLowerCase();
            for (String allowedCommand : this.allowedCommands) {
                if (!command.equals(allowedCommand)) continue;
                return;
            }
            event.setCancelled(true);
            player.sendMessage((Component)Component.text((String)("You cannot use commands while in combat. Time remaining: " + this.combatManager.getTimeUntilTagExpires(player) + "s"), (TextColor)NamedTextColor.RED));
        }
    }
}

