/*
 * Decompiled with CFR 0.152.
 */
package com.jellypudding.battleLock.listeners;

import com.jellypudding.battleLock.BattleLock;
import com.jellypudding.battleLock.managers.CombatLogManager;
import com.jellypudding.battleLock.managers.CombatManager;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.projectiles.ProjectileSource;

public class CombatListener
implements Listener {
    private final BattleLock plugin;
    private final CombatManager combatManager;

    public CombatListener(BattleLock plugin, CombatManager combatManager) {
        this.plugin = plugin;
        this.combatManager = combatManager;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        ProjectileSource source;
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            CombatLogManager combatLogManager = this.plugin.getCombatLogManager();
            if (combatLogManager.isCombatLogNPC(event.getEntity().getEntityId()) && event.getFinalDamage() >= ((LivingEntity)event.getEntity()).getHealth()) {
                combatLogManager.handleNPCDeath(event.getEntity().getEntityId());
            }
            return;
        }
        Player victim = (Player)entity;
        Entity damager = event.getDamager();
        Player attacker = null;
        if (damager instanceof Player) {
            attacker = (Player)damager;
        } else if (damager instanceof Projectile && (source = ((Projectile)damager).getShooter()) instanceof Player) {
            attacker = (Player)source;
        }
        if (attacker != null && !attacker.equals((Object)victim)) {
            this.combatManager.tagPlayer(victim);
            this.combatManager.tagPlayer(attacker);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEntityDeath(EntityDeathEvent event) {
        CombatLogManager combatLogManager;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.combatManager.untagPlayer(player);
        }
        if ((combatLogManager = this.plugin.getCombatLogManager()).isCombatLogNPC(event.getEntity().getEntityId())) {
            combatLogManager.handleNPCDeath(event.getEntity().getEntityId());
        }
    }
}

