/*
 * Decompiled with CFR 0.152.
 */
package com.jellypudding.anarchySpawn;

import com.jellypudding.anarchySpawn.Metrics;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class AnarchySpawn
extends JavaPlugin
implements Listener {
    private int spawnRadius;
    private int maxAttempts;
    private int spawnCooldown;
    private final Random random = new Random();
    private final Set<Material> unsafeBlocks = new HashSet<Material>();
    private final Map<UUID, Long> spawnCooldowns = new HashMap<UUID, Long>();

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfigValues();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        Objects.requireNonNull(this.getCommand("spawn")).setTabCompleter((TabCompleter)this);
        Objects.requireNonNull(this.getCommand("anarchyspawn")).setTabCompleter((TabCompleter)this);
        int pluginId = 27563;
        new Metrics((Plugin)this, pluginId);
        this.getLogger().info("AnarchySpawn has been enabled.");
    }

    public void onDisable() {
        this.spawnCooldowns.clear();
        this.getLogger().info("AnarchySpawn has been disabled.");
    }

    private void loadConfigValues() {
        FileConfiguration config = this.getConfig();
        this.spawnRadius = config.getInt("spawn-radius", 300);
        this.maxAttempts = config.getInt("max-spawn-attempts", 75);
        this.spawnCooldown = config.getInt("spawn-cooldown", 5);
        this.unsafeBlocks.clear();
        List unsafeBlocksList = config.getStringList("unsafe-blocks");
        for (String blockName : unsafeBlocksList) {
            try {
                Material material = Material.valueOf((String)blockName.toUpperCase());
                this.unsafeBlocks.add(material);
            }
            catch (IllegalArgumentException e) {
                this.getLogger().warning("Invalid material name in config: " + blockName);
            }
        }
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String @NotNull [] args) {
        if (command.getName().equalsIgnoreCase("spawn")) {
            long lastUsed;
            long timeDiff;
            if (!(sender instanceof Player)) {
                sender.sendMessage("This command can only be used by players!");
                return true;
            }
            Player player = (Player)sender;
            World.Environment playerEnv = player.getWorld().getEnvironment();
            if (playerEnv == World.Environment.NETHER || playerEnv == World.Environment.THE_END) {
                player.sendMessage("\u00a7cYou cannot use /spawn in the " + (playerEnv == World.Environment.NETHER ? "Nether" : "End") + ".");
                return true;
            }
            UUID playerId = player.getUniqueId();
            long currentTime = System.currentTimeMillis();
            this.cleanupExpiredCooldowns(currentTime);
            if (this.spawnCooldowns.containsKey(playerId) && (timeDiff = (currentTime - (lastUsed = this.spawnCooldowns.get(playerId).longValue())) / 1000L) < (long)this.spawnCooldown) {
                long remainingTime;
                player.sendMessage("\u00a7cYou must wait " + remainingTime + " more second" + ((remainingTime = (long)this.spawnCooldown - timeDiff) == 1L ? "" : "s") + " before using /spawn again.");
                return true;
            }
            Location spawnLocation = this.findSafeSpawnLocation(player.getWorld());
            player.teleport(spawnLocation);
            player.sendMessage("Teleported to a random spawn location!");
            this.spawnCooldowns.put(playerId, currentTime);
            return true;
        }
        if (command.getName().equalsIgnoreCase("anarchyspawn")) {
            if (args.length == 0) {
                sender.sendMessage("Usage: /anarchyspawn reload");
                return true;
            }
            if (args[0].equalsIgnoreCase("reload")) {
                if (!sender.hasPermission("anarchyspawn.reload")) {
                    sender.sendMessage("You don't have permission to use this command!");
                    return true;
                }
                this.reloadConfig();
                this.loadConfigValues();
                sender.sendMessage("AnarchySpawn configuration reloaded.");
                return true;
            }
            return false;
        }
        return false;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String @NotNull [] args) {
        if (command.getName().equalsIgnoreCase("anarchyspawn") && args.length == 1) {
            ArrayList<String> completions = new ArrayList<String>();
            if (sender.hasPermission("anarchyspawn.reload") && "reload".startsWith(args[0].toLowerCase())) {
                completions.add("reload");
            }
            return completions;
        }
        return new ArrayList<String>();
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPlayedBefore()) {
            Location spawnLocation = this.findSafeSpawnLocation(player.getWorld());
            player.teleport(spawnLocation);
        }
    }

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        if (!event.isAnchorSpawn() && !event.isBedSpawn()) {
            World overworld = (World)event.getPlayer().getServer().getWorlds().getFirst();
            Location spawnLocation = this.findSafeSpawnLocation(overworld);
            event.setRespawnLocation(spawnLocation);
        }
    }

    private Location findSafeSpawnLocation(World world) {
        Location bestLocation = null;
        int bestSafetyScore = -1;
        for (int attempt = 0; attempt < this.maxAttempts; ++attempt) {
            int z;
            int y;
            int x = this.random.nextInt(this.spawnRadius * 2) - this.spawnRadius;
            Location location = new Location(world, (double)x + 0.5, (double)((y = world.getHighestBlockYAt(x, z = this.random.nextInt(this.spawnRadius * 2) - this.spawnRadius)) + 1), (double)z + 0.5);
            int safetyScore = this.calculateSafetyScore(location);
            if (safetyScore == 100) {
                return location;
            }
            if (safetyScore <= bestSafetyScore) continue;
            bestSafetyScore = safetyScore;
            bestLocation = location;
        }
        if (bestLocation == null) {
            int x = this.random.nextInt(this.spawnRadius * 2) - this.spawnRadius;
            int z = this.random.nextInt(this.spawnRadius * 2) - this.spawnRadius;
            bestLocation = new Location(world, (double)x + 0.5, (double)(world.getMaxHeight() - 2), (double)z + 0.5);
            this.getLogger().warning("Falling back to emergency spawn location at build height");
        }
        return bestLocation;
    }

    private int calculateSafetyScore(Location location) {
        Block feet = location.getBlock();
        Block ground = location.subtract(0.0, 1.0, 0.0).getBlock();
        Block head = location.add(0.0, 2.0, 0.0).getBlock();
        int score = 100;
        if (!feet.getType().isAir() || !head.getType().isAir()) {
            return 0;
        }
        if (!ground.getType().isSolid()) {
            score -= 50;
        }
        if (ground.isLiquid()) {
            score -= 30;
        }
        if (this.unsafeBlocks.contains(ground.getType())) {
            score -= 40;
        }
        return Math.max(score, 0);
    }

    private void cleanupExpiredCooldowns(long currentTime) {
        long expiredThreshold = currentTime - (long)this.spawnCooldown * 1000L;
        this.spawnCooldowns.entrySet().removeIf(entry -> (Long)entry.getValue() < expiredThreshold);
    }
}

