/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Scanner;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class UpdateChecker {
    private final JavaPlugin plugin;
    private final int resourceId;
    private String latestVersion = "";
    private boolean updateAvailable = false;
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)");
    private File downloadedUpdateFile = null;

    public UpdateChecker(JavaPlugin plugin, int resourceId) {
        this.plugin = plugin;
        this.resourceId = resourceId;
    }

    public void getVersion(Consumer<String> consumer) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try (InputStream inputStream = new URL("https://api.spigotmc.org/legacy/update.php?resource=" + this.resourceId).openStream();
                 Scanner scanner = new Scanner(inputStream);){
                if (scanner.hasNext()) {
                    String version;
                    this.latestVersion = version = scanner.next();
                    String currentVersion = this.plugin.getDescription().getVersion();
                    this.plugin.getLogger().info("Checking version: Current=" + currentVersion + ", Latest=" + version);
                    this.updateAvailable = this.isNewerVersion(version, currentVersion);
                    consumer.accept(version);
                }
            }
            catch (IOException exception) {
                this.plugin.getLogger().info("Unable to check for updates: " + exception.getMessage());
            }
        });
    }

    public void checkForUpdates() {
        this.getVersion(version -> {
            String currentVersion = this.plugin.getDescription().getVersion();
            if (this.isNewerVersion((String)version, currentVersion)) {
                this.plugin.getLogger().info("\u00a7e=================================================");
                this.plugin.getLogger().info("\u00a7e DeepGuard-XRay: New update available!");
                this.plugin.getLogger().info("\u00a7e Current version: \u00a7c" + currentVersion);
                this.plugin.getLogger().info("\u00a7e New version: \u00a7a" + version);
                this.plugin.getLogger().info("\u00a7e Download: \u00a7ahttps://www.spigotmc.org/resources/" + this.resourceId);
                this.plugin.getLogger().info("\u00a7e=================================================");
            } else {
                this.plugin.getLogger().info("DeepGuard-XRay is up to date!");
            }
        });
    }

    private boolean isNewerVersion(String versionA, String versionB) {
        Matcher matcherA = VERSION_PATTERN.matcher(versionA);
        if (!matcherA.matches()) {
            this.plugin.getLogger().warning("Invalid version format: " + versionA);
            return false;
        }
        int majorA = Integer.parseInt(matcherA.group(1));
        int minorA = Integer.parseInt(matcherA.group(2));
        int patchA = Integer.parseInt(matcherA.group(3));
        Matcher matcherB = VERSION_PATTERN.matcher(versionB);
        if (!matcherB.matches()) {
            this.plugin.getLogger().warning("Invalid version format: " + versionB);
            return false;
        }
        int majorB = Integer.parseInt(matcherB.group(1));
        int minorB = Integer.parseInt(matcherB.group(2));
        int patchB = Integer.parseInt(matcherB.group(3));
        if (majorA > majorB) {
            return true;
        }
        if (majorA < majorB) {
            return false;
        }
        if (minorA > minorB) {
            return true;
        }
        if (minorA < minorB) {
            return false;
        }
        return patchA > patchB;
    }

    public void downloadUpdate(Consumer<Boolean> callback) {
        if (!this.updateAvailable) {
            callback.accept(false);
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                File pluginsDirectory = this.plugin.getServer().getUpdateFolderFile().getParentFile();
                this.plugin.getLogger().info("Using plugins directory: " + pluginsDirectory.getAbsolutePath());
                String pluginName = "DeepGuard-XRay";
                String currentVersion = this.plugin.getDescription().getVersion();
                File currentPluginFile = new File(pluginsDirectory, pluginName + "-" + currentVersion + ".jar");
                if (!currentPluginFile.exists()) {
                    this.plugin.getLogger().info("Current plugin JAR not found with expected name, searching for alternatives...");
                    File[] jarFiles = pluginsDirectory.listFiles((dir, name) -> name.toLowerCase().startsWith(pluginName.toLowerCase()) && name.toLowerCase().endsWith(".jar"));
                    if (jarFiles != null && jarFiles.length > 0) {
                        currentPluginFile = jarFiles[0];
                        this.plugin.getLogger().info("Found alternative plugin JAR: " + currentPluginFile.getName());
                    } else {
                        this.plugin.getLogger().warning("Could not find any matching plugin JAR files!");
                    }
                }
                String newFilename = pluginName + "-" + this.latestVersion + ".jar";
                File outputFile = new File(pluginsDirectory, newFilename);
                this.plugin.getLogger().info("Downloading update to: " + outputFile.getAbsolutePath());
                String downloadUrl = "https://api.spiget.org/v2/resources/" + this.resourceId + "/download";
                URL url = new URL(downloadUrl);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestProperty("User-Agent", "DeepGuardX-AutoUpdater");
                try (InputStream in = connection.getInputStream();
                     ReadableByteChannel rbc = Channels.newChannel(in);
                     FileOutputStream fos = new FileOutputStream(outputFile);){
                    fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
                    this.downloadedUpdateFile = outputFile;
                    boolean isPaperServer = false;
                    try {
                        Class.forName("io.papermc.paper.PaperConfig");
                        isPaperServer = true;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                    boolean deleteSuccess = false;
                    if (isPaperServer && currentPluginFile.exists()) {
                        this.plugin.getLogger().info("Paper server detected - attempting immediate cleanup of old JAR");
                        deleteSuccess = currentPluginFile.delete();
                        this.plugin.getLogger().info(deleteSuccess ? "Successfully deleted old plugin JAR: " + currentPluginFile.getName() : "Could not delete old plugin JAR (it will be cleaned up on shutdown): " + currentPluginFile.getName());
                    }
                    File updateMarker = new File(this.plugin.getDataFolder(), "pending_update.txt");
                    try (FileOutputStream markerOut = new FileOutputStream(updateMarker);){
                        String markerContent = "current_plugin=" + currentPluginFile.getAbsolutePath() + "\nnew_plugin=" + outputFile.getAbsolutePath() + "\nversion=" + this.latestVersion + "\nalready_deleted=" + deleteSuccess + "\ntimestamp=" + System.currentTimeMillis();
                        markerOut.write(markerContent.getBytes());
                    }
                    this.plugin.getLogger().info("Update downloaded successfully! The new version will be used after server restart.");
                    this.plugin.getLogger().info("New plugin JAR: " + outputFile.getName());
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> callback.accept(true));
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Failed to download update: " + e.getMessage());
                e.printStackTrace();
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> callback.accept(false));
            }
        });
    }

    public boolean isUpdateAvailable() {
        return this.updateAvailable;
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }

    public File getDownloadedUpdateFile() {
        return this.downloadedUpdateFile;
    }
}

