/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.utils;

import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.plugin.java.JavaPlugin;
import org.myplugin.deepGuardXray.managers.StatsManager;
import org.myplugin.deepGuardXray.utils.MLMiningAnalyzer;

public class MiningPatternAnalyzer {
    private static boolean mlAnalysisEnabled = true;
    private static final double STRAIGHTNESS_THRESHOLD = 0.75;
    private static final int MIN_SEGMENT_LENGTH = 15;
    private static final double MIN_DIVERSITY = 0.1;
    private static final double ADJACENCY_THRESHOLD = 0.55;
    private static final double ORIENTATION_HIGH_THRESHOLD = 10.0;
    private static final double ORIENTATION_MEDIUM_THRESHOLD = 5.0;
    private static final int SUSPICIOUS_ORE_DISTANCE = 10;
    private static final int MIN_ORE_SAMPLES = 4;
    private static final double ML_WEIGHT = 0.7;
    private static final double HEURISTIC_WEIGHT = 0.3;
    private static final double HIGH_SUSPICION_THRESHOLD = 0.8;
    private static final double MEDIUM_SUSPICION_THRESHOLD = 0.5;
    private static final Map<String, Double> ANALYSIS_WEIGHTS = Map.of("straightness", 2.0, "oreDistance", 2.5, "blockVariety", 0.5, "timeVariance", 1.5, "adjacency", 0.5, "orientation", 1.5);
    private static MLMiningAnalyzer mlAnalyzer;
    private static final Map<UUID, List<Double>> playerSuspicionHistory;
    private static final int HISTORY_SIZE = 10;

    public static boolean isMLAnalysisEnabled() {
        return mlAnalysisEnabled;
    }

    public static void setMLAnalysisEnabled(boolean enabled) {
        mlAnalysisEnabled = enabled;
    }

    public static void initialize(JavaPlugin plugin) {
        mlAnalyzer = new MLMiningAnalyzer(plugin);
    }

    public static String analyzeMiningPattern(UUID playerId) {
        if (!mlAnalysisEnabled) {
            return "Analysis Disabled";
        }
        if (mlAnalyzer == null) {
            double suspicionScore = MiningPatternAnalyzer.calculateSuspicionScore(playerId);
            return MiningPatternAnalyzer.classifySuspicion(suspicionScore);
        }
        double heuristicScore = MiningPatternAnalyzer.calculateSuspicionScore(playerId);
        double mlProbability = mlAnalyzer.analyzePlayer(playerId);
        double normalizedHeuristicScore = heuristicScore / 25.0;
        double combinedScore = normalizedHeuristicScore * 0.3 + mlProbability * 0.7;
        MiningPatternAnalyzer.updateSuspicionHistory(playerId, combinedScore);
        double adjustedScore = MiningPatternAnalyzer.adjustForTrends(playerId, combinedScore);
        if (adjustedScore > 0.8) {
            return "Highly Suspicious";
        }
        if (adjustedScore > 0.5) {
            return "Suspicious";
        }
        return "Normal";
    }

    public static double calculateSuspicionScore(UUID playerId) {
        Deque<StatsManager.BlockBreakRecord> breaksDeque = StatsManager.getRecentBreaks(playerId);
        if (breaksDeque.size() < 10) {
            return 0.0;
        }
        ArrayList<StatsManager.BlockBreakRecord> breaks = new ArrayList<StatsManager.BlockBreakRecord>(breaksDeque);
        boolean isCaveMining = MiningPatternAnalyzer.isCaveMiningPattern(breaks);
        HashMap<String, Double> dynamicWeights = new HashMap<String, Double>(ANALYSIS_WEIGHTS);
        if (isCaveMining) {
            dynamicWeights.put("blockVariety", 0.3);
            dynamicWeights.put("adjacency", 0.3);
        }
        double suspicionScore = 0.0;
        suspicionScore += MiningPatternAnalyzer.analyzeStraightnessToOres(breaks) * dynamicWeights.getOrDefault("straightness", 1.0);
        suspicionScore += MiningPatternAnalyzer.analyzeOreDistances(breaks) * dynamicWeights.getOrDefault("oreDistance", 1.0);
        suspicionScore += MiningPatternAnalyzer.analyzeBlockVariety(breaks, isCaveMining) * dynamicWeights.getOrDefault("blockVariety", 1.0);
        suspicionScore += MiningPatternAnalyzer.analyzeOreTimeVariance(breaks) * dynamicWeights.getOrDefault("timeVariance", 1.0);
        suspicionScore += MiningPatternAnalyzer.analyzeAdjacency(breaks) * dynamicWeights.getOrDefault("adjacency", 1.0);
        suspicionScore += MiningPatternAnalyzer.analyzeOrientation(breaks) * dynamicWeights.getOrDefault("orientation", 1.0);
        suspicionScore += MiningPatternAnalyzer.analyzeDepthAndOreType(breaks);
        return suspicionScore += MiningPatternAnalyzer.analyzeSessionConsistency(playerId, breaks);
    }

    public static String classifySuspicion(double score) {
        if (score > 20.0) {
            return "Highly Suspicious";
        }
        if (score > 10.0) {
            return "Suspicious";
        }
        return "Normal";
    }

    public static void flagPlayerForLearning(UUID playerId, boolean isCheating) {
        if (mlAnalyzer != null) {
            mlAnalyzer.flagPlayer(playerId, isCheating);
        }
    }

    public static Map<String, Object> getDetailedAnalysis(UUID playerId) {
        if (!mlAnalysisEnabled) {
            HashMap<String, Object> disabledResult = new HashMap<String, Object>();
            disabledResult.put("mlDisabled", true);
            disabledResult.put("miningStyle", "Analysis Disabled");
            return disabledResult;
        }
        Deque<StatsManager.BlockBreakRecord> breaksDeque = StatsManager.getRecentBreaks(playerId);
        if (breaksDeque.size() < 10) {
            return Map.of("error", "Not enough mining data");
        }
        ArrayList<StatsManager.BlockBreakRecord> breaks = new ArrayList<StatsManager.BlockBreakRecord>(breaksDeque);
        boolean isCaveMining = MiningPatternAnalyzer.isCaveMiningPattern(breaks);
        HashMap<String, Object> analysis = new HashMap<String, Object>();
        analysis.put("miningStyle", isCaveMining ? "Cave Mining" : "Branch Mining");
        analysis.put("straightnessScore", MiningPatternAnalyzer.analyzeStraightnessToOres(breaks));
        analysis.put("oreDistanceScore", MiningPatternAnalyzer.analyzeOreDistances(breaks));
        analysis.put("blockVarietyScore", MiningPatternAnalyzer.analyzeBlockVariety(breaks, isCaveMining));
        analysis.put("timeVarianceScore", MiningPatternAnalyzer.analyzeOreTimeVariance(breaks));
        analysis.put("adjacencyScore", MiningPatternAnalyzer.analyzeAdjacency(breaks));
        analysis.put("orientationScore", MiningPatternAnalyzer.analyzeOrientation(breaks));
        analysis.put("heuristicTotalScore", MiningPatternAnalyzer.calculateSuspicionScore(playerId));
        if (mlAnalyzer != null) {
            analysis.put("mlProbability", mlAnalyzer.analyzePlayer(playerId));
            analysis.put("combinedScore", MiningPatternAnalyzer.getCombinedScore(playerId));
        }
        if (playerSuspicionHistory.containsKey(playerId)) {
            analysis.put("suspicionHistory", playerSuspicionHistory.get(playerId));
        }
        return analysis;
    }

    private static double analyzeStraightnessToOres(List<StatsManager.BlockBreakRecord> breaks) {
        ArrayList<Integer> oreIndices = new ArrayList<Integer>();
        for (int i = 0; i < breaks.size(); ++i) {
            if (!StatsManager.trackedOres.contains(breaks.get((int)i).type)) continue;
            oreIndices.add(i);
        }
        if (oreIndices.size() < 2) {
            return 0.0;
        }
        double score = 0.0;
        for (int j = 0; j < oreIndices.size() - 1; ++j) {
            List<StatsManager.BlockBreakRecord> segment;
            double ratio;
            int start = (Integer)oreIndices.get(j);
            int end = (Integer)oreIndices.get(j + 1);
            if (end - start < 15 || !((ratio = MiningPatternAnalyzer.computeStraightness(segment = breaks.subList(start, end + 1))) > 0.75)) continue;
            score += (double)(end - start) * 0.1;
            if (!(ratio > 0.95) || end - start <= 30) continue;
            score *= 1.5;
        }
        return score;
    }

    private static double analyzeOreDistances(List<StatsManager.BlockBreakRecord> breaks) {
        List oreBreaks = breaks.stream().filter(b -> StatsManager.trackedOres.contains(b.type)).collect(Collectors.toList());
        if (oreBreaks.size() < 4) {
            return 0.0;
        }
        int closeOreFinds = 0;
        double totalDistance = 0.0;
        for (int i = 1; i < oreBreaks.size(); ++i) {
            StatsManager.BlockBreakRecord prev = (StatsManager.BlockBreakRecord)oreBreaks.get(i - 1);
            StatsManager.BlockBreakRecord curr = (StatsManager.BlockBreakRecord)oreBreaks.get(i);
            double dx = curr.x - prev.x;
            double dy = curr.y - prev.y;
            double dz = curr.z - prev.z;
            double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
            totalDistance += distance;
            if (!(distance < 10.0)) continue;
            if (MiningPatternAnalyzer.isRareOre(curr.type)) {
                closeOreFinds += 2;
                continue;
            }
            ++closeOreFinds;
        }
        double avgDistance = totalDistance / (double)(oreBreaks.size() - 1);
        double score = 0.0;
        if (avgDistance < 10.0) {
            score += (10.0 - avgDistance) * 0.5;
        }
        if (closeOreFinds > 1) {
            score += (double)closeOreFinds * 0.7;
        }
        return score;
    }

    private static boolean isRareOre(Material material) {
        return material == Material.DIAMOND_ORE || material == Material.DEEPSLATE_DIAMOND_ORE || material == Material.ANCIENT_DEBRIS;
    }

    private static double computeStraightness(List<StatsManager.BlockBreakRecord> segment) {
        if (segment.size() < 2) {
            return 0.0;
        }
        StatsManager.BlockBreakRecord first = segment.get(0);
        StatsManager.BlockBreakRecord last = segment.get(segment.size() - 1);
        double dx = last.x - first.x;
        double dy = last.y - first.y;
        double dz = last.z - first.z;
        double straightDistance = Math.sqrt(dx * dx + dy * dy + dz * dz);
        int pathLength = segment.size() - 1;
        return straightDistance / (double)pathLength;
    }

    private static double analyzeBlockVariety(List<StatsManager.BlockBreakRecord> breaks, boolean isCaveMining) {
        HashSet<Material> uniqueTypes = new HashSet<Material>();
        HashMap<Material, Integer> blockCounts = new HashMap<Material, Integer>();
        for (StatsManager.BlockBreakRecord record : breaks) {
            uniqueTypes.add(record.type);
            blockCounts.put(record.type, blockCounts.getOrDefault(record.type, 0) + 1);
        }
        long stoneBlocks = breaks.stream().filter(r -> MiningPatternAnalyzer.isStoneType(r.type)).count();
        long oreCount = breaks.stream().filter(r -> StatsManager.trackedOres.contains(r.type)).count();
        double diversity = (double)uniqueTypes.size() / (double)breaks.size();
        double oreRatio = (double)oreCount / (double)breaks.size();
        double stoneToOreRatio = oreCount > 0L ? (double)stoneBlocks / (double)oreCount : 0.0;
        double score = 0.0;
        if (diversity < 0.1) {
            score += 5.0;
        }
        if (isCaveMining) {
            if (oreRatio > 0.3) {
                score += oreRatio * 15.0;
            }
            if (stoneToOreRatio < 2.0 && oreCount > 3L) {
                score += (2.0 - stoneToOreRatio) * 3.0;
            }
        } else if (oreRatio > 0.2) {
            score += oreRatio * 20.0;
        }
        return score;
    }

    private static boolean isStoneType(Material material) {
        return material == Material.STONE || material == Material.DEEPSLATE || material == Material.ANDESITE || material == Material.DIORITE || material == Material.GRANITE || material == Material.TUFF;
    }

    private static double analyzeOreTimeVariance(List<StatsManager.BlockBreakRecord> breaks) {
        ArrayList<Long> oreTimes = new ArrayList<Long>();
        for (StatsManager.BlockBreakRecord record : breaks) {
            if (!StatsManager.trackedOres.contains(record.type)) continue;
            oreTimes.add(record.timestamp);
        }
        if (oreTimes.size() < 3) {
            return 0.0;
        }
        ArrayList<Long> intervals = new ArrayList<Long>();
        for (int i2 = 1; i2 < oreTimes.size(); ++i2) {
            intervals.add((Long)oreTimes.get(i2) - (Long)oreTimes.get(i2 - 1));
        }
        double mean = intervals.stream().mapToLong(Long::longValue).average().orElse(0.0);
        double variance = intervals.stream().mapToDouble(i -> Math.pow((double)i.longValue() - mean, 2.0)).average().orElse(0.0);
        double score = 0.0;
        if (variance < 10000.0) {
            score += 5.0;
        }
        if (mean < 3000.0 && oreTimes.size() > 5) {
            score += 8.0;
        }
        ArrayList<Long> rareOreTimes = new ArrayList<Long>();
        for (int i3 = 0; i3 < breaks.size(); ++i3) {
            if (!MiningPatternAnalyzer.isRareOre(breaks.get((int)i3).type)) continue;
            rareOreTimes.add(breaks.get((int)i3).timestamp);
        }
        if (rareOreTimes.size() >= 3) {
            ArrayList<Long> rareIntervals = new ArrayList<Long>();
            for (int i4 = 1; i4 < rareOreTimes.size(); ++i4) {
                rareIntervals.add((Long)rareOreTimes.get(i4) - (Long)rareOreTimes.get(i4 - 1));
            }
            double rareMean = rareIntervals.stream().mapToLong(Long::longValue).average().orElse(0.0);
            if (rareMean < 30000.0) {
                score += 10.0;
            }
        }
        return score;
    }

    private static double analyzeAdjacency(List<StatsManager.BlockBreakRecord> breaks) {
        double adjacencyThreshold;
        if (breaks.size() < 2) {
            return 0.0;
        }
        int adjacentCount = 0;
        int smallJumpCount = 0;
        int mediumJumpCount = 0;
        int longJumpCount = 0;
        for (int i = 1; i < breaks.size(); ++i) {
            StatsManager.BlockBreakRecord prev = breaks.get(i - 1);
            StatsManager.BlockBreakRecord curr = breaks.get(i);
            int manhattanDist = Math.abs(curr.x - prev.x) + Math.abs(curr.y - prev.y) + Math.abs(curr.z - prev.z);
            if (manhattanDist == 1) {
                ++adjacentCount;
                continue;
            }
            if (manhattanDist <= 3) {
                ++smallJumpCount;
                continue;
            }
            if (manhattanDist <= 6) {
                ++mediumJumpCount;
                continue;
            }
            ++longJumpCount;
        }
        double adjacencyRatio = (double)adjacentCount / (double)(breaks.size() - 1);
        double score = 0.0;
        boolean isCaveMining = MiningPatternAnalyzer.isCaveMiningPattern(breaks);
        double d = adjacencyThreshold = isCaveMining ? 0.45 : 0.65;
        if (adjacencyRatio < adjacencyThreshold) {
            score += (adjacencyThreshold - adjacencyRatio) * 10.0;
        }
        if (!isCaveMining && mediumJumpCount > 3) {
            score += (double)(mediumJumpCount - 3) * 0.3;
        }
        if (longJumpCount > 2) {
            score += (double)(longJumpCount - 2) * (isCaveMining ? 0.8 : 1.5);
        }
        return score;
    }

    private static double analyzeOrientation(List<StatsManager.BlockBreakRecord> breaks) {
        if (breaks.size() < 2) {
            return 0.0;
        }
        double totalDelta = 0.0;
        int count = 0;
        int rapidChanges = 0;
        int extremeChanges = 0;
        for (int i = 1; i < breaks.size(); ++i) {
            double deltaPitch = Math.abs(breaks.get((int)i).pitch - breaks.get((int)(i - 1)).pitch);
            double deltaYaw = Math.abs(breaks.get((int)i).yaw - breaks.get((int)(i - 1)).yaw);
            if (deltaYaw > 180.0) {
                deltaYaw = 360.0 - deltaYaw;
            }
            double combinedDelta = (deltaPitch + deltaYaw) / 2.0;
            totalDelta += combinedDelta;
            ++count;
            long timeDiff = breaks.get((int)i).timestamp - breaks.get((int)(i - 1)).timestamp;
            if (!(combinedDelta > 45.0) || timeDiff >= 500L) continue;
            ++rapidChanges;
            if (!(combinedDelta > 90.0) || timeDiff >= 300L) continue;
            ++extremeChanges;
        }
        if (count == 0) {
            return 0.0;
        }
        double avgDelta = totalDelta / (double)count;
        double score = 0.0;
        if (avgDelta > 10.0) {
            score += 5.0;
        } else if (avgDelta > 5.0) {
            score += 2.0;
        }
        if (rapidChanges > 2) {
            score += (double)rapidChanges * 1.0;
        }
        if (extremeChanges > 0) {
            score += (double)extremeChanges * 2.5;
        }
        return score;
    }

    private static double analyzeDepthAndOreType(List<StatsManager.BlockBreakRecord> breaks) {
        long suspiciousDebris;
        HashMap<Integer, List> oresByLevel = new HashMap<Integer, List>();
        for (StatsManager.BlockBreakRecord record : breaks) {
            if (!StatsManager.trackedOres.contains(record.type)) continue;
            oresByLevel.computeIfAbsent(record.y, k -> new ArrayList()).add(record.type);
        }
        double score = 0.0;
        long suspiciousDiamonds = oresByLevel.entrySet().stream().filter(e -> (Integer)e.getKey() > 16).flatMap(e -> ((List)e.getValue()).stream()).filter(m -> m == Material.DIAMOND_ORE || m == Material.DEEPSLATE_DIAMOND_ORE).count();
        if (suspiciousDiamonds > 0L) {
            score += (double)suspiciousDiamonds * 5.0;
        }
        if ((suspiciousDebris = oresByLevel.entrySet().stream().filter(e -> (Integer)e.getKey() > 16 || (Integer)e.getKey() < -64).flatMap(e -> ((List)e.getValue()).stream()).filter(m -> m == Material.ANCIENT_DEBRIS).count()) > 0L) {
            score += (double)suspiciousDebris * 6.0;
        }
        return score;
    }

    private static double analyzeSessionConsistency(UUID playerId, List<StatsManager.BlockBreakRecord> breaks) {
        int previousCount;
        double previousAvg;
        if (!playerSuspicionHistory.containsKey(playerId) || playerSuspicionHistory.get(playerId).size() < 3) {
            return 0.0;
        }
        List<Double> history = playerSuspicionHistory.get(playerId);
        int historySize = history.size();
        if (historySize < 4) {
            return 0.0;
        }
        int recentCount = Math.min(3, historySize);
        double currentAvg = history.subList(historySize - recentCount, historySize).stream().mapToDouble(Double::doubleValue).average().orElse(0.0);
        if (currentAvg > (previousAvg = history.subList(0, previousCount = Math.max(1, historySize - recentCount)).stream().mapToDouble(Double::doubleValue).average().orElse(0.0)) * 2.0 && currentAvg > 0.4) {
            return 5.0;
        }
        return 0.0;
    }

    private static void updateSuspicionHistory(UUID playerId, double score) {
        List<Double> history = playerSuspicionHistory.computeIfAbsent(playerId, k -> new ArrayList());
        history.add(score);
        if (history.size() > 10) {
            history = history.subList(history.size() - 10, history.size());
            playerSuspicionHistory.put(playerId, history);
        }
    }

    private static double adjustForTrends(UUID playerId, double score) {
        if (!playerSuspicionHistory.containsKey(playerId) || playerSuspicionHistory.get(playerId).size() < 3) {
            return score;
        }
        List<Double> history = playerSuspicionHistory.get(playerId);
        int historySize = history.size();
        if (historySize < 3) {
            return score;
        }
        boolean increasingTrend = true;
        for (int i = 1; i < Math.min(3, historySize); ++i) {
            if (!(history.get(historySize - i) < history.get(historySize - i - 1))) continue;
            increasingTrend = false;
            break;
        }
        if (increasingTrend && score > 0.3) {
            return score * 1.2;
        }
        return score;
    }

    private static double getCombinedScore(UUID playerId) {
        double heuristicScore = MiningPatternAnalyzer.calculateSuspicionScore(playerId);
        if (!mlAnalysisEnabled || mlAnalyzer == null) {
            return heuristicScore / 25.0;
        }
        double mlProbability = mlAnalyzer.analyzePlayer(playerId);
        double normalizedHeuristicScore = heuristicScore / 25.0;
        return normalizedHeuristicScore * 0.3 + mlProbability * 0.7;
    }

    private static boolean isCaveMiningPattern(List<StatsManager.BlockBreakRecord> breaks) {
        if (breaks.size() < 20) {
            return false;
        }
        double yVariance = MiningPatternAnalyzer.calculateYVariance(breaks);
        double straightness = MiningPatternAnalyzer.computeOverallStraightness(breaks);
        double singleLayerRatio = MiningPatternAnalyzer.calculateSingleLayerRatio(breaks);
        double typeVariety = MiningPatternAnalyzer.calculateBlockTypeVariety(breaks);
        return yVariance > 1.8 && straightness < 0.75 && singleLayerRatio < 0.75 || yVariance > 1.5 && typeVariety > 0.15;
    }

    private static double calculateYVariance(List<StatsManager.BlockBreakRecord> breaks) {
        double sum = 0.0;
        double sumSq = 0.0;
        for (StatsManager.BlockBreakRecord record : breaks) {
            sum += (double)record.y;
            sumSq += (double)(record.y * record.y);
        }
        double mean = sum / (double)breaks.size();
        double variance = sumSq / (double)breaks.size() - mean * mean;
        return Math.sqrt(variance);
    }

    private static double computeOverallStraightness(List<StatsManager.BlockBreakRecord> breaks) {
        if (breaks.size() < 3) {
            return 1.0;
        }
        double pathLength = 0.0;
        for (int i = 1; i < breaks.size(); ++i) {
            StatsManager.BlockBreakRecord prev = breaks.get(i - 1);
            StatsManager.BlockBreakRecord curr = breaks.get(i);
            double dx = curr.x - prev.x;
            double dy = curr.y - prev.y;
            double dz = curr.z - prev.z;
            pathLength += Math.sqrt(dx * dx + dy * dy + dz * dz);
        }
        StatsManager.BlockBreakRecord first = breaks.get(0);
        StatsManager.BlockBreakRecord last = breaks.get(breaks.size() - 1);
        double dx = last.x - first.x;
        double dy = last.y - first.y;
        double dz = last.z - first.z;
        double directDistance = Math.sqrt(dx * dx + dy * dy + dz * dz);
        return directDistance / pathLength;
    }

    private static double calculateSingleLayerRatio(List<StatsManager.BlockBreakRecord> breaks) {
        HashMap<Integer, Integer> yLevelCounts = new HashMap<Integer, Integer>();
        for (StatsManager.BlockBreakRecord record : breaks) {
            yLevelCounts.put(record.y, yLevelCounts.getOrDefault(record.y, 0) + 1);
        }
        int maxCount = 0;
        Iterator iterator = yLevelCounts.values().iterator();
        while (iterator.hasNext()) {
            int count = (Integer)iterator.next();
            if (count <= maxCount) continue;
            maxCount = count;
        }
        return (double)maxCount / (double)breaks.size();
    }

    private static double calculateBlockTypeVariety(List<StatsManager.BlockBreakRecord> breaks) {
        HashSet<Material> uniqueTypes = new HashSet<Material>();
        for (StatsManager.BlockBreakRecord record : breaks) {
            uniqueTypes.add(record.type);
        }
        return (double)uniqueTypes.size() / (double)breaks.size();
    }

    static {
        playerSuspicionHistory = new ConcurrentHashMap<UUID, List<Double>>();
    }
}

