/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.punishments.handlers;

import java.util.Collection;
import java.util.concurrent.ThreadLocalRandom;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.myplugin.deepGuardXray.config.ConfigManager;
import org.myplugin.deepGuardXray.deepGuardXray;
import org.myplugin.deepGuardXray.managers.PunishmentManager;
import org.myplugin.deepGuardXray.punishments.AbstractPunishmentHandler;

public class ResourceTaxHandler
extends AbstractPunishmentHandler {
    public ResourceTaxHandler(deepGuardXray plugin, ConfigManager configManager, PunishmentManager punishmentManager) {
        super(plugin, configManager, punishmentManager);
    }

    @Override
    public boolean processBlockBreak(Player player, Block block) {
        Material ore = block.getType();
        if (!this.isOre(ore)) {
            return false;
        }
        Collection drops = block.getDrops(player.getInventory().getItemInMainHand());
        if (!drops.isEmpty()) {
            int totalTaxCollected = 0;
            String oreName = this.formatItemName(ore);
            for (ItemStack drop : drops) {
                int originalAmount = drop.getAmount();
                int taxedAmount = 0;
                int taxAmount = 0;
                if (this.isValuableOre(ore)) {
                    if (originalAmount == 1) {
                        if (ThreadLocalRandom.current().nextInt(100) < 25) {
                            taxedAmount = 1;
                            taxAmount = 0;
                        } else {
                            taxedAmount = 0;
                            taxAmount = 1;
                        }
                    } else {
                        taxAmount = (int)Math.ceil((double)originalAmount * 0.75);
                        taxedAmount = originalAmount - taxAmount;
                    }
                } else if (originalAmount == 1) {
                    if (ThreadLocalRandom.current().nextBoolean()) {
                        taxedAmount = 1;
                        taxAmount = 0;
                    } else {
                        taxedAmount = 0;
                        taxAmount = 1;
                    }
                } else {
                    taxAmount = originalAmount / 2;
                    if (originalAmount % 2 == 1 && ThreadLocalRandom.current().nextBoolean()) {
                        ++taxAmount;
                    }
                    taxedAmount = originalAmount - taxAmount;
                }
                totalTaxCollected += taxAmount;
                if (taxedAmount <= 0) continue;
                ItemStack taxedDrop = drop.clone();
                taxedDrop.setAmount(taxedAmount);
                block.getWorld().dropItemNaturally(block.getLocation(), taxedDrop);
            }
            if (totalTaxCollected > 0) {
                player.getWorld().spawnParticle(Particle.DUST, block.getLocation().add(0.5, 0.5, 0.5), 8, 0.2, 0.2, 0.2, 0.01, (Object)new Particle.DustOptions(Color.RED, 1.0f));
                player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.5f, 0.5f);
                String taxRate = this.isValuableOre(ore) ? "75%" : "50%";
                player.sendMessage(Component.text((String)("Resource tax collected: " + totalTaxCollected + " " + oreName + " (" + taxRate + " tax rate)")).color((TextColor)NamedTextColor.RED));
                if (ThreadLocalRandom.current().nextInt(10) == 0) {
                    player.sendMessage(Component.text((String)"The tax rate is determined by your suspicious mining behavior.").color((TextColor)NamedTextColor.GRAY));
                }
            }
        }
        block.setType(Material.AIR);
        return true;
    }

    @Override
    public boolean isActive(Player player) {
        return this.punishmentManager.hasResourceTax(player.getUniqueId());
    }
}

