/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.punishments.handlers.Paranoia.cooldown;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class CooldownManager {
    private final Map<UUID, Map<CooldownType, Long>> cooldowns = new HashMap<UUID, Map<CooldownType, Long>>();

    public boolean isOnCooldown(UUID playerId, CooldownType type) {
        if (!this.cooldowns.containsKey(playerId)) {
            return false;
        }
        Map<CooldownType, Long> playerCooldowns = this.cooldowns.get(playerId);
        if (!playerCooldowns.containsKey((Object)type)) {
            return false;
        }
        return System.currentTimeMillis() - playerCooldowns.get((Object)type) < type.getDuration();
    }

    public void setCooldown(UUID playerId, CooldownType type) {
        this.cooldowns.computeIfAbsent(playerId, k -> new HashMap()).put(type, System.currentTimeMillis());
    }

    public long getRemainingCooldown(UUID playerId, CooldownType type) {
        if (!this.isOnCooldown(playerId, type)) {
            return 0L;
        }
        long elapsedTime = System.currentTimeMillis() - this.cooldowns.get(playerId).get((Object)type);
        return Math.max(0L, type.getDuration() - elapsedTime);
    }

    public void removeCooldown(UUID playerId, CooldownType type) {
        if (this.cooldowns.containsKey(playerId)) {
            this.cooldowns.get(playerId).remove((Object)type);
        }
    }

    public void clearPlayerCooldowns(UUID playerId) {
        this.cooldowns.remove(playerId);
    }

    public static enum CooldownType {
        GHOST_MOB(15000L),
        VISUAL(8000L),
        FAKE_DAMAGE(30000L),
        MESSAGE(20000L),
        SOUND(3000L),
        NIGHTMARE(1800000L);

        private final long duration;

        private CooldownType(long duration) {
            this.duration = duration;
        }

        public long getDuration() {
            return this.duration;
        }
    }
}

