/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.punishments;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.myplugin.deepGuardXray.config.ConfigManager;
import org.myplugin.deepGuardXray.deepGuardXray;
import org.myplugin.deepGuardXray.managers.PunishmentManager;
import org.myplugin.deepGuardXray.punishments.PunishmentHandler;
import org.myplugin.deepGuardXray.punishments.handlers.AreaRestrictionHandler;
import org.myplugin.deepGuardXray.punishments.handlers.CursedPickaxeHandler;
import org.myplugin.deepGuardXray.punishments.handlers.FakeDiamondsHandler;
import org.myplugin.deepGuardXray.punishments.handlers.FakeOreHandler;
import org.myplugin.deepGuardXray.punishments.handlers.FakeOreVeinsHandler;
import org.myplugin.deepGuardXray.punishments.handlers.FoolsGoldHandler;
import org.myplugin.deepGuardXray.punishments.handlers.MiningLicenseSuspensionHandler;
import org.myplugin.deepGuardXray.punishments.handlers.Paranoia.ParanoiaHandler;
import org.myplugin.deepGuardXray.punishments.handlers.PermanentMiningDebuffHandler;
import org.myplugin.deepGuardXray.punishments.handlers.ResourceTaxHandler;
import org.myplugin.deepGuardXray.punishments.handlers.StaffReviewHandler;

public class PunishmentHandlerManager {
    private final List<PunishmentHandler> handlers = new ArrayList<PunishmentHandler>();
    private final deepGuardXray plugin;
    private final ConfigManager configManager;

    public PunishmentHandlerManager(deepGuardXray plugin, ConfigManager configManager, PunishmentManager punishmentManager, ParanoiaHandler paranoiaHandler) {
        this.plugin = plugin;
        this.configManager = configManager;
        this.handlers.add(new FoolsGoldHandler(plugin, configManager, punishmentManager));
        this.handlers.add(new FakeOreVeinsHandler(plugin, configManager, punishmentManager));
        this.handlers.add(new FakeOreHandler(plugin, configManager, punishmentManager));
        this.handlers.add(new MiningLicenseSuspensionHandler(plugin, configManager, punishmentManager));
        this.handlers.add(new AreaRestrictionHandler(plugin, configManager, punishmentManager));
        this.handlers.add(new PermanentMiningDebuffHandler(plugin, configManager, punishmentManager));
        this.handlers.add(new StaffReviewHandler(plugin, configManager, punishmentManager));
        this.handlers.add(new ResourceTaxHandler(plugin, configManager, punishmentManager));
        this.handlers.add(new CursedPickaxeHandler(plugin, configManager, punishmentManager));
        this.handlers.add(new FakeDiamondsHandler(plugin, configManager, punishmentManager));
    }

    public boolean processBlockBreak(BlockBreakEvent event, Player player, Block block) {
        if (this.configManager.isDebugEnabled()) {
            this.plugin.getLogger().info("Processing block break through punishment handlers for " + player.getName() + " at " + String.valueOf(block.getLocation()));
        }
        for (PunishmentHandler handler : this.handlers) {
            boolean cancel;
            if (!handler.isActive(player)) continue;
            if (this.configManager.isDebugEnabled()) {
                this.plugin.getLogger().info("  - Checking handler: " + handler.getClass().getSimpleName());
            }
            if (!(cancel = handler.processBlockBreak(player, block))) continue;
            if (this.configManager.isDebugEnabled()) {
                this.plugin.getLogger().info("  - Handler " + handler.getClass().getSimpleName() + " cancelled further processing");
            }
            return true;
        }
        return false;
    }
}

