/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.managers;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.myplugin.deepGuardXray.config.ConfigManager;
import org.myplugin.deepGuardXray.deepGuardXray;

public class WebhookManager {
    private static WebhookManager instance;
    private static deepGuardXray plugin;
    private static ConfigManager configManager;

    private WebhookManager(deepGuardXray pluginInstance, ConfigManager configManagerInstance) {
        plugin = pluginInstance;
        configManager = configManagerInstance;
    }

    public static void initialize(deepGuardXray pluginInstance, ConfigManager configManagerInstance) {
        if (instance == null) {
            instance = new WebhookManager(pluginInstance, configManagerInstance);
        }
        plugin = pluginInstance;
        configManager = configManagerInstance;
    }

    public static WebhookManager getInstance() {
        return instance;
    }

    public static void sendTestMessage(String webhookUrl, String staffName) {
        String serverName = Bukkit.getServer().getName();
        if (serverName.isEmpty()) {
            serverName = "Minecraft Server";
        }
        String jsonPayload = String.format("{\"embeds\":[{\"title\":\"DeepGuardXray Test Message\",\"description\":\"This is a test message from DeepGuardXray plugin.\",\"color\":5814783,\"fields\":[{\"name\":\"Server\",\"value\":\"%s\",\"inline\":true},{\"name\":\"Sent By\",\"value\":\"%s\",\"inline\":true},{\"name\":\"Plugin Version\",\"value\":\"%s\",\"inline\":true}],\"footer\":{\"text\":\"DeepGuardXray Webhook \u2022 %s\"}}],\"username\":\"DeepGuardXray\",\"avatar_url\":\"https://i.imgur.com/C9BaYta.png\"}", serverName, staffName, plugin.getDescription().getVersion(), WebhookManager.getCurrentTimestamp());
        WebhookManager.sendWebhookAsync(webhookUrl, jsonPayload);
    }

    public void sendPunishmentAlertWithAdmin(Player player, int level, String punishmentType, String adminName) {
        if (!WebhookManager.shouldSendAlert("punishment_applied")) {
            return;
        }
        String webhookUrl = configManager.getWebhookUrl();
        if (webhookUrl == null || webhookUrl.isEmpty()) {
            return;
        }
        String jsonPayload = String.format("{\"embeds\":[{\"title\":\"\ud83d\uded1 Punishment Applied\",\"description\":\"Punishment has been applied to a player.\",\"color\":10038562,\"fields\":[{\"name\":\"Player\",\"value\":\"%s\",\"inline\":true},{\"name\":\"Level\",\"value\":\"%d\",\"inline\":true},{\"name\":\"Type\",\"value\":\"%s\",\"inline\":true},{\"name\":\"Applied By\",\"value\":\"%s\",\"inline\":true}],\"footer\":{\"text\":\"DeepGuardXray \u2022 %s\"}}],\"username\":\"DeepGuardXray\",\"avatar_url\":\"https://i.imgur.com/C9BaYta.png\"}", player.getName(), level, punishmentType, adminName, WebhookManager.getCurrentTimestamp());
        WebhookManager.sendWebhookAsync(webhookUrl, jsonPayload);
    }

    public void sendXrayAlert(Player player, String oreType, Location location, double confidence) {
        if (!WebhookManager.shouldSendAlert("xray_detection")) {
            return;
        }
        String webhookUrl = configManager.getWebhookUrl();
        if (webhookUrl == null || webhookUrl.isEmpty()) {
            return;
        }
        String coords = String.format("X: %d, Y: %d, Z: %d", location.getBlockX(), location.getBlockY(), location.getBlockZ());
        String world = location.getWorld().getName();
        String jsonPayload = String.format("{\"embeds\":[{\"title\":\"\u26cf X-Ray Detection Alert\",\"description\":\"Potential X-Ray hacking detected!\",\"color\":16711680,\"fields\":[{\"name\":\"Player\",\"value\":\"%s\",\"inline\":true},{\"name\":\"Ore Type\",\"value\":\"%s\",\"inline\":true},{\"name\":\"Confidence\",\"value\":\"%.1f%%\",\"inline\":true},{\"name\":\"Location\",\"value\":\"%s, %s\",\"inline\":false}],\"footer\":{\"text\":\"DeepGuardXray \u2022 %s\"}}],\"username\":\"DeepGuardXray\",\"avatar_url\":\"https://i.imgur.com/C9BaYta.png\"}", player.getName(), oreType, confidence, coords, world, WebhookManager.getCurrentTimestamp());
        WebhookManager.sendWebhookAsync(webhookUrl, jsonPayload);
    }

    public void sendSuspiciousMiningAlert(Player player, String pattern, double score) {
        if (!WebhookManager.shouldSendAlert("suspicious_mining")) {
            return;
        }
        String webhookUrl = configManager.getWebhookUrl();
        if (webhookUrl == null || webhookUrl.isEmpty()) {
            return;
        }
        String jsonPayload = String.format("{\"embeds\":[{\"title\":\"\u26a0\ufe0f Suspicious Mining Pattern\",\"description\":\"A player has triggered the mining pattern detector!\",\"color\":16750848,\"fields\":[{\"name\":\"Player\",\"value\":\"%s\",\"inline\":true},{\"name\":\"Pattern\",\"value\":\"%s\",\"inline\":true},{\"name\":\"Suspicion Score\",\"value\":\"%.1f/100\",\"inline\":true}],\"footer\":{\"text\":\"DeepGuardXray \u2022 %s\"}}],\"username\":\"DeepGuardXray\",\"avatar_url\":\"https://i.imgur.com/C9BaYta.png\"}", player.getName(), pattern, score, WebhookManager.getCurrentTimestamp());
        WebhookManager.sendWebhookAsync(webhookUrl, jsonPayload);
    }

    public void sendPunishmentAlert(Player player, int level, String punishmentType) {
        if (!WebhookManager.shouldSendAlert("punishment_applied")) {
            return;
        }
        String webhookUrl = configManager.getWebhookUrl();
        if (webhookUrl == null || webhookUrl.isEmpty()) {
            return;
        }
        String jsonPayload = String.format("{\"embeds\":[{\"title\":\"\ud83d\uded1 Punishment Applied\",\"description\":\"Punishment has been applied to a player.\",\"color\":10038562,\"fields\":[{\"name\":\"Player\",\"value\":\"%s\",\"inline\":true},{\"name\":\"Level\",\"value\":\"%d\",\"inline\":true},{\"name\":\"Type\",\"value\":\"%s\",\"inline\":true}],\"footer\":{\"text\":\"DeepGuardXray \u2022 %s\"}}],\"username\":\"DeepGuardXray\",\"avatar_url\":\"https://i.imgur.com/C9BaYta.png\"}", player.getName(), level, punishmentType, WebhookManager.getCurrentTimestamp());
        WebhookManager.sendWebhookAsync(webhookUrl, jsonPayload);
    }

    public void sendStaffActionLog(String staffName, String action, String target) {
        if (!WebhookManager.shouldSendAlert("staff_actions")) {
            return;
        }
        String webhookUrl = configManager.getWebhookUrl();
        if (webhookUrl == null || webhookUrl.isEmpty()) {
            return;
        }
        String jsonPayload = String.format("{\"embeds\":[{\"title\":\"\ud83d\udc6e Staff Action Log\",\"description\":\"A staff member performed an action.\",\"color\":3447003,\"fields\":[{\"name\":\"Staff\",\"value\":\"%s\",\"inline\":true},{\"name\":\"Action\",\"value\":\"%s\",\"inline\":true},{\"name\":\"Target\",\"value\":\"%s\",\"inline\":true}],\"footer\":{\"text\":\"DeepGuardXray \u2022 %s\"}}],\"username\":\"DeepGuardXray\",\"avatar_url\":\"https://i.imgur.com/C9BaYta.png\"}", staffName, action, target, WebhookManager.getCurrentTimestamp());
        WebhookManager.sendWebhookAsync(webhookUrl, jsonPayload);
    }

    private static boolean shouldSendAlert(String alertType) {
        return configManager != null && configManager.isWebhookAlertEnabled(alertType);
    }

    private static void sendWebhookAsync(String webhookUrl, String jsonPayload) {
        if (webhookUrl == null || webhookUrl.isEmpty() || !webhookUrl.startsWith("https://discord.com/api/webhooks/") && !webhookUrl.startsWith("https://discordapp.com/api/webhooks/")) {
            plugin.getLogger().warning("Invalid webhook URL format. Must start with https://discord.com/api/webhooks/");
            return;
        }
        CompletableFuture.runAsync(() -> {
            try {
                URL url = new URL(webhookUrl);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setDoOutput(true);
                byte[] postData = jsonPayload.getBytes(StandardCharsets.UTF_8);
                connection.setRequestProperty("Content-Length", String.valueOf(postData.length));
                try (OutputStream stream = connection.getOutputStream();){
                    stream.write(postData);
                }
                int responseCode = connection.getResponseCode();
                if (responseCode == 204) {
                    plugin.getLogger().info("Webhook message sent successfully");
                } else {
                    plugin.getLogger().warning("Failed to send webhook message. Response code: " + responseCode);
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getErrorStream()));){
                        String line;
                        StringBuilder error = new StringBuilder();
                        while ((line = reader.readLine()) != null) {
                            error.append(line);
                        }
                        plugin.getLogger().warning("Error details: " + error.toString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                connection.disconnect();
            }
            catch (Exception e) {
                plugin.getLogger().severe("Error sending webhook: " + e.getMessage());
                e.printStackTrace();
            }
        });
    }

    private static String getCurrentTimestamp() {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }
}

