/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.managers;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.myplugin.deepGuardXray.utils.MiningPatternAnalyzer;

public class StatsManager {
    private static final Map<UUID, Long> lastBreakTime = new HashMap<UUID, Long>();
    private static final Map<UUID, Double> avgInterval = new HashMap<UUID, Double>();
    private static final Map<UUID, Deque<BlockBreakRecord>> recentBreaks = new HashMap<UUID, Deque<BlockBreakRecord>>();
    private static final int MAX_RECENT_BREAKS = 100;
    public static final Set<Material> trackedOres = new HashSet<Material>(Arrays.asList(Material.DIAMOND_ORE, Material.DEEPSLATE_DIAMOND_ORE, Material.EMERALD_ORE, Material.DEEPSLATE_EMERALD_ORE, Material.GOLD_ORE, Material.DEEPSLATE_GOLD_ORE, Material.IRON_ORE, Material.DEEPSLATE_IRON_ORE, Material.COAL_ORE, Material.DEEPSLATE_COAL_ORE, Material.COPPER_ORE, Material.DEEPSLATE_COPPER_ORE, Material.LAPIS_ORE, Material.DEEPSLATE_LAPIS_ORE, Material.REDSTONE_ORE, Material.DEEPSLATE_REDSTONE_ORE, Material.NETHER_GOLD_ORE, Material.NETHER_QUARTZ_ORE, Material.ANCIENT_DEBRIS));
    private static final Map<UUID, Map<Material, Integer>> cumulativeStats = new HashMap<UUID, Map<Material, Integer>>();

    public static void recordBlockBreak(UUID playerId, long timestamp, Block block, ItemStack tool, boolean hasHaste, double yaw, double pitch) {
        if (!MiningPatternAnalyzer.isMLAnalysisEnabled()) {
            return;
        }
        if (!lastBreakTime.containsKey(playerId)) {
            lastBreakTime.put(playerId, timestamp);
            avgInterval.put(playerId, 0.0);
        } else {
            long previousTime = lastBreakTime.get(playerId);
            long interval = timestamp - previousTime;
            double alpha = 0.2;
            double oldAverage = avgInterval.getOrDefault(playerId, Double.valueOf(interval));
            double newAverage = alpha * (double)interval + (1.0 - alpha) * oldAverage;
            avgInterval.put(playerId, newAverage);
            lastBreakTime.put(playerId, timestamp);
        }
        Deque breaks = recentBreaks.computeIfAbsent(playerId, k -> new LinkedList());
        breaks.addLast(new BlockBreakRecord(timestamp, block, tool, hasHaste, yaw, pitch));
        if (breaks.size() > 100) {
            breaks.removeFirst();
        }
    }

    public static double getAverageInterval(UUID playerId) {
        return avgInterval.getOrDefault(playerId, 0.0);
    }

    public static Deque<BlockBreakRecord> getRecentBreaks(UUID playerId) {
        if (!MiningPatternAnalyzer.isMLAnalysisEnabled()) {
            return new LinkedList<BlockBreakRecord>();
        }
        return recentBreaks.getOrDefault(playerId, new LinkedList());
    }

    public static void addOreMined(UUID playerId, Material ore) {
        if (!trackedOres.contains(ore)) {
            return;
        }
        cumulativeStats.computeIfAbsent(playerId, k -> new HashMap()).merge(ore, 1, Integer::sum);
    }

    public static Map<Material, Integer> getOreStats(UUID playerId) {
        return cumulativeStats.getOrDefault(playerId, new HashMap());
    }

    public static void saveStats(File file) {
        YamlConfiguration config = new YamlConfiguration();
        for (Map.Entry<UUID, Map<Material, Integer>> entry : cumulativeStats.entrySet()) {
            String uuid = entry.getKey().toString();
            Map<Material, Integer> ores = entry.getValue();
            for (Map.Entry<Material, Integer> oreEntry : ores.entrySet()) {
                String path = "stats." + uuid + "." + oreEntry.getKey().name();
                config.set(path, (Object)oreEntry.getValue());
            }
        }
        try {
            config.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadStats(File file) {
        if (!file.exists()) {
            return;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        if (config.contains("stats")) {
            for (String uuidString : config.getConfigurationSection("stats").getKeys(false)) {
                UUID uuid = UUID.fromString(uuidString);
                HashMap<Material, Integer> ores = new HashMap<Material, Integer>();
                for (String oreName : config.getConfigurationSection("stats." + uuidString).getKeys(false)) {
                    int count = config.getInt("stats." + uuidString + "." + oreName);
                    Material ore = Material.getMaterial((String)oreName);
                    if (ore == null) continue;
                    ores.put(ore, count);
                }
                cumulativeStats.put(uuid, ores);
            }
        }
    }

    public static class BlockBreakRecord {
        public long timestamp;
        public int x;
        public int y;
        public int z;
        public Material type;
        public Material toolType;
        public int efficiencyLevel;
        public boolean hasHaste;
        public double yaw;
        public double pitch;

        BlockBreakRecord(long timestamp, Block block, ItemStack tool, boolean hasHaste, double yaw, double pitch) {
            this.timestamp = timestamp;
            this.x = block.getX();
            this.y = block.getY();
            this.z = block.getZ();
            this.type = block.getType();
            this.toolType = tool != null ? tool.getType() : Material.AIR;
            this.efficiencyLevel = tool != null ? tool.getEnchantmentLevel(Enchantment.EFFICIENCY) : 0;
            this.hasHaste = hasHaste;
            this.yaw = yaw;
            this.pitch = pitch;
        }
    }
}

