/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.gui.subgui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.myplugin.deepGuardXray.gui.StaffMenuGUI;
import org.myplugin.deepGuardXray.gui.subgui.MLAnalysisGUI;
import org.myplugin.deepGuardXray.managers.SuspiciousManager;
import org.myplugin.deepGuardXray.utils.MiningPatternAnalyzer;

public class SuspiciousPlayersGUI {
    private Inventory inv;
    private final List<UUID> suspiciousPlayers;
    private final int itemsPerPage = 36;
    private final int currentPage;
    private final int totalPages;
    private final Map<Integer, UUID> playerSlots = new HashMap<Integer, UUID>();
    private boolean useMLAnalysis = true;
    public static final String PERMISSION = "deepguardx.gui_suspicious";
    public static final String ML_TOGGLE_PERMISSION = "deepguardx.gui_mltoggle";

    public SuspiciousPlayersGUI(int currentPage) {
        this.currentPage = currentPage;
        this.inv = Bukkit.createInventory(null, (int)54, (Component)Component.text((String)"\ud83d\udd0d Suspicious Activity").color((TextColor)NamedTextColor.AQUA));
        this.useMLAnalysis = MiningPatternAnalyzer.isMLAnalysisEnabled();
        this.suspiciousPlayers = new ArrayList<UUID>();
        Map<UUID, Integer> counts = SuspiciousManager.getSuspiciousCounts();
        this.suspiciousPlayers.addAll(counts.keySet());
        if (this.useMLAnalysis) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                Map<String, Object> analysis;
                UUID playerId = player.getUniqueId();
                if (this.suspiciousPlayers.contains(playerId) || (analysis = MiningPatternAnalyzer.getDetailedAnalysis(playerId)).containsKey("error")) continue;
                double mlScore = 0.0;
                if (analysis.containsKey("combinedScore")) {
                    mlScore = (Double)analysis.get("combinedScore");
                } else if (analysis.containsKey("mlProbability")) {
                    mlScore = (Double)analysis.get("mlProbability");
                }
                if (!(mlScore > 0.4)) continue;
                this.suspiciousPlayers.add(playerId);
            }
        }
        this.totalPages = (int)Math.ceil((double)this.suspiciousPlayers.size() / 36.0);
        this.initializeItems();
    }

    private void initializeItems() {
        this.inv.clear();
        this.playerSlots.clear();
        this.setNavigationItems();
        int startIndex = this.currentPage * 36;
        int endIndex = Math.min(startIndex + 36, this.suspiciousPlayers.size());
        int slot = 0;
        for (int i = startIndex; i < endIndex && slot < 36; ++slot, ++i) {
            Player onlinePlayer;
            UUID uuid = this.suspiciousPlayers.get(i);
            OfflinePlayer op = Bukkit.getOfflinePlayer((UUID)uuid);
            int count = 0;
            if (SuspiciousManager.getSuspiciousCounts().containsKey(uuid)) {
                count = SuspiciousManager.getSuspiciousCounts().get(uuid);
            }
            if ((onlinePlayer = Bukkit.getPlayer((UUID)uuid)) != null && this.useMLAnalysis) {
                Map<String, Object> analysis = MiningPatternAnalyzer.getDetailedAnalysis(uuid);
                if (!analysis.containsKey("error")) {
                    this.inv.setItem(slot, this.createPlayerHeadWithML(op, count, analysis));
                } else {
                    this.inv.setItem(slot, this.createPlayerHead(op, count));
                }
            } else {
                this.inv.setItem(slot, this.createPlayerHead(op, count));
            }
            this.playerSlots.put(slot, uuid);
        }
        ItemStack mlToggle = new ItemStack(this.useMLAnalysis ? Material.REDSTONE_TORCH : Material.TORCH);
        ItemMeta mlMeta = mlToggle.getItemMeta();
        Component toggleName = ((TextComponent)Component.text((String)"ML Analysis: ").color((TextColor)NamedTextColor.GOLD)).append(Component.text((String)(this.useMLAnalysis ? "ON" : "OFF")).color((TextColor)(this.useMLAnalysis ? NamedTextColor.GREEN : NamedTextColor.RED)));
        mlMeta.displayName(toggleName);
        ArrayList<Component> mlLore = new ArrayList<Component>();
        mlLore.add(Component.text((String)("Click to " + (this.useMLAnalysis ? "disable" : "enable") + " machine learning analysis")).color((TextColor)NamedTextColor.GRAY));
        mlLore.add(Component.text((String)"Requires permission: deepguardx.gui_mltoggle").color((TextColor)NamedTextColor.YELLOW));
        mlMeta.lore(mlLore);
        mlToggle.setItemMeta(mlMeta);
        this.inv.setItem(47, mlToggle);
        ItemStack backButton = new ItemStack(Material.BARRIER);
        ItemMeta backMeta = backButton.getItemMeta();
        backMeta.displayName(Component.text((String)"Back to \u26cf Staff Control Panel").color((TextColor)NamedTextColor.RED));
        backButton.setItemMeta(backMeta);
        this.inv.setItem(49, backButton);
    }

    private void setNavigationItems() {
        if (this.currentPage > 0) {
            this.inv.setItem(45, this.createNavItem(Material.ARROW, "Previous Page", NamedTextColor.GREEN));
        } else {
            this.inv.setItem(45, this.createNavItem(Material.BARRIER, "No Previous Page", NamedTextColor.RED));
        }
        this.inv.setItem(46, this.createNavItem(Material.PAPER, "Page " + (this.currentPage + 1) + "/" + Math.max(1, this.totalPages), NamedTextColor.YELLOW));
        if (this.currentPage < this.totalPages - 1) {
            this.inv.setItem(53, this.createNavItem(Material.ARROW, "Next Page", NamedTextColor.GREEN));
        } else {
            this.inv.setItem(53, this.createNavItem(Material.BARRIER, "No Next Page", NamedTextColor.RED));
        }
    }

    private ItemStack createNavItem(Material material, String name, NamedTextColor color) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.displayName(Component.text((String)name).color((TextColor)color));
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createPlayerHead(OfflinePlayer op, int suspiciousCount) {
        ItemStack head = new ItemStack(Material.PLAYER_HEAD, 1);
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        meta.setOwningPlayer(op);
        meta.displayName(Component.text((String)op.getName()).color((TextColor)NamedTextColor.GOLD));
        int level = suspiciousCount / 10;
        int xpForNextLevel = (level + 1) * 10;
        int xpThisLevel = suspiciousCount % 10;
        int progressPercent = (int)((double)xpThisLevel / 10.0 * 100.0);
        Component progressBar = this.getProgressBar(progressPercent, 10);
        String patternStatus = MiningPatternAnalyzer.analyzeMiningPattern(op.getUniqueId());
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(Component.text((String)("Decoy Ore Mined: " + suspiciousCount)).color((TextColor)NamedTextColor.GRAY));
        lore.add(Component.text((String)("Level: " + level)).color((TextColor)NamedTextColor.GRAY));
        lore.add(((TextComponent)((TextComponent)Component.text((String)"Progress: ").color((TextColor)NamedTextColor.GRAY)).append(progressBar)).append(Component.text((String)(" " + progressPercent + "%")).color((TextColor)NamedTextColor.GRAY)));
        if (patternStatus.equals("Analysis Disabled")) {
            lore.add(Component.text((String)("Mining Pattern: " + patternStatus)).color((TextColor)NamedTextColor.RED));
        } else {
            lore.add(Component.text((String)("Mining Pattern: " + patternStatus)).color((TextColor)NamedTextColor.GRAY));
        }
        lore.add(this.getSuspiciousStatusComponent(suspiciousCount));
        lore.add(Component.text((String)""));
        lore.add(Component.text((String)"Click to view details").color((TextColor)NamedTextColor.WHITE));
        meta.lore(lore);
        head.setItemMeta((ItemMeta)meta);
        return head;
    }

    private ItemStack createPlayerHeadWithML(OfflinePlayer op, int suspiciousCount, Map<String, Object> analysis) {
        ItemStack head = new ItemStack(Material.PLAYER_HEAD, 1);
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        meta.setOwningPlayer(op);
        meta.displayName(Component.text((String)op.getName()).color((TextColor)NamedTextColor.GOLD));
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(Component.text((String)("Decoy Ore Mined: " + suspiciousCount)).color((TextColor)NamedTextColor.GRAY));
        int level = suspiciousCount / 10;
        int progressPercent = (int)((double)(suspiciousCount % 10) / 10.0 * 100.0);
        Component progressBar = this.getProgressBar(progressPercent, 10);
        lore.add(Component.text((String)("Level: " + level)).color((TextColor)NamedTextColor.GRAY));
        lore.add(((TextComponent)((TextComponent)Component.text((String)"Progress: ").color((TextColor)NamedTextColor.GRAY)).append(progressBar)).append(Component.text((String)(" " + progressPercent + "%")).color((TextColor)NamedTextColor.GRAY)));
        lore.add(this.getSuspiciousStatusComponent(suspiciousCount));
        lore.add(Component.text((String)""));
        lore.add(Component.text((String)"\ud83e\udd16 Machine Learning Analysis").color((TextColor)NamedTextColor.GOLD));
        if (!this.useMLAnalysis || analysis.containsKey("mlDisabled")) {
            lore.add(Component.text((String)"ML Analysis is currently DISABLED").color((TextColor)NamedTextColor.RED));
            lore.add(Component.text((String)"Enable ML Analysis to see detailed results").color((TextColor)NamedTextColor.GRAY));
            lore.add(Component.text((String)"Mining Pattern: Analysis Disabled").color((TextColor)NamedTextColor.RED));
        } else {
            double mlScore = 0.0;
            double combinedScore = 0.0;
            if (analysis.containsKey("mlProbability")) {
                mlScore = (Double)analysis.get("mlProbability");
            }
            if (analysis.containsKey("combinedScore")) {
                combinedScore = (Double)analysis.get("combinedScore");
            }
            lore.add(Component.text((String)("ML Score: " + String.format("%.2f", mlScore))).color((TextColor)NamedTextColor.YELLOW));
            lore.add(Component.text((String)("Combined Score: " + String.format("%.2f", combinedScore))).color((TextColor)NamedTextColor.YELLOW));
            lore.add(((TextComponent)Component.text((String)"Classification: ").color((TextColor)NamedTextColor.GRAY)).append(this.getMLStatusComponent(combinedScore)));
            String patternStatus = MiningPatternAnalyzer.analyzeMiningPattern(op.getUniqueId());
            lore.add(Component.text((String)("Mining Pattern: " + patternStatus)).color((TextColor)NamedTextColor.GRAY));
        }
        lore.add(Component.text((String)""));
        lore.add(Component.text((String)"Click to view detailed analysis").color((TextColor)NamedTextColor.WHITE));
        meta.lore(lore);
        head.setItemMeta((ItemMeta)meta);
        return head;
    }

    private Component getProgressBar(int percent, int totalBars) {
        int filledBars = (int)Math.round((double)percent / 100.0 * (double)totalBars);
        TextComponent bar = Component.empty();
        for (int i = 0; i < totalBars; ++i) {
            bar = i < filledBars ? bar.append(Component.text((String)"|").color((TextColor)NamedTextColor.GREEN)) : bar.append(Component.text((String)"|").color((TextColor)NamedTextColor.DARK_GRAY));
        }
        return bar;
    }

    private Component getSuspiciousStatusComponent(int suspiciousCount) {
        Component baseText = Component.text((String)"Status: ").color((TextColor)NamedTextColor.GRAY);
        if (suspiciousCount < 10) {
            return baseText.append(Component.text((String)"Low").color((TextColor)NamedTextColor.GREEN)).append(Component.text((String)" (Might be mined by luck)").color((TextColor)NamedTextColor.GRAY));
        }
        if (suspiciousCount < 20) {
            return baseText.append(Component.text((String)"Mid").color((TextColor)NamedTextColor.YELLOW)).append(Component.text((String)" (It's probably okay, right?)").color((TextColor)NamedTextColor.GRAY));
        }
        if (suspiciousCount < 30) {
            return baseText.append(Component.text((String)"High").color((TextColor)NamedTextColor.GOLD)).append(Component.text((String)" (Something's definitely off)").color((TextColor)NamedTextColor.GRAY));
        }
        if (suspiciousCount < 40) {
            return baseText.append(Component.text((String)"Extreme").color((TextColor)NamedTextColor.RED)).append(Component.text((String)" (This one is seriously fishy!)").color((TextColor)NamedTextColor.GRAY));
        }
        if (suspiciousCount < 50) {
            return baseText.append(Component.text((String)"Insane").color((TextColor)NamedTextColor.DARK_RED)).append(Component.text((String)" (No way, that's downright criminal!)").color((TextColor)NamedTextColor.GRAY));
        }
        return baseText.append(Component.text((String)"Godlike").color((TextColor)NamedTextColor.LIGHT_PURPLE)).append(Component.text((String)" (Absolutely beyond reason!)").color((TextColor)NamedTextColor.GRAY));
    }

    private Component getMLStatusComponent(double score) {
        if (score > 0.8) {
            return Component.text((String)"Highly Suspicious").color((TextColor)NamedTextColor.DARK_RED);
        }
        if (score > 0.6) {
            return Component.text((String)"Suspicious").color((TextColor)NamedTextColor.RED);
        }
        if (score > 0.4) {
            return Component.text((String)"Moderately Suspicious").color((TextColor)NamedTextColor.GOLD);
        }
        if (score > 0.2) {
            return Component.text((String)"Slightly Suspicious").color((TextColor)NamedTextColor.YELLOW);
        }
        return Component.text((String)"Normal").color((TextColor)NamedTextColor.GREEN);
    }

    public void openInventory(Player player) {
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(Component.text((String)"You do not have permission to view suspicious players.").color((TextColor)NamedTextColor.RED));
            return;
        }
        player.openInventory(this.inv);
    }

    public static void handleClick(Player staff, int slot, Inventory clickedInventory) {
        SuspiciousPlayersGUI gui = new SuspiciousPlayersGUI(0);
        if (slot == 45 && clickedInventory.getItem(45).getType() == Material.ARROW) {
            Component title = clickedInventory.getItem(46).getItemMeta().displayName();
            String titleText = title.toString();
            int currentPage = Integer.parseInt(titleText.split("/")[0].split(" ")[1]) - 1;
            new SuspiciousPlayersGUI(currentPage - 1).openInventory(staff);
        } else if (slot == 53 && clickedInventory.getItem(53).getType() == Material.ARROW) {
            Component title = clickedInventory.getItem(46).getItemMeta().displayName();
            String titleText = title.toString();
            int currentPage = Integer.parseInt(titleText.split("/")[0].split(" ")[1]) - 1;
            new SuspiciousPlayersGUI(currentPage + 1).openInventory(staff);
        } else {
            UUID playerId;
            if (slot == 47) {
                if (!staff.hasPermission(ML_TOGGLE_PERMISSION)) {
                    staff.sendMessage(Component.text((String)"You do not have permission to toggle ML analysis.").color((TextColor)NamedTextColor.RED));
                    return;
                }
                Component title = clickedInventory.getItem(47).getItemMeta().displayName();
                boolean currentState = title.toString().contains("ON");
                gui.useMLAnalysis = !currentState;
                MiningPatternAnalyzer.setMLAnalysisEnabled(!currentState);
                staff.sendMessage(((TextComponent)Component.text((String)"ML Analysis is now ").color((TextColor)NamedTextColor.GOLD)).append(Component.text((String)(!currentState ? "ENABLED" : "DISABLED")).color((TextColor)(!currentState ? NamedTextColor.GREEN : NamedTextColor.RED))));
                new SuspiciousPlayersGUI(0).openInventory(staff);
                return;
            }
            if (slot == 49) {
                new StaffMenuGUI().openInventory(staff);
            } else if (slot < 36 && clickedInventory.getItem(slot) != null && clickedInventory.getItem(slot).getType() == Material.PLAYER_HEAD && (playerId = gui.playerSlots.get(slot)) != null) {
                Player target = Bukkit.getPlayer((UUID)playerId);
                if (target != null) {
                    Map<String, Object> analysis = MiningPatternAnalyzer.getDetailedAnalysis(playerId);
                    if (!analysis.containsKey("error")) {
                        new MLAnalysisGUI(target, analysis).openInventory(staff);
                    } else {
                        staff.sendMessage(Component.text((String)"Not enough mining data for ML analysis").color((TextColor)NamedTextColor.RED));
                    }
                } else {
                    staff.sendMessage(Component.text((String)"Player is offline, ML analysis unavailable").color((TextColor)NamedTextColor.RED));
                }
            }
        }
    }

    public Map<Integer, UUID> getPlayerSlots() {
        return this.playerSlots;
    }
}

