/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.gui.subgui;

import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class PlayerStatsMainGUI {
    private Inventory inv;
    private int currentPage;
    private final int itemsPerPage = 45;
    private final List<Player> players;
    private final int totalPages;

    public PlayerStatsMainGUI(int currentPage) {
        this.currentPage = currentPage;
        this.inv = Bukkit.createInventory(null, (int)54, (Component)Component.text((String)"\ud83d\udcca Player Analytics").color((TextColor)NamedTextColor.AQUA));
        this.players = new ArrayList<Player>(Bukkit.getOnlinePlayers());
        this.totalPages = (int)Math.ceil((double)this.players.size() / 45.0);
        this.initializeItems();
    }

    private void initializeItems() {
        this.inv.clear();
        this.setNavigationItems();
        int startIndex = this.currentPage * 45;
        int endIndex = Math.min(startIndex + 45, this.players.size());
        int slot = 0;
        for (int i = startIndex; i < endIndex; ++i) {
            while (slot == 45) {
                ++slot;
            }
            Player p = this.players.get(i);
            this.inv.setItem(slot, this.createPlayerHead(p));
            ++slot;
        }
    }

    private void setNavigationItems() {
        if (this.currentPage > 0) {
            this.inv.setItem(45, this.createNavItem(Material.ARROW, "Previous Page", NamedTextColor.GREEN));
        } else {
            this.inv.setItem(45, this.createNavItem(Material.BARRIER, "No Previous Page", NamedTextColor.RED));
        }
        this.inv.setItem(47, this.createNavItem(Material.BARRIER, "Back to \u26cf Staff Control Panel", NamedTextColor.RED));
        this.inv.setItem(49, this.createNavItem(Material.PAPER, "Page " + (this.currentPage + 1) + " / " + this.totalPages, NamedTextColor.YELLOW));
        if (this.currentPage < this.totalPages - 1) {
            this.inv.setItem(53, this.createNavItem(Material.ARROW, "Next Page", NamedTextColor.GREEN));
        } else {
            this.inv.setItem(53, this.createNavItem(Material.BARRIER, "No Next Page", NamedTextColor.RED));
        }
    }

    private ItemStack createNavItem(Material material, String name, NamedTextColor color) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.displayName(Component.text((String)name).color((TextColor)color));
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createPlayerHead(Player player) {
        ItemStack head = new ItemStack(Material.PLAYER_HEAD, 1);
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        meta.setOwningPlayer((OfflinePlayer)player);
        meta.displayName(Component.text((String)player.getName()).color((TextColor)NamedTextColor.GOLD));
        ArrayList<Component> lore = new ArrayList<Component>();
        lore.add(Component.text((String)"Click to view mining stats").color((TextColor)NamedTextColor.GRAY));
        meta.lore(lore);
        head.setItemMeta((ItemMeta)meta);
        return head;
    }

    public void openInventory(Player player) {
        player.openInventory(this.inv);
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public int getTotalPages() {
        return this.totalPages;
    }
}

