/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.gui.subgui;

import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.myplugin.deepGuardXray.managers.StatsManager;

public class PlayerMiningStatsGUI {
    private Inventory inv;
    private UUID targetPlayerId;
    private String targetPlayerName;

    public PlayerMiningStatsGUI(UUID playerId, String playerName) {
        this.targetPlayerId = playerId;
        this.targetPlayerName = playerName;
        this.inv = Bukkit.createInventory(null, (int)27, (Component)Component.text((String)(this.targetPlayerName + "'s Mining Stats")).color((TextColor)NamedTextColor.BLUE));
        this.initializeItems();
    }

    private void initializeItems() {
        Map<Material, Integer> oreStats = StatsManager.getOreStats(this.targetPlayerId);
        int index = 0;
        for (Map.Entry<Material, Integer> entry : oreStats.entrySet()) {
            ItemStack oreItem = new ItemStack(entry.getKey(), 1);
            ItemMeta meta = oreItem.getItemMeta();
            meta.displayName(Component.text((String)entry.getKey().name()).color((TextColor)NamedTextColor.GOLD));
            ArrayList<Component> lore = new ArrayList<Component>();
            lore.add(Component.text((String)("Mined: " + String.valueOf(entry.getValue()))).color((TextColor)NamedTextColor.GRAY));
            meta.lore(lore);
            oreItem.setItemMeta(meta);
            this.inv.setItem(index, oreItem);
            if (++index < this.inv.getSize() - 1) continue;
            break;
        }
        ItemStack backButton = new ItemStack(Material.ARROW);
        ItemMeta backMeta = backButton.getItemMeta();
        backMeta.displayName(Component.text((String)"Back to \ud83d\udcca Player Analytics").color((TextColor)NamedTextColor.GREEN));
        backButton.setItemMeta(backMeta);
        this.inv.setItem(26, backButton);
    }

    public void openInventory(Player player) {
        player.openInventory(this.inv);
    }

    public Inventory getInventory() {
        return this.inv;
    }
}

