/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.gui.subgui;

import java.util.ArrayList;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.myplugin.deepGuardXray.gui.subgui.SuspiciousPlayersGUI;
import org.myplugin.deepGuardXray.utils.MiningPatternAnalyzer;

public class MLAnalysisGUI {
    private final Player targetPlayer;
    private final Map<String, Object> analysisData;
    private final Inventory gui;
    public static final String PERMISSION = "deepguardx.gui_ml";

    public static void openDisabledMLAnalysisGUI(Player staff, Player target) {
        Inventory inv = Bukkit.createInventory(null, (int)27, (Component)Component.text((String)("\ud83e\udd16 ML Analysis: " + target.getName())).color((TextColor)NamedTextColor.DARK_RED));
        ItemStack disabledItem = new ItemStack(Material.BARRIER);
        ItemMeta meta = disabledItem.getItemMeta();
        meta.displayName(Component.text((String)"Machine Learning Analysis is Disabled").color((TextColor)NamedTextColor.RED));
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(Component.text((String)"ML Analysis is currently turned off").color((TextColor)NamedTextColor.GRAY));
        lore.add(Component.text((String)"Enable it in the Suspicious Players menu").color((TextColor)NamedTextColor.GRAY));
        lore.add(Component.text((String)"to view detailed analysis").color((TextColor)NamedTextColor.GRAY));
        lore.add(Component.text((String)" "));
        lore.add(Component.text((String)"Toggle ML Analysis in the Suspicious Players").color((TextColor)NamedTextColor.YELLOW));
        lore.add(Component.text((String)"menu to enable this feature").color((TextColor)NamedTextColor.YELLOW));
        meta.lore(lore);
        disabledItem.setItemMeta(meta);
        inv.setItem(13, disabledItem);
        ItemStack backButton = new ItemStack(Material.ARROW);
        ItemMeta backMeta = backButton.getItemMeta();
        backMeta.displayName(Component.text((String)"Back to \ud83d\udd0d Suspicious Activity").color((TextColor)NamedTextColor.GREEN));
        backButton.setItemMeta(backMeta);
        inv.setItem(18, backButton);
        staff.openInventory(inv);
    }

    public MLAnalysisGUI(Player targetPlayer, Map<String, Object> analysisData) {
        this.targetPlayer = targetPlayer;
        this.analysisData = analysisData;
        this.gui = Bukkit.createInventory(null, (int)36, (Component)Component.text((String)("\ud83e\udd16 ML Analysis: " + targetPlayer.getName())).color((TextColor)NamedTextColor.DARK_RED));
        if (analysisData.containsKey("mlDisabled") && ((Boolean)analysisData.get("mlDisabled")).booleanValue()) {
            ItemStack disabledItem = new ItemStack(Material.BARRIER);
            ItemMeta meta = disabledItem.getItemMeta();
            meta.displayName(Component.text((String)"Analysis is disabled").color((TextColor)NamedTextColor.RED));
            ArrayList<Component> lore = new ArrayList<Component>();
            lore.add(Component.text((String)"Please use ML toggle to enable analysis").color((TextColor)NamedTextColor.GRAY));
            meta.lore(lore);
            disabledItem.setItemMeta(meta);
            ItemStack backButton = new ItemStack(Material.BARRIER);
            ItemMeta backMeta = backButton.getItemMeta();
            backMeta.displayName(Component.text((String)"Back to \ud83d\udd0d Suspicious Activity").color((TextColor)NamedTextColor.RED));
            backButton.setItemMeta(backMeta);
            this.gui.setItem(35, backButton);
            for (int i = 0; i < 27; ++i) {
                if (this.gui.getItem(i) != null) continue;
                this.gui.setItem(i, disabledItem);
            }
        } else {
            this.setupGUI();
        }
    }

    private void setupGUI() {
        ItemStack playerHead = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta headMeta = (SkullMeta)playerHead.getItemMeta();
        headMeta.setOwningPlayer((OfflinePlayer)this.targetPlayer);
        headMeta.displayName(Component.text((String)(this.targetPlayer.getName() + "'s Mining Analysis")).color((TextColor)NamedTextColor.GOLD));
        ArrayList<Object> headLore = new ArrayList<Object>();
        double heuristicScore = this.getDoubleValue("heuristicTotalScore");
        double mlScore = this.getDoubleValue("mlProbability");
        double combinedScore = this.getDoubleValue("combinedScore");
        headLore.add(Component.text((String)("Heuristic Score: " + this.formatScore(heuristicScore))).color((TextColor)NamedTextColor.YELLOW));
        headLore.add(Component.text((String)("ML Probability: " + this.formatScore(mlScore))).color((TextColor)NamedTextColor.YELLOW));
        headLore.add(Component.text((String)("Combined Score: " + this.formatScore(combinedScore))).color((TextColor)NamedTextColor.YELLOW));
        headLore.add(Component.text((String)" "));
        headLore.add(this.getClassification(combinedScore));
        headMeta.lore(headLore);
        playerHead.setItemMeta((ItemMeta)headMeta);
        this.gui.setItem(4, playerHead);
        this.gui.setItem(10, this.createFeatureItem("Straightness", "straightnessScore", Material.RAIL));
        this.gui.setItem(11, this.createFeatureItem("Block Variety", "blockVarietyScore", Material.STONE));
        this.gui.setItem(12, this.createFeatureItem("Time Variance", "timeVarianceScore", Material.CLOCK));
        this.gui.setItem(13, this.createFeatureItem("Adjacency", "adjacencyScore", Material.DIAMOND_PICKAXE));
        this.gui.setItem(14, this.createFeatureItem("Orientation", "orientationScore", Material.COMPASS));
        this.gui.setItem(28, this.createActionItem("Flag as Legitimate", Material.LIME_WOOL, false));
        this.gui.setItem(30, this.createActionItem("Teleport to Player", Material.ENDER_PEARL, null));
        this.gui.setItem(32, this.createActionItem("Flag as Cheating", Material.RED_WOOL, true));
        ItemStack backButton = new ItemStack(Material.BARRIER);
        ItemMeta backMeta = backButton.getItemMeta();
        backMeta.displayName(Component.text((String)"Back to \ud83d\udd0d Suspicious Activity").color((TextColor)NamedTextColor.RED));
        backButton.setItemMeta(backMeta);
        this.gui.setItem(35, backButton);
    }

    private String formatScore(double score) {
        return String.format("%.2f", score);
    }

    private Component getClassification(double score) {
        if (score > 0.8) {
            return Component.text((String)"Classification: Highly Suspicious").color((TextColor)NamedTextColor.RED);
        }
        if (score > 0.5) {
            return Component.text((String)"Classification: Suspicious").color((TextColor)NamedTextColor.GOLD);
        }
        return Component.text((String)"Classification: Normal").color((TextColor)NamedTextColor.GREEN);
    }

    private double getDoubleValue(String key) {
        Object value = this.analysisData.get(key);
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Integer) {
            return ((Integer)value).doubleValue();
        }
        if (value instanceof Float) {
            return ((Float)value).doubleValue();
        }
        return 0.0;
    }

    private ItemStack createFeatureItem(String name, String dataKey, Material material) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.displayName(Component.text((String)(name + " Analysis")).color((TextColor)NamedTextColor.YELLOW));
        ArrayList<Component> lore = new ArrayList<Component>();
        double value = this.getDoubleValue(dataKey);
        lore.add(Component.text((String)("Score: " + this.formatScore(value))).color((TextColor)NamedTextColor.WHITE));
        if (value > 5.0) {
            lore.add(Component.text((String)"Very Suspicious").color((TextColor)NamedTextColor.RED));
        } else if (value > 2.0) {
            lore.add(Component.text((String)"Somewhat Suspicious").color((TextColor)NamedTextColor.GOLD));
        } else {
            lore.add(Component.text((String)"Normal").color((TextColor)NamedTextColor.GREEN));
        }
        meta.lore(lore);
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createActionItem(String name, Material material, Boolean flagValue) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.displayName(Component.text((String)name).color((TextColor)NamedTextColor.YELLOW));
        ArrayList<Component> lore = new ArrayList<Component>();
        if (flagValue != null) {
            Component clickText = Component.text((String)"Click to flag player as ").color((TextColor)NamedTextColor.WHITE);
            Component flagText = flagValue != false ? Component.text((String)"cheating").color((TextColor)NamedTextColor.RED) : Component.text((String)"legitimate").color((TextColor)NamedTextColor.GREEN);
            lore.add(clickText.append(flagText));
            lore.add(Component.text((String)"This helps train the ML system").color((TextColor)NamedTextColor.GRAY));
        } else {
            lore.add(Component.text((String)"Click to teleport to player's location").color((TextColor)NamedTextColor.WHITE));
        }
        meta.lore(lore);
        item.setItemMeta(meta);
        return item;
    }

    public void openInventory(Player staff) {
        if (!staff.hasPermission(PERMISSION)) {
            staff.sendMessage(Component.text((String)"You do not have permission to view ML analysis.").color((TextColor)NamedTextColor.RED));
            return;
        }
        staff.openInventory(this.gui);
    }

    public static void handleClick(Player staff, int slot, Player targetPlayer) {
        if (slot == 28) {
            MiningPatternAnalyzer.flagPlayerForLearning(targetPlayer.getUniqueId(), false);
            staff.sendMessage(Component.text((String)("Player " + targetPlayer.getName() + " flagged as legitimate for ML training")).color((TextColor)NamedTextColor.GREEN));
        } else if (slot == 32) {
            MiningPatternAnalyzer.flagPlayerForLearning(targetPlayer.getUniqueId(), true);
            staff.sendMessage(Component.text((String)("Player " + targetPlayer.getName() + " flagged as cheating for ML training")).color((TextColor)NamedTextColor.GREEN));
        } else if (slot == 30) {
            staff.teleport(targetPlayer.getLocation());
            staff.sendMessage(Component.text((String)("Teleported to " + targetPlayer.getName())).color((TextColor)NamedTextColor.GREEN));
        } else if (slot == 35 || slot == 18) {
            new SuspiciousPlayersGUI(0).openInventory(staff);
        }
    }
}

