/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.gui.subgui;

import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.myplugin.deepGuardXray.config.ConfigManager;
import org.myplugin.deepGuardXray.deepGuardXray;
import org.myplugin.deepGuardXray.gui.StaffMenuGUI;
import org.myplugin.deepGuardXray.utils.DirectConfigSaver;

public class ConfigSettingsGUI {
    private final Inventory inv;
    private final ConfigManager configManager;
    private final deepGuardXray plugin;
    private static final String TITLE = "\u2699 Plugin Configuration";
    public static final String PERMISSION = "deepguardx.gui_config";

    public ConfigSettingsGUI(ConfigManager configManager, deepGuardXray plugin) {
        this.configManager = configManager;
        this.plugin = plugin;
        this.inv = Bukkit.createInventory(null, (int)54, (Component)Component.text((String)TITLE).color((TextColor)NamedTextColor.AQUA));
        this.initializeItems();
    }

    private void initializeItems() {
        int i;
        ItemStack border = this.createGuiItem(Material.GRAY_STAINED_GLASS_PANE, " ", false);
        ItemStack divider = this.createGuiItem(Material.BLUE_STAINED_GLASS_PANE, "\u2699 Settings", true, TextDecoration.BOLD, NamedTextColor.DARK_BLUE, new Component[0]);
        for (i = 0; i < 9; ++i) {
            this.inv.setItem(i, border);
            this.inv.setItem(45 + i, border);
        }
        for (i = 0; i < 6; ++i) {
            this.inv.setItem(i * 9, border);
            this.inv.setItem(i * 9 + 8, border);
        }
        this.inv.setItem(18, divider);
        this.inv.setItem(23, divider);
        this.inv.setItem(24, divider);
        this.inv.setItem(25, divider);
        this.inv.setItem(26, divider);
        this.inv.setItem(4, this.createGuiItem(Material.REDSTONE, "Plugin Configuration", true, TextDecoration.BOLD, NamedTextColor.RED, Component.text((String)"Configure plugin settings").color((TextColor)NamedTextColor.GRAY)));
        this.inv.setItem(13, this.createGuiItem(Material.DIAMOND_PICKAXE, "Decoy Settings", true, TextDecoration.BOLD, NamedTextColor.AQUA, Component.text((String)"Configure decoy settings").color((TextColor)NamedTextColor.GRAY)));
        this.inv.setItem(31, this.createGuiItem(Material.SHIELD, "Staff Settings", true, TextDecoration.BOLD, NamedTextColor.GREEN, Component.text((String)"Configure staff settings").color((TextColor)NamedTextColor.GRAY)));
        this.inv.setItem(49, this.createGuiItem(Material.BARRIER, "Back to \u26cf Staff Control Panel", false, null, NamedTextColor.RED, new Component[0]));
        this.addDecoySettings();
        this.addStaffSettings();
    }

    private void addDecoySettings() {
        int slot = 10;
        this.inv.setItem(slot++, this.createToggleItem("Decoy Enabled", this.configManager.isDecoyEnabled(), "Enables or disables the decoy system", "decoy.enabled"));
        this.inv.setItem(slot++, this.createNumberItem("Ore Threshold", this.configManager.getOreThreshold(), "Number of ores before decoy triggers", "decoy.oreThreshold"));
        this.inv.setItem(slot++, this.createNumberItem("Time Window (ticks)", (int)this.configManager.getTimeWindowTicks(), "Time window for counting ores (1200 = 1 minute)", "decoy.timeWindowTicks"));
        this.inv.setItem(slot++, this.createNumberItem("Decoy Distance", (int)this.configManager.getDecoyDistance(), "Distance from mined block to place decoy", "decoy.distance"));
        this.inv.setItem(slot++, this.createNumberItem("Field Offset", this.configManager.getDecoyFieldOffset(), "Offset used in decoy placement", "decoy.fieldOffset"));
        this.inv.setItem(slot++, this.createNumberItem("Max Decay Distance", this.configManager.getMaxDecayDistance(), "Max distance before decoy reverts", "decoy.maxDistance"));
        this.inv.setItem(slot++, this.createNumberItem("Revert Delay (ticks)", this.configManager.getDecoyRevertDelay(), "Delay before decoy reverts (1200 = 1 minute)", "decoy.revertDelay"));
        slot = 19;
        this.inv.setItem(slot++, this.createToggleItem("Warn On Decoy", this.configManager.isWarnOnDecoy(), "Warn players when they break a decoy", "decoy.warnOnDecoy"));
        this.inv.setItem(slot++, this.createToggleItem("Require Buried", this.configManager.isDecoyRequireBuried(), "Only place decoys in buried locations", "decoy.requireBuried"));
        this.inv.setItem(slot++, this.createNumberItem("Search Radius", this.configManager.getDecoySearchRadius(), "Radius to search for decoy placement", "decoy.searchRadius"));
        this.inv.setItem(slot++, this.createNumberItem("Buried Threshold", this.configManager.getBuriedThreshold(), "Blocks needed to consider a location buried", "decoy.buriedThreshold"));
    }

    private void addStaffSettings() {
        int slot = 37;
        this.inv.setItem(slot++, this.createToggleItem("Staff Ore Alerts", this.configManager.isStaffOreAlerts(), "Alert staff for each ore mined", "staff.oreAlerts"));
        this.inv.setItem(slot++, this.createNumberItem("Ore Reset Time (ticks)", this.configManager.getStaffOreResetTime(), "Time before ore counter resets (36000 = 30 minutes)", "staff.oreResetTime"));
        this.inv.setItem(slot++, this.createToggleItem("Staff Alert Enabled", this.configManager.isStaffAlertEnabled(), "Alert staff when decoy ore is broken", "staff.alertEnabled"));
        this.inv.setItem(slot++, this.createToggleItem("Debug Enabled", this.configManager.isDebugEnabled(), "Enable debug logging", "debug.enabled"));
    }

    private ItemStack createToggleItem(String name, boolean value, String description, String configPath) {
        Material material = value ? Material.LIME_CONCRETE : Material.RED_CONCRETE;
        Component status = value ? Component.text((String)"ENABLED").color((TextColor)NamedTextColor.GREEN) : Component.text((String)"DISABLED").color((TextColor)NamedTextColor.RED);
        ArrayList<Component> lore = new ArrayList<Component>();
        lore.add(Component.text((String)description).color((TextColor)NamedTextColor.GRAY));
        lore.add(status);
        lore.add(Component.text((String)"Click to toggle").color((TextColor)NamedTextColor.YELLOW));
        lore.add(Component.text((String)("Config path: " + configPath)).color((TextColor)NamedTextColor.DARK_GRAY));
        return this.createGuiItemWithLore(material, Component.text((String)name).color((TextColor)NamedTextColor.GOLD), value, lore);
    }

    private ItemStack createNumberItem(String name, Number value, String description, String configPath) {
        ArrayList<Component> lore = new ArrayList<Component>();
        lore.add(Component.text((String)description).color((TextColor)NamedTextColor.GRAY));
        lore.add(((TextComponent)Component.text((String)"Current value: ").color((TextColor)NamedTextColor.AQUA)).append(Component.text((String)value.toString()).color((TextColor)NamedTextColor.WHITE)));
        lore.add(Component.text((String)"Left-click to increase").color((TextColor)NamedTextColor.YELLOW));
        lore.add(Component.text((String)"Right-click to decrease").color((TextColor)NamedTextColor.YELLOW));
        lore.add(Component.text((String)("Config path: " + configPath)).color((TextColor)NamedTextColor.DARK_GRAY));
        return this.createGuiItemWithLore(Material.PAPER, Component.text((String)name).color((TextColor)NamedTextColor.GOLD), false, lore);
    }

    private ItemStack createGuiItem(Material material, String name, boolean enchanted, TextDecoration decoration, NamedTextColor color, Component ... lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        TextComponent displayName = Component.text((String)name);
        if (color != null) {
            displayName = displayName.color((TextColor)color);
        }
        if (decoration != null) {
            displayName = displayName.decorate(decoration);
        }
        meta.displayName((Component)displayName);
        if (lore.length > 0) {
            ArrayList<Component> itemLore = new ArrayList<Component>();
            for (Component loreLine : lore) {
                itemLore.add(loreLine);
            }
            meta.lore(itemLore);
        }
        if (enchanted) {
            meta.addEnchant(Enchantment.DENSITY, 1, true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createGuiItem(Material material, String name, boolean enchanted) {
        return this.createGuiItem(material, name, enchanted, null, null, new Component[0]);
    }

    private ItemStack createGuiItemWithLore(Material material, Component displayName, boolean enchanted, List<Component> lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.displayName(displayName);
        if (lore != null && !lore.isEmpty()) {
            meta.lore(lore);
        }
        if (enchanted) {
            meta.addEnchant(Enchantment.DENSITY, 1, true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        item.setItemMeta(meta);
        return item;
    }

    public void openInventory(Player player) {
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(Component.text((String)"You don't have permission to access the config settings.").color((TextColor)NamedTextColor.RED));
            return;
        }
        player.openInventory(this.inv);
    }

    public static void handleClick(Player player, int slot, Inventory inventory, ClickType clickType, ConfigManager configManager, deepGuardXray plugin) {
        block20: {
            boolean isHeader;
            if (!player.hasPermission(PERMISSION)) {
                player.sendMessage(Component.text((String)"You don't have permission to modify the config settings.").color((TextColor)NamedTextColor.RED));
                player.closeInventory();
                return;
            }
            if (slot == 49) {
                new StaffMenuGUI().openInventory(player);
                return;
            }
            boolean isBorder = slot < 9 || slot % 9 == 0 || slot % 9 == 8 || slot >= 45;
            boolean isDivider = slot == 18 || slot == 23 || slot == 24 || slot == 25 || slot == 26;
            boolean bl = isHeader = slot == 4 || slot == 31;
            if (isBorder || isDivider || isHeader) {
                return;
            }
            plugin.getLogger().info("Processing click on slot " + slot);
            ItemStack clicked = inventory.getItem(slot);
            if (clicked == null || !clicked.hasItemMeta() || !clicked.getItemMeta().hasLore()) {
                plugin.getLogger().warning("Invalid item clicked or no lore found in slot " + slot);
                return;
            }
            List lore = clicked.getItemMeta().lore();
            if (lore == null || lore.isEmpty()) {
                plugin.getLogger().warning("Lore is null or empty in slot " + slot);
                return;
            }
            Component configPathComponent = (Component)lore.get(lore.size() - 1);
            String configPathLine = PlainTextComponentSerializer.plainText().serialize(configPathComponent);
            if (!configPathLine.contains("Config path:")) {
                plugin.getLogger().warning("Clicked item doesn't have a valid config path in lore: " + configPathLine);
                return;
            }
            String configPath = configPathLine.substring(configPathLine.lastIndexOf("Config path:") + 12).trim();
            plugin.getLogger().info("Processing click for config path: " + configPath);
            if (clicked.getType() == Material.LIME_CONCRETE || clicked.getType() == Material.RED_CONCRETE) {
                boolean currentValue = clicked.getType() == Material.LIME_CONCRETE;
                boolean newValue = !currentValue;
                plugin.getLogger().info("Toggling " + configPath + " from " + currentValue + " to " + newValue);
                boolean success = DirectConfigSaver.saveBoolean(plugin, configPath, newValue);
                if (success) {
                    plugin.reloadConfig();
                    configManager.reloadConfig();
                    player.sendMessage(((TextComponent)((TextComponent)((TextComponent)Component.text((String)"Setting ").color((TextColor)NamedTextColor.GOLD)).append(Component.text((String)configPath).color((TextColor)NamedTextColor.YELLOW))).append(Component.text((String)" changed to ").color((TextColor)NamedTextColor.GOLD))).append(Component.text((String)(newValue ? "ENABLED" : "DISABLED")).color((TextColor)(newValue ? NamedTextColor.GREEN : NamedTextColor.RED))));
                    new ConfigSettingsGUI(configManager, plugin).openInventory(player);
                } else {
                    player.sendMessage(Component.text((String)"Failed to save config change. Check console for details.").color((TextColor)NamedTextColor.RED));
                }
                return;
            }
            if (clicked.getType() == Material.PAPER) {
                Component valueLine = (Component)lore.get(1);
                String valueStr = PlainTextComponentSerializer.plainText().serialize(valueLine);
                String extractedValue = valueStr.substring(valueStr.lastIndexOf(": ") + 2).trim();
                plugin.getLogger().info("Extracted value string: " + extractedValue);
                boolean isInteger = !extractedValue.contains(".");
                boolean isLeftClick = clickType == ClickType.LEFT || clickType == ClickType.SHIFT_LEFT;
                boolean isRightClick = clickType == ClickType.RIGHT || clickType == ClickType.SHIFT_RIGHT;
                plugin.getLogger().info("Click type: " + String.valueOf(clickType) + ", isLeftClick: " + isLeftClick + ", isRightClick: " + isRightClick);
                if (!isLeftClick && !isRightClick) {
                    player.sendMessage(Component.text((String)"Please use left-click to increase or right-click to decrease the value.").color((TextColor)NamedTextColor.RED));
                    return;
                }
                if (isInteger) {
                    try {
                        int currentValue = Integer.parseInt(extractedValue);
                        int newValue = isLeftClick ? (configPath.equals("staff.oreResetTime") ? currentValue + 6000 : (configPath.equals("decoy.timeWindowTicks") || configPath.equals("decoy.revertDelay") ? currentValue + 1200 : currentValue + 1)) : (configPath.equals("staff.oreResetTime") ? Math.max(6000, currentValue - 6000) : (configPath.equals("decoy.timeWindowTicks") || configPath.equals("decoy.revertDelay") ? Math.max(1200, currentValue - 1200) : Math.max(1, currentValue - 1)));
                        plugin.getLogger().info("Changing " + configPath + " from " + currentValue + " to " + newValue);
                        boolean success = DirectConfigSaver.saveInteger(plugin, configPath, newValue);
                        if (success) {
                            plugin.reloadConfig();
                            configManager.reloadConfig();
                            new ConfigSettingsGUI(configManager, plugin).openInventory(player);
                            player.sendMessage(((TextComponent)((TextComponent)((TextComponent)Component.text((String)"Setting ").color((TextColor)NamedTextColor.GOLD)).append(Component.text((String)configPath).color((TextColor)NamedTextColor.YELLOW))).append(Component.text((String)" updated to ").color((TextColor)NamedTextColor.GOLD))).append(Component.text((String)String.valueOf(newValue)).color((TextColor)NamedTextColor.AQUA)));
                            break block20;
                        }
                        player.sendMessage(Component.text((String)"Failed to save config change. Check console for details.").color((TextColor)NamedTextColor.RED));
                    }
                    catch (NumberFormatException e) {
                        plugin.getLogger().severe("Error parsing integer value: " + extractedValue);
                        plugin.getLogger().severe("Exception: " + e.getMessage());
                        player.sendMessage(Component.text((String)"Error parsing number. Please report this to a developer.").color((TextColor)NamedTextColor.RED));
                    }
                } else {
                    try {
                        double currentValue = Double.parseDouble(extractedValue);
                        double newValue = isLeftClick ? currentValue + 0.1 : Math.max(0.1, currentValue - 0.1);
                        newValue = (double)Math.round(newValue * 10.0) / 10.0;
                        plugin.getLogger().info("Changing " + configPath + " from " + currentValue + " to " + newValue);
                        boolean success = DirectConfigSaver.saveDouble(plugin, configPath, newValue);
                        if (success) {
                            plugin.reloadConfig();
                            configManager.reloadConfig();
                            new ConfigSettingsGUI(configManager, plugin).openInventory(player);
                            player.sendMessage(((TextComponent)((TextComponent)((TextComponent)Component.text((String)"Setting ").color((TextColor)NamedTextColor.GOLD)).append(Component.text((String)configPath).color((TextColor)NamedTextColor.YELLOW))).append(Component.text((String)" updated to ").color((TextColor)NamedTextColor.GOLD))).append(Component.text((String)String.valueOf(newValue)).color((TextColor)NamedTextColor.AQUA)));
                        } else {
                            player.sendMessage(Component.text((String)"Failed to save config change. Check console for details.").color((TextColor)NamedTextColor.RED));
                        }
                    }
                    catch (NumberFormatException e) {
                        plugin.getLogger().severe("Error parsing double value: " + extractedValue);
                        plugin.getLogger().severe("Exception: " + e.getMessage());
                        player.sendMessage(Component.text((String)"Error parsing number. Please report this to a developer.").color((TextColor)NamedTextColor.RED));
                    }
                }
            }
        }
    }
}

