/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.gui;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.myplugin.deepGuardXray.deepGuardXray;
import org.myplugin.deepGuardXray.gui.StaffMenuGUI;
import org.myplugin.deepGuardXray.gui.subgui.ConfigSettingsGUI;
import org.myplugin.deepGuardXray.gui.subgui.LevelPunishmentSettingsGUI;
import org.myplugin.deepGuardXray.gui.subgui.MLAnalysisGUI;
import org.myplugin.deepGuardXray.gui.subgui.OreConfigGUI;
import org.myplugin.deepGuardXray.gui.subgui.PlayerStatsMainGUI;
import org.myplugin.deepGuardXray.gui.subgui.PunishmentSettingsGUI;
import org.myplugin.deepGuardXray.gui.subgui.SuspiciousPlayersGUI;
import org.myplugin.deepGuardXray.gui.subgui.WebhookSettingsGUI;
import org.myplugin.deepGuardXray.utils.MiningPatternAnalyzer;

public class GuiListener
implements Listener {
    private final deepGuardXray plugin;
    private final Map<UUID, Player> mlAnalysisTargets = new HashMap<UUID, Player>();

    public GuiListener(deepGuardXray plugin) {
        this.plugin = plugin;
        StaffMenuGUI.setPlugin(plugin);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Component title = event.getView().title();
        String titlePlainText = PlainTextComponentSerializer.plainText().serialize(title);
        if (titlePlainText.contains("DeepGuard-XRay Control Panel") || titlePlainText.contains("\ud83d\udd0d Suspicious Activity") || titlePlainText.contains("\u2696 Punishment System") || titlePlainText.contains("\u2699 Plugin Configuration") || titlePlainText.contains("\ud83d\udcca Player Analytics") || titlePlainText.contains("Mining Stats") || titlePlainText.contains("Settings for Level") || titlePlainText.contains("\u26cf Ore Management") || titlePlainText.contains("\ud83e\udd16 ML Analysis") || titlePlainText.contains("\ud83d\udd14 Discord Webhook Settings")) {
            event.setCancelled(true);
            ItemStack clicked = event.getCurrentItem();
            if (clicked == null || !clicked.hasItemMeta() || !clicked.getItemMeta().hasDisplayName()) {
                return;
            }
            Component nameComponent = clicked.getItemMeta().displayName();
            String plainName = PlainTextComponentSerializer.plainText().serialize(nameComponent);
            Player player = (Player)event.getWhoClicked();
            player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.5f, 1.2f);
            if (titlePlainText.contains("DeepGuard-XRay Control Panel")) {
                if (plainName.contains("Player Analytics")) {
                    new PlayerStatsMainGUI(0).openInventory(player);
                } else if (plainName.contains("Suspicious Activity")) {
                    new SuspiciousPlayersGUI(0).openInventory(player);
                } else if (plainName.contains("Punishment System")) {
                    new PunishmentSettingsGUI(this.plugin.getConfigManager()).openInventory(player);
                } else if (plainName.contains("Ore Management")) {
                    new OreConfigGUI(this.plugin.getConfigManager()).openInventory(player);
                } else if (plainName.contains("Plugin Configuration")) {
                    if (player.hasPermission("deepguardx.gui_config")) {
                        new ConfigSettingsGUI(this.plugin.getConfigManager(), this.plugin).openInventory(player);
                    } else {
                        player.sendMessage(Component.text((String)"You don't have permission to access the config settings.").color((TextColor)NamedTextColor.RED));
                    }
                } else if (plainName.contains("ML Analysis")) {
                    if (player.hasPermission("deepguardx.gui_mltoggle")) {
                        new SuspiciousPlayersGUI(0).openInventory(player);
                    } else {
                        player.sendMessage(Component.text((String)"You don't have permission to access ML Analysis.").color((TextColor)NamedTextColor.RED));
                    }
                } else if (plainName.contains("Discord Webhook")) {
                    if (player.hasPermission("deepguardxray.webhook.config")) {
                        new WebhookSettingsGUI(this.plugin.getConfigManager(), this.plugin).openInventory(player);
                    } else {
                        player.sendMessage(Component.text((String)"You don't have permission to access webhook settings.").color((TextColor)NamedTextColor.RED));
                    }
                } else if (clicked.getType() == Material.NETHER_STAR || clicked.getType() == Material.BOOK || clicked.getType() == Material.REDSTONE || clicked.getType() == Material.COMPASS || clicked.getType() == Material.BARRIER || clicked.getType() == Material.OBSERVER || clicked.getType() == Material.LODESTONE) {
                    return;
                }
            } else if (titlePlainText.contains("\ud83d\udd14 Discord Webhook Settings")) {
                if (!player.hasPermission("deepguardxray.webhook.config")) {
                    player.sendMessage(Component.text((String)"You don't have permission to access webhook settings.").color((TextColor)NamedTextColor.RED));
                    player.closeInventory();
                    return;
                }
                WebhookSettingsGUI.handleClick(player, event.getRawSlot(), event.getInventory(), this.plugin.getConfigManager(), this.plugin);
            } else if (titlePlainText.contains("\u2696 Punishment System")) {
                if (clicked.getType() == Material.GREEN_WOOL || clicked.getType() == Material.RED_WOOL) {
                    int slot = event.getRawSlot();
                    int level = slot / 9 + 1;
                    boolean currentlyEnabled = this.plugin.getConfigManager().isPunishmentEnabled(level);
                    this.plugin.getConfigManager().setPunishmentEnabled(level, !currentlyEnabled);
                    if (currentlyEnabled) {
                        this.plugin.getPunishmentManager().onPunishmentLevelDisabled(level, player.getName());
                        player.sendMessage((Component)Component.text((String)("Punishment level " + level + " disabled. All affected players have been notified."), (TextColor)NamedTextColor.GREEN));
                        if (this.plugin.getConfigManager().isWebhookAlertEnabled("staff_actions")) {
                            this.plugin.getWebhookManager().sendStaffActionLog(player.getName(), "Disabled Punishment Level " + level, "All affected players");
                        }
                    } else {
                        player.sendMessage((Component)Component.text((String)("Punishment level " + level + " enabled."), (TextColor)NamedTextColor.GREEN));
                        this.plugin.getLogger().info("Admin " + player.getName() + " enabled punishment level " + level);
                        if (this.plugin.getConfigManager().isWebhookAlertEnabled("staff_actions")) {
                            this.plugin.getWebhookManager().sendStaffActionLog(player.getName(), "Enabled Punishment Level " + level, "Server-wide setting");
                        }
                    }
                    new PunishmentSettingsGUI(this.plugin.getConfigManager()).openInventory(player);
                } else if (clicked.getType() == Material.BELL || clicked.getType() == Material.GRAY_DYE && plainName.contains("Admin Alerts")) {
                    int slot = event.getRawSlot();
                    int level = slot / 9 + 1;
                    boolean current = this.plugin.getConfigManager().isPunishmentOptionEnabled(level, "admin_alert");
                    this.plugin.getConfigManager().setPunishmentOptionEnabled(level, "admin_alert", !current);
                    this.plugin.getLogger().info("Admin " + player.getName() + " " + (current ? "disabled" : "enabled") + " admin alerts for punishment level " + level);
                    if (this.plugin.getConfigManager().isWebhookAlertEnabled("staff_actions")) {
                        this.plugin.getWebhookManager().sendStaffActionLog(player.getName(), (current ? "Disabled" : "Enabled") + " Admin Alerts for Punishment Level " + level, "Configuration Change");
                    }
                    new PunishmentSettingsGUI(this.plugin.getConfigManager()).openInventory(player);
                } else if (clicked.getType() == Material.BOOK || clicked.getType() == Material.GRAY_DYE && plainName.contains("Warning Messages")) {
                    int slot = event.getRawSlot();
                    int level = slot / 9 + 1;
                    boolean current = this.plugin.getConfigManager().isPunishmentOptionEnabled(level, "warning_message");
                    this.plugin.getConfigManager().setPunishmentOptionEnabled(level, "warning_message", !current);
                    if (this.plugin.getConfigManager().isWebhookAlertEnabled("staff_actions")) {
                        this.plugin.getWebhookManager().sendStaffActionLog(player.getName(), (current ? "Disabled" : "Enabled") + " Warning Messages for Punishment Level " + level, "Configuration Change");
                    }
                    new PunishmentSettingsGUI(this.plugin.getConfigManager()).openInventory(player);
                } else if (plainName.contains("Advanced settings")) {
                    int slot = event.getRawSlot();
                    int level = slot / 9 + 1;
                    new LevelPunishmentSettingsGUI(this.plugin.getConfigManager(), level).openInventory(player);
                } else if (!plainName.contains("Icon Guide") && plainName.contains("Back to")) {
                    new StaffMenuGUI().openInventory(player);
                }
            } else if (titlePlainText.contains("Settings for Level")) {
                int level = Integer.parseInt(titlePlainText.substring(titlePlainText.indexOf("Level ") + 6, titlePlainText.indexOf(" Punishment")));
                if (plainName.contains("Back to")) {
                    new PunishmentSettingsGUI(this.plugin.getConfigManager()).openInventory(player);
                } else {
                    LevelPunishmentSettingsGUI.handleClick(player, event.getRawSlot(), level, this.plugin.getConfigManager());
                }
            } else if (titlePlainText.contains("\ud83d\udcca Player Analytics")) {
                if (plainName.contains("Back to")) {
                    new StaffMenuGUI().openInventory(player);
                }
            } else if (titlePlainText.contains("Mining Stats")) {
                if (plainName.contains("Back to")) {
                    new PlayerStatsMainGUI(0).openInventory(player);
                }
            } else if (titlePlainText.contains("\u26cf Ore Management")) {
                if (plainName.contains("Back to")) {
                    new StaffMenuGUI().openInventory(player);
                    return;
                }
                Material oreMaterial = clicked.getType();
                if (this.plugin.getConfigManager().getNaturalOres().contains(oreMaterial)) {
                    this.plugin.getConfigManager().getNaturalOres().remove(oreMaterial);
                    this.plugin.getConfig().set("ores.natural", this.plugin.getConfigManager().getNaturalOres().stream().map(Enum::name).toList());
                    this.plugin.saveConfig();
                    player.sendMessage(Component.text((String)(oreMaterial.name() + " removed from natural ores.")).color((TextColor)NamedTextColor.YELLOW));
                } else {
                    this.plugin.getConfigManager().getNaturalOres().add(oreMaterial);
                    this.plugin.getConfig().set("ores.natural", this.plugin.getConfigManager().getNaturalOres().stream().map(Enum::name).toList());
                    this.plugin.saveConfig();
                    player.sendMessage(Component.text((String)(oreMaterial.name() + " added to natural ores.")).color((TextColor)NamedTextColor.GREEN));
                }
                new OreConfigGUI(this.plugin.getConfigManager()).openInventory(player);
            } else if (titlePlainText.contains("\ud83d\udd0d Suspicious Activity")) {
                if (event.getRawSlot() == 47) {
                    if (!player.hasPermission("deepguardx.gui_mltoggle") && !player.isOp()) {
                        player.sendMessage(Component.text((String)"You do not have permission to toggle ML analysis.").color((TextColor)NamedTextColor.RED));
                        return;
                    }
                    boolean currentState = plainName.contains("ON");
                    MiningPatternAnalyzer.setMLAnalysisEnabled(!currentState);
                    this.plugin.getConfig().set("ml.enabled", (Object)(!currentState ? 1 : 0));
                    this.plugin.saveConfig();
                    player.sendMessage(((TextComponent)Component.text((String)"ML Analysis is now ").color((TextColor)NamedTextColor.GOLD)).append(Component.text((String)(!currentState ? "ENABLED" : "DISABLED")).color((TextColor)(!currentState ? NamedTextColor.GREEN : NamedTextColor.RED))));
                    if (currentState) {
                        player.sendMessage(Component.text((String)"All mining pattern analysis has been disabled for performance.").color((TextColor)NamedTextColor.YELLOW));
                    } else {
                        player.sendMessage(Component.text((String)"Mining pattern analysis is now running.").color((TextColor)NamedTextColor.YELLOW));
                    }
                    new SuspiciousPlayersGUI(0).openInventory(player);
                    return;
                }
                if (event.getRawSlot() < 36 && clicked != null && clicked.getType() == Material.PLAYER_HEAD) {
                    SuspiciousPlayersGUI gui = new SuspiciousPlayersGUI(0);
                    UUID playerId = gui.getPlayerSlots().get(event.getRawSlot());
                    if (playerId != null) {
                        Player targetPlayer = Bukkit.getPlayer((UUID)playerId);
                        if (targetPlayer != null) {
                            if (!MiningPatternAnalyzer.isMLAnalysisEnabled()) {
                                MLAnalysisGUI.openDisabledMLAnalysisGUI(player, targetPlayer);
                                return;
                            }
                            Map<String, Object> analysis = MiningPatternAnalyzer.getDetailedAnalysis(playerId);
                            if (!analysis.containsKey("error")) {
                                if (analysis.containsKey("mlDisabled")) {
                                    MLAnalysisGUI.openDisabledMLAnalysisGUI(player, targetPlayer);
                                } else {
                                    new MLAnalysisGUI(targetPlayer, analysis).openInventory(player);
                                }
                            } else {
                                player.sendMessage(Component.text((String)"Not enough mining data for ML analysis").color((TextColor)NamedTextColor.RED));
                            }
                        } else {
                            player.sendMessage(Component.text((String)"Player is offline, ML analysis unavailable").color((TextColor)NamedTextColor.RED));
                        }
                    }
                } else {
                    SuspiciousPlayersGUI.handleClick(player, event.getRawSlot(), event.getInventory());
                }
            } else if (titlePlainText.contains("\ud83e\udd16 ML Analysis")) {
                String playerName = "";
                if (titlePlainText.contains(":")) {
                    playerName = titlePlainText.substring(titlePlainText.indexOf(":") + 1).trim();
                }
                Player targetPlayer = Bukkit.getPlayer((String)playerName);
                if (event.getInventory().getSize() == 27 && event.getInventory().getItem(13) != null && event.getInventory().getItem(13).getType() == Material.BARRIER) {
                    if (event.getRawSlot() == 18) {
                        new SuspiciousPlayersGUI(0).openInventory(player);
                    }
                } else if (targetPlayer != null) {
                    MLAnalysisGUI.handleClick(player, event.getRawSlot(), targetPlayer);
                } else {
                    player.sendMessage(Component.text((String)"Player no longer online").color((TextColor)NamedTextColor.RED));
                    player.closeInventory();
                }
            } else if (titlePlainText.contains("\u2699 Plugin Configuration")) {
                if (!player.hasPermission("deepguardx.gui_config")) {
                    player.sendMessage(Component.text((String)"You don't have permission to access config settings.").color((TextColor)NamedTextColor.RED));
                    player.closeInventory();
                    return;
                }
                ConfigSettingsGUI.handleClick(player, event.getRawSlot(), event.getInventory(), event.getClick(), this.plugin.getConfigManager(), this.plugin);
            }
        }
    }

    public void registerMLAnalysisTarget(UUID staffId, Player targetPlayer) {
        this.mlAnalysisTargets.put(staffId, targetPlayer);
    }

    public void unregisterMLAnalysisTarget(UUID staffId) {
        this.mlAnalysisTargets.remove(staffId);
    }
}

