/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray;

import java.io.File;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.myplugin.deepGuardXray.alerts.StaffAlertManager;
import org.myplugin.deepGuardXray.commands.AntiXrayCommand;
import org.myplugin.deepGuardXray.config.ConfigManager;
import org.myplugin.deepGuardXray.gui.GuiListener;
import org.myplugin.deepGuardXray.gui.PlayerStatsGuiListener;
import org.myplugin.deepGuardXray.gui.StaffMenuGUI;
import org.myplugin.deepGuardXray.libs.bstats.bukkit.Metrics;
import org.myplugin.deepGuardXray.listeners.BlockListener;
import org.myplugin.deepGuardXray.listeners.ChatListener;
import org.myplugin.deepGuardXray.listeners.UpdateListener;
import org.myplugin.deepGuardXray.managers.DecoyManager;
import org.myplugin.deepGuardXray.managers.PunishmentManager;
import org.myplugin.deepGuardXray.managers.StatsManager;
import org.myplugin.deepGuardXray.managers.WebhookManager;
import org.myplugin.deepGuardXray.punishments.handlers.Paranoia.ParanoiaHandler;
import org.myplugin.deepGuardXray.utils.ChatInputHandler;
import org.myplugin.deepGuardXray.utils.MiningPatternAnalyzer;
import org.myplugin.deepGuardXray.utils.UpdateApplier;
import org.myplugin.deepGuardXray.utils.UpdateChecker;

public class deepGuardXray
extends JavaPlugin {
    private static deepGuardXray instance;
    private ConfigManager configManager;
    private StaffAlertManager staffAlertManager;
    private DecoyManager decoyManager;
    private PunishmentManager punishmentManager;
    private UpdateChecker updateChecker;
    private UpdateApplier updateApplier;
    private ParanoiaHandler paranoiaHandler;
    private ChatInputHandler chatInputHandler;

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        this.updateApplier = new UpdateApplier(this);
        this.updateApplier.performPendingCleanup();
        boolean updatePending = this.updateApplier.checkForPendingUpdate();
        int resourceId = 122967;
        this.updateChecker = new UpdateChecker(this, resourceId);
        int pluginId = 25174;
        Metrics metrics = new Metrics(this, pluginId);
        this.getLogger().info("bStats metrics enabled!");
        if (this.getConfig().getBoolean("check-for-updates", true)) {
            this.getServer().getPluginManager().registerEvents((Listener)new UpdateListener(this, this.updateChecker), (Plugin)this);
        }
        this.configManager = new ConfigManager(this);
        this.configManager.setupDefaultPunishmentOptions();
        this.getConfigManager().initializeWebhookSettings();
        this.chatInputHandler = new ChatInputHandler(this);
        WebhookManager.initialize(this, this.getConfigManager());
        this.staffAlertManager = new StaffAlertManager(this, this.configManager);
        this.decoyManager = new DecoyManager(this, this.configManager);
        this.punishmentManager = new PunishmentManager(this.configManager, this);
        this.getServer().getPluginManager().registerEvents((Listener)new ChatListener(this.punishmentManager, this), (Plugin)this);
        StaffMenuGUI.setPlugin(this);
        StaffMenuGUI mainMenuGUI = new StaffMenuGUI();
        this.paranoiaHandler = new ParanoiaHandler(this, this.punishmentManager, this.configManager);
        MiningPatternAnalyzer.initialize(this);
        File statsFile = new File(this.getDataFolder(), "stats.yml");
        StatsManager.loadStats(statsFile);
        this.getServer().getPluginManager().registerEvents((Listener)new BlockListener(this.configManager, this.staffAlertManager, this.decoyManager, this.punishmentManager, this.paranoiaHandler), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new GuiListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerStatsGuiListener(), (Plugin)this);
        this.getCommand("deepguard").setExecutor((CommandExecutor)new AntiXrayCommand(this, this.updateChecker));
        this.getLogger().info("DeepGuard-XRay Plugin enabled with config settings!");
        if (updatePending) {
            this.getLogger().info("=================================================");
            this.getLogger().info(" DeepGuard-XRay will be automatically updated when the server shuts down!");
            this.getLogger().info("=================================================");
        }
    }

    public void saveConfig() {
        super.saveConfig();
        try {
            File configFile = new File(this.getDataFolder(), "config.yml");
            if (this.getConfigManager().isDebugEnabled()) {
                this.getLogger().info("Forcefully saving config to " + configFile.getAbsolutePath());
            }
            if (!configFile.exists()) {
                configFile.getParentFile().mkdirs();
                this.saveResource("config.yml", false);
            }
        }
        catch (Exception e) {
            this.getLogger().warning("Error ensuring config file exists: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void onDisable() {
        File statsFile = new File(this.getDataFolder(), "stats.yml");
        StatsManager.saveStats(statsFile);
        if (this.updateApplier != null && this.updateApplier.isUpdatePending()) {
            this.getLogger().info("Applying DeepGuard-XRay update during shutdown...");
            this.updateApplier.applyUpdateOnShutdown();
        }
        if (this.paranoiaHandler != null) {
            this.paranoiaHandler.cleanup();
        }
    }

    public ChatInputHandler getChatInputHandler() {
        return this.chatInputHandler;
    }

    public WebhookManager getWebhookManager() {
        return WebhookManager.getInstance();
    }

    public static deepGuardXray getInstance() {
        return instance;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public StaffAlertManager getStaffAlertManager() {
        return this.staffAlertManager;
    }

    public void setStaffAlertManager(StaffAlertManager staffAlertManager) {
        this.staffAlertManager = staffAlertManager;
    }

    public DecoyManager getDecoyManager() {
        return this.decoyManager;
    }

    public void setDecoyManager(DecoyManager decoyManager) {
        this.decoyManager = decoyManager;
    }

    public PunishmentManager getPunishmentManager() {
        return this.punishmentManager;
    }

    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }

    public UpdateApplier getUpdateApplier() {
        return this.updateApplier;
    }

    public boolean isAutoUpdateEnabled() {
        return this.getConfig().getBoolean("auto-updates.enabled", true);
    }
}

