/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.config;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.plugin.java.JavaPlugin;
import org.myplugin.deepGuardXray.utils.WebhookSecurity;

public class ConfigManager {
    private final JavaPlugin plugin;
    private int oreThreshold;
    private long timeWindowTicks;
    private double decoyDistance;
    private double decoyFieldOffset;
    private double maxDecayDistance;
    private long decoyRevertDelay;
    private boolean warnOnDecoy;
    private boolean decoyEnabled;
    private boolean decoyRequireBuried;
    private int decoySearchRadius;
    private int buriedThreshold;
    private boolean debugEnabled;
    private boolean staffOreAlerts;
    private long staffOreResetTime;
    private boolean staffAlertEnabled;
    private Set<Material> naturalOres = new HashSet<Material>();

    public ConfigManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.loadConfiguration();
    }

    private void loadConfiguration() {
        this.oreThreshold = this.plugin.getConfig().getInt("decoy.oreThreshold", 8);
        this.timeWindowTicks = this.plugin.getConfig().getLong("decoy.timeWindowTicks", 3800L);
        this.decoyDistance = this.plugin.getConfig().getDouble("decoy.distance", 2.0);
        this.decoyFieldOffset = this.plugin.getConfig().getDouble("decoy.fieldOffset", 0.5);
        this.maxDecayDistance = this.plugin.getConfig().getDouble("decoy.maxDistance", 10.0);
        this.decoyRevertDelay = this.plugin.getConfig().getLong("decoy.revertDelay", 1200L);
        this.warnOnDecoy = this.plugin.getConfig().getBoolean("decoy.warnOnDecoy", true);
        this.decoyEnabled = this.plugin.getConfig().getBoolean("decoy.enabled", true);
        this.decoyRequireBuried = this.plugin.getConfig().getBoolean("decoy.requireBuried", true);
        this.decoySearchRadius = this.plugin.getConfig().getInt("decoy.searchRadius", 3);
        this.buriedThreshold = this.plugin.getConfig().getInt("decoy.buriedThreshold", 4);
        this.debugEnabled = this.plugin.getConfig().getBoolean("debug.enabled", false);
        this.staffOreAlerts = this.plugin.getConfig().getBoolean("staff.oreAlerts", true);
        this.staffOreResetTime = this.plugin.getConfig().getLong("staff.oreResetTime", 36000L);
        this.staffAlertEnabled = this.plugin.getConfig().getBoolean("staff.alertEnabled", true);
        List oreList = this.plugin.getConfig().getStringList("ores.natural");
        for (String oreName : oreList) {
            try {
                Material mat = Material.valueOf((String)oreName.toUpperCase());
                this.naturalOres.add(mat);
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Invalid ore in config: " + oreName);
            }
        }
    }

    public boolean isPunishmentEnabled(int level) {
        return this.plugin.getConfig().getBoolean("punishment.enabled." + level, false);
    }

    public void setPunishmentEnabled(int level, boolean enabled) {
        this.plugin.getConfig().set("punishment.enabled." + level, (Object)enabled);
        this.plugin.saveConfig();
    }

    public boolean isPunishmentOptionEnabled(int level, String option) {
        String path = "punishment.levels." + level + ".options." + option;
        return this.plugin.getConfig().getBoolean(path, false);
    }

    public void setPunishmentOptionEnabled(int level, String option, boolean enabled) {
        String path = "punishment.levels." + level + ".options." + option;
        this.plugin.getConfig().set(path, (Object)enabled);
        this.plugin.saveConfig();
    }

    public void setupDefaultPunishmentOptions() {
        for (int i = 1; i <= 6; ++i) {
            if (!this.plugin.getConfig().isSet("punishment.enabled." + i)) {
                this.plugin.getConfig().set("punishment.enabled." + i, (Object)false);
            }
            this.setDefaultOption(i, "admin_alert", true);
            this.setDefaultOption(i, "warning_message", i <= 3);
        }
        this.setDefaultOption(1, "mining_fatigue", true);
        this.setDefaultOption(1, "fake_diamonds", false);
        this.setDefaultOption(1, "admin_alert", true);
        this.setDefaultOption(1, "heavy_pickaxe", false);
        this.setDefaultOption(2, "fake_ore_veins", true);
        this.setDefaultOption(2, "inventory_drop", false);
        this.setDefaultOption(2, "xray_vision_blur", true);
        this.setDefaultOption(2, "tool_damage", false);
        this.setDefaultOption(2, "paranoia_mode", false);
        this.setDefaultOption(3, "temporary_kick", true);
        this.setDefaultOption(3, "mining_license_suspension", false);
        this.setDefaultOption(3, "resource_tax", false);
        this.setDefaultOption(3, "decoy_attraction", true);
        this.setDefaultOption(3, "fools_gold", false);
        this.setDefaultOption(4, "extended_ban", true);
        this.setDefaultOption(4, "mining_reputation", false);
        this.setDefaultOption(4, "restricted_areas", false);
        this.setDefaultOption(4, "cursed_pickaxe", false);
        this.setDefaultOption(5, "long_term_ban", true);
        this.setDefaultOption(5, "public_notification", false);
        this.setDefaultOption(5, "permanent_mining_debuff", false);
        this.setDefaultOption(5, "staff_review", false);
        this.setDefaultOption(5, "stone_vision", false);
        this.setDefaultOption(6, "permanent_ban", true);
        this.setDefaultOption(6, "ip_tracking", false);
        this.setDefaultOption(6, "security_report", true);
        this.setDefaultOption(6, "tnt_execution", false);
        this.plugin.saveConfig();
    }

    private void setDefaultOption(int level, String option, boolean defaultValue) {
        String path = "punishment.levels." + level + ".options." + option;
        if (!this.plugin.getConfig().isSet(path)) {
            this.plugin.getConfig().set(path, (Object)defaultValue);
        }
    }

    public void reloadConfig() {
        this.plugin.reloadConfig();
        this.loadConfiguration();
    }

    public String getWebhookUrl() {
        String storedUrl = this.plugin.getConfig().getString("webhook.url", "");
        if (storedUrl == null || storedUrl.isEmpty()) {
            return "";
        }
        if (storedUrl.startsWith("https://")) {
            return storedUrl;
        }
        try {
            return WebhookSecurity.deobfuscateWebhookUrl(storedUrl);
        }
        catch (Exception e) {
            return storedUrl;
        }
    }

    public void setWebhookUrl(String url) {
        this.plugin.getConfig().set("webhook.url", (Object)url);
        this.plugin.saveConfig();
    }

    public boolean isWebhookAlertEnabled(String alertType) {
        return this.plugin.getConfig().getBoolean("webhook.alerts." + alertType, false);
    }

    public void setWebhookAlertEnabled(String alertType, boolean enabled) {
        this.plugin.getConfig().set("webhook.alerts." + alertType, (Object)enabled);
        this.plugin.saveConfig();
    }

    public void initializeWebhookSettings() {
        if (!this.plugin.getConfig().contains("webhook.url")) {
            this.plugin.getConfig().set("webhook.url", (Object)"");
        }
        if (!this.plugin.getConfig().contains("webhook.alerts.xray_detection")) {
            this.plugin.getConfig().set("webhook.alerts.xray_detection", (Object)true);
        }
        if (!this.plugin.getConfig().contains("webhook.alerts.suspicious_mining")) {
            this.plugin.getConfig().set("webhook.alerts.suspicious_mining", (Object)true);
        }
        if (!this.plugin.getConfig().contains("webhook.alerts.punishment_applied")) {
            this.plugin.getConfig().set("webhook.alerts.punishment_applied", (Object)true);
        }
        if (!this.plugin.getConfig().contains("webhook.alerts.staff_actions")) {
            this.plugin.getConfig().set("webhook.alerts.staff_actions", (Object)false);
        }
        this.plugin.saveConfig();
    }

    public int getOreThreshold() {
        return this.oreThreshold;
    }

    public long getTimeWindowTicks() {
        return this.timeWindowTicks;
    }

    public double getDecoyDistance() {
        return this.decoyDistance;
    }

    public double getDecoyFieldOffset() {
        return this.decoyFieldOffset;
    }

    public double getMaxDecayDistance() {
        return this.maxDecayDistance;
    }

    public long getDecoyRevertDelay() {
        return this.decoyRevertDelay;
    }

    public boolean isWarnOnDecoy() {
        return this.warnOnDecoy;
    }

    public boolean isDecoyEnabled() {
        return this.decoyEnabled;
    }

    public boolean isDecoyRequireBuried() {
        return this.decoyRequireBuried;
    }

    public int getDecoySearchRadius() {
        return this.decoySearchRadius;
    }

    public int getBuriedThreshold() {
        return this.buriedThreshold;
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public boolean isStaffOreAlerts() {
        return this.staffOreAlerts;
    }

    public long getStaffOreResetTime() {
        return this.staffOreResetTime;
    }

    public boolean isStaffAlertEnabled() {
        return this.staffAlertEnabled;
    }

    public Set<Material> getNaturalOres() {
        return this.naturalOres;
    }
}

