/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.commands.subcommands;

import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.myplugin.deepGuardXray.deepGuardXray;
import org.myplugin.deepGuardXray.gui.subgui.MLAnalysisGUI;
import org.myplugin.deepGuardXray.gui.subgui.SuspiciousPlayersGUI;
import org.myplugin.deepGuardXray.utils.MiningPatternAnalyzer;

public class MLCommand {
    private final deepGuardXray plugin;

    public MLCommand(deepGuardXray plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (!(sender instanceof Player)) {
            sender.sendMessage(Component.text((String)"This command can only be used by players.").color((TextColor)NamedTextColor.RED));
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            player.sendMessage(Component.text((String)"ML command usage:").color((TextColor)NamedTextColor.GREEN));
            player.sendMessage(Component.text((String)"/deepguard ml flag <player> <true|false> - Mark player as cheating (true) or legitimate (false)").color((TextColor)NamedTextColor.GREEN));
            player.sendMessage(Component.text((String)"/deepguard ml analyze <player> - Show detailed analysis for a player").color((TextColor)NamedTextColor.GREEN));
            player.sendMessage(Component.text((String)"/deepguard ml suspicious - Show suspicious players GUI").color((TextColor)NamedTextColor.GREEN));
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "flag": {
                return this.handleFlagCommand(player, args);
            }
            case "analyze": {
                return this.handleAnalyzeCommand(player, args);
            }
            case "suspicious": {
                return this.handleSuspiciousListCommand(player);
            }
        }
        player.sendMessage(Component.text((String)("Unknown ML subcommand: " + subCommand)).color((TextColor)NamedTextColor.RED));
        return true;
    }

    private boolean handleFlagCommand(Player sender, String[] args) {
        boolean isCheating;
        if (args.length < 3) {
            sender.sendMessage(Component.text((String)"Usage: /deepguard ml flag <player> <true|false>").color((TextColor)NamedTextColor.RED));
            return true;
        }
        String targetName = args[1];
        Player targetPlayer = Bukkit.getPlayer((String)targetName);
        if (targetPlayer == null) {
            sender.sendMessage(Component.text((String)("Player " + targetName + " not found or not online.")).color((TextColor)NamedTextColor.RED));
            return true;
        }
        if (args[2].equalsIgnoreCase("true")) {
            isCheating = true;
        } else if (args[2].equalsIgnoreCase("false")) {
            isCheating = false;
        } else {
            sender.sendMessage(Component.text((String)"Flag value must be 'true' or 'false'.").color((TextColor)NamedTextColor.RED));
            return true;
        }
        MiningPatternAnalyzer.flagPlayerForLearning(targetPlayer.getUniqueId(), isCheating);
        Component message = ((TextComponent)((TextComponent)Component.text((String)("Player " + targetName + " has been flagged as ")).color((TextColor)NamedTextColor.GREEN)).append(Component.text((String)(isCheating ? "cheating" : "legitimate")).color((TextColor)(isCheating ? NamedTextColor.RED : NamedTextColor.GREEN)))).append(Component.text((String)" for ML training.").color((TextColor)NamedTextColor.GREEN));
        sender.sendMessage(message);
        return true;
    }

    private boolean handleAnalyzeCommand(Player sender, String[] args) {
        if (args.length < 2) {
            sender.sendMessage(Component.text((String)"Usage: /deepguard ml analyze <player>").color((TextColor)NamedTextColor.RED));
            return true;
        }
        String targetName = args[1];
        Player targetPlayer = Bukkit.getPlayer((String)targetName);
        if (targetPlayer == null) {
            sender.sendMessage(Component.text((String)("Player " + targetName + " not found or not online.")).color((TextColor)NamedTextColor.RED));
            return true;
        }
        Map<String, Object> analysis = MiningPatternAnalyzer.getDetailedAnalysis(targetPlayer.getUniqueId());
        if (analysis.containsKey("error")) {
            sender.sendMessage(Component.text((String)("Error: " + String.valueOf(analysis.get("error")))).color((TextColor)NamedTextColor.RED));
            return true;
        }
        new MLAnalysisGUI(targetPlayer, analysis).openInventory(sender);
        return true;
    }

    private boolean handleSuspiciousListCommand(Player sender) {
        new SuspiciousPlayersGUI(0).openInventory(sender);
        return true;
    }
}

