/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.myplugin.deepGuardXray.commands.subcommands.AlertCommand;
import org.myplugin.deepGuardXray.commands.subcommands.DebugCommand;
import org.myplugin.deepGuardXray.commands.subcommands.HighlightDecoyCommand;
import org.myplugin.deepGuardXray.commands.subcommands.MLCommand;
import org.myplugin.deepGuardXray.commands.subcommands.ModifySuspiciousCommand;
import org.myplugin.deepGuardXray.commands.subcommands.PunishCommand;
import org.myplugin.deepGuardXray.commands.subcommands.ReloadCommand;
import org.myplugin.deepGuardXray.commands.subcommands.StaffGuiCommand;
import org.myplugin.deepGuardXray.commands.subcommands.TeleportCommand;
import org.myplugin.deepGuardXray.commands.subcommands.UpdateCommand;
import org.myplugin.deepGuardXray.deepGuardXray;
import org.myplugin.deepGuardXray.utils.UpdateChecker;

public class AntiXrayCommand
implements CommandExecutor,
TabCompleter {
    private final deepGuardXray plugin;
    private final TeleportCommand teleportCommand;
    private final AlertCommand alertCommand;
    private final ReloadCommand reloadCommand;
    private final DebugCommand debugCommand;
    private final StaffGuiCommand staffguiCommand;
    private final ModifySuspiciousCommand pointsCommand;
    private final MLCommand mlCommand;
    private final HighlightDecoyCommand highlightCommand;
    private final PunishCommand punishCommand;
    private final UpdateCommand updateCommand;

    public AntiXrayCommand(deepGuardXray plugin, UpdateChecker updateChecker) {
        this.plugin = plugin;
        this.teleportCommand = new TeleportCommand();
        this.alertCommand = new AlertCommand(plugin);
        this.reloadCommand = new ReloadCommand(plugin);
        this.debugCommand = new DebugCommand(plugin);
        this.staffguiCommand = new StaffGuiCommand();
        this.pointsCommand = new ModifySuspiciousCommand(plugin);
        this.mlCommand = new MLCommand(plugin);
        this.highlightCommand = new HighlightDecoyCommand(plugin);
        this.punishCommand = new PunishCommand(plugin);
        this.updateCommand = new UpdateCommand(plugin, updateChecker);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("This command can only be used by players.");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            ArrayList<String> available = new ArrayList<String>();
            if (player.hasPermission("deepguardx.teleport")) {
                available.add("teleport <x> <y> <z>");
            }
            if (player.hasPermission("deepguardx.togglealert")) {
                available.add("togglealert");
            }
            if (player.hasPermission("deepguardx.reload")) {
                available.add("reload");
            }
            if (player.hasPermission("deepguardx.debug")) {
                available.add("debug <true/false>");
            }
            if (player.hasPermission("deepguardx.gui")) {
                available.add("staff GUI menu");
            }
            if (player.hasPermission("deepguardx.punish")) {
                available.add("punish <set|remove|check> <player> [level]");
            }
            if (player.hasPermission("deepguardx.modify")) {
                available.add("points <add|remove|set|check> <player> [amount]");
            }
            if (player.hasPermission("deepguardx.ml")) {
                available.add("ML commands <flag|analyze|suspicious>");
            }
            if (player.hasPermission("deepguardx.highlight")) {
                available.add("highlight [radius|off|nearest]");
            }
            if (player.hasPermission("deepguardx.autoupdate")) {
                available.add("update <check|auto>");
            }
            if (available.isEmpty()) {
                String version = this.plugin.getDescription().getVersion();
                player.sendMessage(((TextComponent)Component.text((String)"DeepGuard-XRay Plugin ", (TextColor)NamedTextColor.GREEN, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}).append((Component)Component.text((String)("v" + version), (TextColor)NamedTextColor.AQUA, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)("Running version " + version)))));
            } else {
                player.sendMessage(((TextComponent)((TextComponent)Component.text((String)"\u25b6 ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"DeepGuard-XRay ", (TextColor)NamedTextColor.GREEN, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.text((String)"Commands", (TextColor)NamedTextColor.YELLOW))).append((Component)Component.text((String)" \u25c0", (TextColor)NamedTextColor.GOLD)));
                for (String cmd : available) {
                    String commandText = "/" + label + " " + cmd;
                    String[] parts = cmd.split(" ", 2);
                    String baseCmd = parts[0];
                    String cmdArgs = parts.length > 1 ? " " + parts[1] : "";
                    Component message = ((TextComponent)((TextComponent)Component.text((String)"  \u2022 ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)("/" + label + " "), (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)baseCmd, (TextColor)NamedTextColor.GREEN, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.text((String)cmdArgs, (TextColor)NamedTextColor.YELLOW));
                    message = !cmd.contains("[") && !cmd.contains("<") ? message.clickEvent(ClickEvent.runCommand((String)commandText)).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)("Click to execute: " + commandText)))) : message.clickEvent(ClickEvent.suggestCommand((String)("/" + label + " " + baseCmd + " "))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)("Click to suggest: /" + label + " " + baseCmd))));
                    player.sendMessage(message);
                }
            }
            return true;
        }
        String subCommand = args[0].toLowerCase();
        String[] subArgs = Arrays.copyOfRange(args, 1, args.length);
        switch (subCommand) {
            case "teleport": {
                if (!player.hasPermission("deepguardx.teleport")) {
                    player.sendMessage(((TextComponent)Component.text((String)"\u26a0 ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"Permission Denied: ", (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.text((String)"You don't have permission to use teleport.", (TextColor)NamedTextColor.RED)));
                    return true;
                }
                return this.teleportCommand.onCommand(sender, command, label, subArgs);
            }
            case "togglealert": {
                if (!player.hasPermission("deepguardx.togglealert")) {
                    player.sendMessage(((TextComponent)Component.text((String)"\u26a0 ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"Permission Denied: ", (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.text((String)"You don't have permission to toggle alerts.", (TextColor)NamedTextColor.RED)));
                    return true;
                }
                return this.alertCommand.onCommand(sender, command, label, subArgs);
            }
            case "reload": {
                if (!player.hasPermission("deepguardx.reload")) {
                    player.sendMessage(((TextComponent)Component.text((String)"\u26a0 ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"Permission Denied: ", (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.text((String)"You don't have permission to reload the plugin.", (TextColor)NamedTextColor.RED)));
                    return true;
                }
                return this.reloadCommand.onCommand(sender, command, label, subArgs);
            }
            case "debug": {
                if (!player.hasPermission("deepguardx.debug")) {
                    player.sendMessage(((TextComponent)Component.text((String)"\u26a0 ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"Permission Denied: ", (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.text((String)"You don't have permission to change debug settings.", (TextColor)NamedTextColor.RED)));
                    return true;
                }
                return this.debugCommand.onCommand(sender, command, label, subArgs);
            }
            case "staff": {
                if (!player.hasPermission("deepguardx.gui")) {
                    player.sendMessage(((TextComponent)Component.text((String)"\u26a0 ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"Permission Denied: ", (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.text((String)"You don't have permission to access Staff GUI settings.", (TextColor)NamedTextColor.RED)));
                    return true;
                }
                return this.staffguiCommand.onCommand(sender, command, label, subArgs);
            }
            case "punish": {
                if (!player.hasPermission("deepguardx.punish")) {
                    player.sendMessage(((TextComponent)Component.text((String)"\u26a0 ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"Permission Denied: ", (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.text((String)"You don't have permission to manage punishments.", (TextColor)NamedTextColor.RED)));
                    return true;
                }
                return this.punishCommand.onCommand(sender, command, label, subArgs);
            }
            case "points": {
                if (!player.hasPermission("deepguardx.modify")) {
                    player.sendMessage(((TextComponent)Component.text((String)"\u26a0 ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"Permission Denied: ", (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.text((String)"You don't have permission to modify player points.", (TextColor)NamedTextColor.RED)));
                    return true;
                }
                return this.pointsCommand.onCommand(sender, command, label, subArgs);
            }
            case "ml": {
                if (!player.hasPermission("deepguardx.ml")) {
                    player.sendMessage(((TextComponent)Component.text((String)"\u26a0 ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"Permission Denied: ", (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.text((String)"You don't have permission to use ML commands.", (TextColor)NamedTextColor.RED)));
                    return true;
                }
                return this.mlCommand.onCommand(sender, command, label, subArgs);
            }
            case "highlight": {
                if (!player.hasPermission("deepguardx.highlight")) {
                    player.sendMessage(((TextComponent)Component.text((String)"\u26a0 ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"Permission Denied: ", (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.text((String)"You don't have permission to highlight decoy veins.", (TextColor)NamedTextColor.RED)));
                    return true;
                }
                return this.highlightCommand.onCommand(sender, command, label, subArgs);
            }
            case "update": {
                if (!player.hasPermission("deepguardx.autoupdate")) {
                    player.sendMessage(((TextComponent)Component.text((String)"\u26a0 ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"Permission Denied: ", (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.text((String)"You don't have permission to auto-update the plugin.", (TextColor)NamedTextColor.RED)));
                    return true;
                }
                return this.updateCommand.onCommand(sender, command, label, subArgs);
            }
        }
        player.sendMessage(((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)"\u274c ", (TextColor)NamedTextColor.RED).append((Component)Component.text((String)"Unknown command: ", (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)subCommand, (TextColor)NamedTextColor.GOLD))).append((Component)Component.text((String)". Use ", (TextColor)NamedTextColor.RED))).append(((TextComponent)Component.text((String)("/" + label), (TextColor)NamedTextColor.YELLOW, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}).clickEvent(ClickEvent.runCommand((String)("/" + label)))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)("Click to run: /" + label)))))).append((Component)Component.text((String)" for help.", (TextColor)NamedTextColor.RED)));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        Object partial;
        ArrayList<String> suggestions = new ArrayList<String>();
        if (!(sender instanceof Player)) {
            return suggestions;
        }
        if (args.length == 1) {
            partial = args[0].toLowerCase();
            if (sender.hasPermission("deepguardx.teleport") && "teleport".startsWith((String)partial)) {
                suggestions.add("teleport");
            }
            if (sender.hasPermission("deepguardx.togglealert") && "togglealert".startsWith((String)partial)) {
                suggestions.add("togglealert");
            }
            if (sender.hasPermission("deepguardx.reload") && "reload".startsWith((String)partial)) {
                suggestions.add("reload");
            }
            if (sender.hasPermission("deepguardx.debug") && "debug".startsWith((String)partial)) {
                suggestions.add("debug");
            }
            if (sender.hasPermission("deepguardx.gui") && "staff".startsWith((String)partial)) {
                suggestions.add("staff");
            }
            if (sender.hasPermission("deepguardx.punish") && "punish".startsWith((String)partial)) {
                suggestions.add("punish");
            }
            if (sender.hasPermission("deepguardx.modify") && "points".startsWith((String)partial)) {
                suggestions.add("points");
            }
            if (sender.hasPermission("deepguardx.ml") && "ml".startsWith((String)partial)) {
                suggestions.add("ml");
            }
            if (sender.hasPermission("deepguardx.highlight") && "highlight".startsWith((String)partial)) {
                suggestions.add("highlight");
            }
            if (sender.hasPermission("deepguardx.autoupdate") && "update".startsWith((String)partial)) {
                suggestions.add("update");
            }
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("update") && sender.hasPermission("deepguardx.autoupdate")) {
            partial = args[1].toLowerCase();
            if ("check".startsWith((String)partial)) {
                suggestions.add("check");
            }
            if ("auto".startsWith((String)partial)) {
                suggestions.add("auto");
            }
            if ("apply".startsWith((String)partial)) {
                suggestions.add("apply");
            }
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("punish") && sender.hasPermission("deepguardx.punish")) {
            partial = args[1].toLowerCase();
            if ("set".startsWith((String)partial)) {
                suggestions.add("set");
            }
            if ("remove".startsWith((String)partial)) {
                suggestions.add("remove");
            }
            if ("check".startsWith((String)partial)) {
                suggestions.add("check");
            }
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("punish") && sender.hasPermission("deepguardx.punish")) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!player.getName().toLowerCase().startsWith(args[2].toLowerCase())) continue;
                suggestions.add(player.getName());
            }
        }
        if (args.length == 4 && args[0].equalsIgnoreCase("punish") && args[1].equalsIgnoreCase("set") && sender.hasPermission("deepguardx.punish")) {
            partial = args[3].toLowerCase();
            for (int i = 0; i <= 6; ++i) {
                if (!String.valueOf(i).startsWith((String)partial)) continue;
                suggestions.add(String.valueOf(i));
            }
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("highlight") && sender.hasPermission("deepguardx.highlight")) {
            suggestions.add("off");
            suggestions.add("nearest");
            suggestions.add("return");
            suggestions.add("20");
            suggestions.add("30");
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("points") && sender.hasPermission("deepguardx.modify")) {
            suggestions.add("add");
            suggestions.add("remove");
            suggestions.add("set");
            suggestions.add("check");
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("points") && sender.hasPermission("deepguardx.modify")) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!player.getName().toLowerCase().startsWith(args[2].toLowerCase())) continue;
                suggestions.add(player.getName());
            }
        }
        if (args.length != 4 || !args[0].equalsIgnoreCase("points") || args[1].equalsIgnoreCase("check") || sender.hasPermission("deepguardx.modify")) {
            // empty if block
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("ml")) {
            partial = args[1].toLowerCase();
            if (sender.hasPermission("deepguardx.ml")) {
                if ("flag".startsWith((String)partial)) {
                    suggestions.add("flag");
                }
                if ("analyze".startsWith((String)partial)) {
                    suggestions.add("analyze");
                }
                if ("suspicious".startsWith((String)partial)) {
                    suggestions.add("suspicious");
                }
            }
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("ml") && (args[1].equalsIgnoreCase("flag") || args[1].equalsIgnoreCase("analyze")) && sender.hasPermission("deepguardx.ml")) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!player.getName().toLowerCase().startsWith(args[2].toLowerCase())) continue;
                suggestions.add(player.getName());
            }
        }
        if (args.length == 4 && args[0].equalsIgnoreCase("ml") && args[1].equalsIgnoreCase("flag") && sender.hasPermission("deepguardx.ml")) {
            partial = args[3].toLowerCase();
            if ("true".startsWith((String)partial)) {
                suggestions.add("true");
            }
            if ("false".startsWith((String)partial)) {
                suggestions.add("false");
            }
        }
        return suggestions;
    }
}

