/*
 * Decompiled with CFR 0.152.
 */
package net.jakeccz.hrp.listener;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.jakeccz.hrp.HardcoreRevivePlugin;
import net.jakeccz.hrp.util.HardcoreRevivePluginConfig;
import net.jakeccz.hrp.util.HardcoreRevivePluginUtil;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;

public class EntityDeath
implements Listener {
    private final Map<EntityType, Consumer<EntityDeathEvent>> entityActions = new HashMap<EntityType, Consumer<EntityDeathEvent>>();

    public EntityDeath() {
        this.entityActions.put(EntityType.PLAYER, event -> {
            Player player;
            if (HardcoreRevivePluginConfig.ConfigRule.getOrDefault("lose-inventory", false).booleanValue()) {
                event.getDrops().clear();
            }
            LivingEntity entity = event.getEntity();
            Location deathPos = entity.getEyeLocation();
            String dimensionName = entity.getWorld().getKey().asString();
            ItemStack skull = HardcoreRevivePluginUtil.createSkullWithName(entity.getName());
            String deathMessage = "Death Coordinates: [{y} {x} {z}]\nDimension: {dTypeName}".replace("{x}", String.valueOf(deathPos.getBlockX())).replace("{y}", String.valueOf(deathPos.getBlockY())).replace("{z}", String.valueOf(deathPos.getBlockZ())).replace("{dTypeName}", dimensionName);
            entity.sendMessage(deathMessage);
            Player player2 = player = entity.getType() == EntityType.PLAYER ? (Player)entity : null;
            if (!(player == null || player.getGameMode() != GameMode.SPECTATOR && player.getGameMode() != GameMode.CREATIVE || HardcoreRevivePluginConfig.ConfigRule.getOrDefault("creative-players-drop-heads", false).booleanValue())) {
                return;
            }
            entity.getWorld().dropItem(deathPos, skull);
        });
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void entityDropHeadEvent(EntityDeathEvent event) {
        LivingEntity entity = event.getEntity();
        Consumer<EntityDeathEvent> action = this.entityActions.get(event.getEntityType());
        if (action != null && HardcoreRevivePlugin.PLUGIN_HMODE) {
            action.accept(event);
        }
    }
}

