/*
 * Decompiled with CFR 0.152.
 */
package net.jadedmc.commandblocker;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class ConfigManager {
    private FileConfiguration config;
    private final File configFile;
    private final Collection<String> commands = new HashSet<String>();

    public ConfigManager(Plugin plugin) {
        this.configFile = new File(plugin.getDataFolder(), "config.yml");
        if (!this.configFile.exists()) {
            plugin.saveResource("config.yml", false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.loadCommands();
    }

    public Collection<String> getCommands() {
        return this.commands;
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    private void loadCommands() {
        for (String command : this.config.getStringList("Commands")) {
            if (!command.startsWith("/")) {
                command = "/" + command;
            }
            this.commands.add(command);
        }
    }

    public void reloadConfig() {
        this.commands.clear();
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.loadCommands();
    }

    public void saveConfig() {
        try {
            this.config.save(this.configFile);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }
}

