/*
 * Decompiled with CFR 0.152.
 */
package me.itzloghotxd.gamemenu.utility.item;

import java.util.List;
import java.util.stream.Collectors;
import me.itzloghotxd.gamemenu.GamemenuPlugin;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ItemHandler {
    private static final GamemenuPlugin PLUGIN = GamemenuPlugin.getPlugin();

    public static ItemStack createCustomItem(Material material, String displayName, List<String> lore, String metadataKey, String metadataValue) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            if (displayName != null && !displayName.isEmpty()) {
                meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)displayName));
            }
            if (lore != null && !lore.isEmpty()) {
                meta.setLore(lore.stream().map(line -> ChatColor.translateAlternateColorCodes((char)'&', (String)line)).collect(Collectors.toList()));
            }
            if (metadataKey != null && metadataValue != null) {
                NamespacedKey key = new NamespacedKey((Plugin)PLUGIN, metadataKey);
                PersistentDataContainer container = meta.getPersistentDataContainer();
                container.set(key, PersistentDataType.STRING, (Object)metadataValue);
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    public static boolean isCustomItem(ItemStack item, String metadataKey, String metadataValue) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        NamespacedKey key = new NamespacedKey((Plugin)PLUGIN, metadataKey);
        return metadataValue.equals(container.get(key, PersistentDataType.STRING));
    }
}

