/*
 * Decompiled with CFR 0.152.
 */
package me.itzloghotxd.gamemenu.inventory.guis;

import java.util.List;
import java.util.Objects;
import me.itzloghotxd.gamemenu.GamemenuPlugin;
import me.itzloghotxd.gamemenu.config.ConfigManager;
import me.itzloghotxd.gamemenu.inventory.AbstractInventory;
import me.itzloghotxd.gamemenu.inventory.InventoryPlayer;
import me.itzloghotxd.gamemenu.utility.PlaceholderUtil;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class MainMenu
extends AbstractInventory {
    private final Player player;
    FileConfiguration config = GamemenuPlugin.getPlugin().getConfigManager().getConfig(ConfigManager.ConfigType.SETTINGS);

    public MainMenu(InventoryPlayer inventoryPlayer) {
        super(inventoryPlayer);
        this.player = inventoryPlayer.getPlayer();
    }

    @Override
    public String getInventoryName() {
        String title = this.config.getString("menu.title", "Main Menu");
        return ChatColor.translateAlternateColorCodes((char)'&', (String)title);
    }

    @Override
    public int getSlots() {
        int slots = this.config.getInt("menu.slots", 54);
        if (slots > 54) {
            return 54;
        }
        if (slots < 9) {
            return 9;
        }
        if (slots % 9 != 0) {
            int lowerBound = slots / 9 * 9;
            int upperBound = lowerBound + 9;
            slots = slots - lowerBound < upperBound - slots ? lowerBound : upperBound;
        }
        return slots;
    }

    @Override
    public void handleInventory(InventoryClickEvent event) {
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || !clickedItem.hasItemMeta()) {
            return;
        }
        ItemMeta meta = clickedItem.getItemMeta();
        if (meta == null) {
            return;
        }
        String displayName = meta.getDisplayName();
        Material material = clickedItem.getType();
        String item = null;
        for (String entry : Objects.requireNonNull(this.config.getConfigurationSection("menu.items")).getKeys(false)) {
            String itemDisplayName = ChatColor.translateAlternateColorCodes((char)'&', (String)Objects.requireNonNull(this.config.getString("menu.items." + entry + ".display_name")));
            Material itemMaterial = Material.matchMaterial((String)Objects.requireNonNull(this.config.getString("menu.items." + entry + ".material")));
            int slot = this.config.getInt("menu.items." + entry + ".slot");
            if (itemMaterial == null || itemMaterial != material || !itemDisplayName.equals(displayName) || slot != event.getRawSlot()) continue;
            item = "menu.items." + entry;
            break;
        }
        if (item != null) {
            List commands = this.config.getStringList(item + ".commands");
            for (String command : commands) {
                if ((command = PlaceholderUtil.setPlaceholders(command, this.player)).equalsIgnoreCase("close")) {
                    this.player.closeInventory();
                    continue;
                }
                if (command.toUpperCase().startsWith("CONSOLE:")) {
                    String consoleCommand = command.substring("CONSOLE:".length()).trim();
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)consoleCommand);
                    continue;
                }
                Bukkit.dispatchCommand((CommandSender)this.player, (String)command);
            }
        }
    }

    @Override
    public void setItems() {
        for (String entry : Objects.requireNonNull(this.config.getConfigurationSection("menu.items")).getKeys(false)) {
            int slot = this.config.getInt("menu.items." + entry + ".slot");
            int amount = this.config.getInt("menu.items." + entry + ".amount", 1);
            boolean glow = this.config.getBoolean("menu.items." + entry + ".glow", false);
            Material material = Material.matchMaterial((String)this.config.getString("menu.items." + entry + ".material", "BARRIER"));
            String name = this.config.getString("menu.items." + entry + ".display_name");
            List lore = this.config.getStringList("menu.items." + entry + ".lore");
            if (slot < 0 || slot >= this.getSlots() || material == null) continue;
            ItemStack item = new ItemStack(material);
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                if (name != null) {
                    meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)PlaceholderUtil.setPlaceholders(name, this.player)));
                }
                lore.replaceAll(textToTranslate -> ChatColor.translateAlternateColorCodes((char)'&', (String)PlaceholderUtil.setPlaceholders(textToTranslate, this.player)));
                meta.setLore(lore);
                if (glow) {
                    meta.addEnchant(Enchantment.BINDING_CURSE, 1, false);
                    meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                }
                item.setItemMeta(meta);
                if (amount >= 64) {
                    item.setAmount(64);
                } else {
                    item.setAmount(amount);
                }
            }
            this.inventory.setItem(slot, item);
        }
    }
}

