/*
 * Decompiled with CFR 0.152.
 */
package me.itzloghotxd.gamemenu.config;

import java.util.HashMap;
import java.util.Map;
import me.itzloghotxd.gamemenu.GamemenuPlugin;
import me.itzloghotxd.gamemenu.config.ConfigHandler;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigManager {
    private final Map<ConfigType, ConfigHandler> configurations = new HashMap<ConfigType, ConfigHandler>();

    public void loadFiles(GamemenuPlugin plugin) {
        this.registerFile(ConfigType.SETTINGS, new ConfigHandler(plugin, "config.yml"));
        this.configurations.values().forEach(ConfigHandler::saveDefaultConfig);
    }

    public void saveFiles() {
        this.getFile(ConfigType.SETTINGS).save();
    }

    public void reloadFiles() {
        this.configurations.values().forEach(ConfigHandler::reload);
    }

    public ConfigHandler getFile(ConfigType type) {
        return this.configurations.get((Object)type);
    }

    public void registerFile(ConfigType type, ConfigHandler config) {
        this.configurations.put(type, config);
    }

    public FileConfiguration getConfig(ConfigType type) {
        return GamemenuPlugin.getPlugin().getConfigManager().getFile(type).getConfig();
    }

    public static enum ConfigType {
        SETTINGS;

    }
}

