/*
 * Decompiled with CFR 0.152.
 */
package me.itzloghotxd.gamemenu.commands;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.itzloghotxd.gamemenu.commands.Command;
import me.itzloghotxd.gamemenu.commands.subCommands.HelpCommand;
import me.itzloghotxd.gamemenu.commands.subCommands.MenuCommand;
import me.itzloghotxd.gamemenu.commands.subCommands.ReloadCommand;
import org.bukkit.command.CommandSender;

public class CommandManager {
    private final Map<String, Command> subCommands = new HashMap<String, Command>();

    public CommandManager() {
        this.registerCommand("help", new HelpCommand());
        this.registerCommand("reload", new ReloadCommand());
        this.registerCommand("menu", new MenuCommand());
    }

    public void registerCommand(String name, Command command) {
        this.subCommands.put(name.toLowerCase(), command);
    }

    public boolean executeCommand(CommandSender sender, String[] args) {
        Command subCommand = this.subCommands.get(args[0].toLowerCase());
        if (subCommand == null) {
            sender.sendMessage("Unknown subcommand. Use /gamemenu help for a list of commands.");
            return true;
        }
        if (!sender.hasPermission(subCommand.getPermission())) {
            sender.sendMessage("You don't have permission to use this command.");
            return true;
        }
        subCommand.execute(sender, args);
        return true;
    }

    public List<String> getTabCompletions(CommandSender sender, String[] args) {
        Command subCommand2;
        if (args.length == 1) {
            return this.subCommands.keySet().stream().filter(subCommand -> subCommand.startsWith(args[0].toLowerCase())).toList();
        }
        if (args.length > 1 && (subCommand2 = this.subCommands.get(args[0].toLowerCase())) != null) {
            return subCommand2.onTabComplete(sender, args);
        }
        return List.of();
    }
}

