/*
 * Decompiled with CFR 0.152.
 */
package me.itzloghotxd.gamemenu;

import java.util.HashMap;
import java.util.UUID;
import java.util.logging.Level;
import me.itzloghotxd.gamemenu.commands.CommandHandler;
import me.itzloghotxd.gamemenu.commands.CommandManager;
import me.itzloghotxd.gamemenu.config.ConfigManager;
import me.itzloghotxd.gamemenu.inventory.InventoryListener;
import me.itzloghotxd.gamemenu.inventory.InventoryPlayer;
import me.itzloghotxd.gamemenu.libs.bstats.bukkit.Metrics;
import me.itzloghotxd.gamemenu.listener.hotbar.HotbarClickEvent;
import me.itzloghotxd.gamemenu.listener.hotbar.HotbarItem;
import me.itzloghotxd.gamemenu.listener.player.PlayerInteractionEvent;
import me.itzloghotxd.gamemenu.listener.player.PlayerItemDropEvent;
import me.itzloghotxd.gamemenu.listener.player.PlayerOffHandSwapEvent;
import me.itzloghotxd.gamemenu.utility.item.ItemManager;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class GamemenuPlugin
extends JavaPlugin {
    private static final int BSTATS_ID = 24501;
    private static GamemenuPlugin plugin;
    private ConfigManager configManager;
    private CommandManager commandManager;
    private ItemManager itemManager;
    private static final HashMap<UUID, InventoryPlayer> playerInventory;

    public void onEnable() {
        long start = System.currentTimeMillis();
        plugin = this;
        this.getLogger().log(Level.INFO, "");
        this.getLogger().log(Level.INFO, "GameMenu");
        this.getLogger().log(Level.INFO, "Version " + this.getDescription().getVersion());
        this.getLogger().log(Level.INFO, "Made with <3 by ItzLoghotXD");
        this.getLogger().log(Level.INFO, "https://github.com/ItzLoghotXD/GameMenu");
        this.getLogger().log(Level.INFO, "");
        if (this.getServer().getPluginManager().isPluginEnabled((Plugin)this)) {
            new Metrics(this, 24501);
            this.configManager = new ConfigManager();
            this.configManager.loadFiles(this);
            this.commandManager = new CommandManager();
            new CommandHandler(this);
            this.itemManager = new ItemManager();
            this.itemManager.loadItems();
            this.registerEvents();
            this.getLogger().log(Level.INFO, "");
            this.getLogger().log(Level.INFO, "Successfully loaded in " + (System.currentTimeMillis() - start) + "ms!");
        }
    }

    public void onDisable() {
        Bukkit.getScheduler().cancelTasks((Plugin)this);
        this.configManager.saveFiles();
    }

    public void onReload() {
        long start = System.currentTimeMillis();
        this.configManager.reloadFiles();
        this.itemManager.reloadItems();
        this.getLogger().log(Level.INFO, "Successfully reloaded in " + (System.currentTimeMillis() - start) + "ms!");
    }

    private void registerEvents() {
        this.getServer().getPluginManager().registerEvents((Listener)new HotbarClickEvent(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new HotbarItem(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerItemDropEvent(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerOffHandSwapEvent(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerInteractionEvent(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new InventoryListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents(new Listener(){

            @EventHandler
            public void onQuit(PlayerQuitEvent event) {
                playerInventory.remove(event.getPlayer().getUniqueId());
            }
        }, (Plugin)this);
    }

    public static GamemenuPlugin getPlugin() {
        return plugin;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    public ItemManager getItemManager() {
        return this.itemManager;
    }

    public static InventoryPlayer getInventoryPlayer(Player player) {
        if (playerInventory.containsKey(player.getUniqueId())) {
            return playerInventory.get(player.getUniqueId());
        }
        InventoryPlayer inventoryPlayer = new InventoryPlayer(player);
        playerInventory.put(player.getUniqueId(), inventoryPlayer);
        return inventoryPlayer;
    }

    static {
        playerInventory = new HashMap();
    }
}

