/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.jextranslate.validation;

import de.jexcellence.jextranslate.validation.ValidationStatistics;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public record ValidationReport(@NotNull Instant timestamp, @NotNull Set<String> missingKeys, @NotNull Set<String> unusedKeys, @NotNull Set<String> formatErrors, @NotNull Set<String> placeholderIssues, @NotNull Set<String> namingViolations, @NotNull ValidationStatistics statistics) {
    public ValidationReport(@NotNull Instant timestamp, @NotNull Set<String> missingKeys, @NotNull Set<String> unusedKeys, @NotNull Set<String> formatErrors, @NotNull Set<String> placeholderIssues, @NotNull Set<String> namingViolations, @NotNull ValidationStatistics statistics) {
        missingKeys = Collections.unmodifiableSet(new HashSet<String>(missingKeys));
        unusedKeys = Collections.unmodifiableSet(new HashSet<String>(unusedKeys));
        formatErrors = Collections.unmodifiableSet(new HashSet<String>(formatErrors));
        placeholderIssues = Collections.unmodifiableSet(new HashSet<String>(placeholderIssues));
        namingViolations = Collections.unmodifiableSet(new HashSet<String>(namingViolations));
    }

    public boolean hasIssues() {
        return !this.missingKeys.isEmpty() || !this.unusedKeys.isEmpty() || !this.formatErrors.isEmpty() || !this.placeholderIssues.isEmpty() || !this.namingViolations.isEmpty();
    }

    public int getTotalIssues() {
        return this.missingKeys.size() + this.unusedKeys.size() + this.formatErrors.size() + this.placeholderIssues.size() + this.namingViolations.size();
    }

    @NotNull
    public Set<String> getAllProblematicKeys() {
        HashSet<String> allKeys = new HashSet<String>();
        allKeys.addAll(this.missingKeys);
        allKeys.addAll(this.unusedKeys);
        allKeys.addAll(this.formatErrors);
        allKeys.addAll(this.placeholderIssues);
        allKeys.addAll(this.namingViolations);
        return allKeys;
    }

    public double getValidationScore() {
        int totalKeys = this.statistics.totalKeys();
        if (totalKeys == 0) {
            return 100.0;
        }
        int issues = this.getTotalIssues();
        return Math.max(0.0, 100.0 - (double)issues * 100.0 / (double)totalKeys);
    }

    @NotNull
    public String getSummary() {
        if (!this.hasIssues()) {
            return "\u2713 All translations are valid and complete!";
        }
        StringBuilder summary = new StringBuilder();
        summary.append(String.format("Validation Score: %.1f%%\n", this.getValidationScore()));
        summary.append(String.format("Total Issues: %d\n", this.getTotalIssues()));
        if (!this.missingKeys.isEmpty()) {
            summary.append(String.format("- Missing Keys: %d\n", this.missingKeys.size()));
        }
        if (!this.unusedKeys.isEmpty()) {
            summary.append(String.format("- Unused Keys: %d\n", this.unusedKeys.size()));
        }
        if (!this.formatErrors.isEmpty()) {
            summary.append(String.format("- Format Errors: %d\n", this.formatErrors.size()));
        }
        if (!this.placeholderIssues.isEmpty()) {
            summary.append(String.format("- Placeholder Issues: %d\n", this.placeholderIssues.size()));
        }
        if (!this.namingViolations.isEmpty()) {
            summary.append(String.format("- Naming Violations: %d\n", this.namingViolations.size()));
        }
        return summary.toString();
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Instant timestamp = Instant.now();
        private final Set<String> missingKeys = new HashSet<String>();
        private final Set<String> unusedKeys = new HashSet<String>();
        private final Set<String> formatErrors = new HashSet<String>();
        private final Set<String> placeholderIssues = new HashSet<String>();
        private final Set<String> namingViolations = new HashSet<String>();
        private ValidationStatistics statistics = ValidationStatistics.empty();

        @NotNull
        public Builder timestamp(@NotNull Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @NotNull
        public Builder addMissingKey(@NotNull String key) {
            this.missingKeys.add(key);
            return this;
        }

        @NotNull
        public Builder addMissingKeys(@NotNull Collection<String> keys) {
            this.missingKeys.addAll(keys);
            return this;
        }

        @NotNull
        public Builder addFormatError(@NotNull String key) {
            this.formatErrors.add(key);
            return this;
        }

        @NotNull
        public Builder addPlaceholderIssue(@NotNull String key) {
            this.placeholderIssues.add(key);
            return this;
        }

        @NotNull
        public Builder addNamingViolation(@NotNull String key) {
            this.namingViolations.add(key);
            return this;
        }

        @NotNull
        public Builder statistics(@NotNull ValidationStatistics statistics) {
            this.statistics = statistics;
            return this;
        }

        @NotNull
        public ValidationReport build() {
            return new ValidationReport(this.timestamp, this.missingKeys, this.unusedKeys, this.formatErrors, this.placeholderIssues, this.namingViolations, this.statistics);
        }
    }
}

