/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.jextranslate.util;

import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HexFormat;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TranslationLogger {
    private static final Pattern ALLOWED_KEY_PATTERN = Pattern.compile("[A-Za-z0-9._-]+");
    private static final int MAX_VALUE_LENGTH = 256;
    private static final HexFormat HEX_FORMAT = HexFormat.of();
    private static final String HASH_ALGORITHM = "SHA-256";
    private static final boolean CENTRAL_LOGGER_AVAILABLE;
    private static final Method CENTRAL_LOGGER_BY_CLASS;
    private static final Method CENTRAL_LOGGER_BY_NAME;

    private TranslationLogger() {
        throw new UnsupportedOperationException("Utility class");
    }

    @NotNull
    public static Logger getLogger(@NotNull Class<?> type) {
        Objects.requireNonNull(type, "Type cannot be null");
        if (CENTRAL_LOGGER_AVAILABLE && CENTRAL_LOGGER_BY_CLASS != null) {
            try {
                return (Logger)CENTRAL_LOGGER_BY_CLASS.invoke(null, type);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Logger.getLogger(type.getName());
    }

    @NotNull
    public static Logger getLogger(@NotNull String name) {
        Objects.requireNonNull(name, "Name cannot be null");
        if (CENTRAL_LOGGER_AVAILABLE && CENTRAL_LOGGER_BY_NAME != null) {
            try {
                return (Logger)CENTRAL_LOGGER_BY_NAME.invoke(null, name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Logger.getLogger(name);
    }

    @NotNull
    public static String message(@NotNull String message, @Nullable Map<String, ?> context) {
        Objects.requireNonNull(message, "Message cannot be null");
        if (context == null || context.isEmpty()) {
            return message;
        }
        return message + TranslationLogger.formatContext(context);
    }

    @NotNull
    public static String formatContext(@NotNull Map<String, ?> context) {
        Objects.requireNonNull(context, "Context cannot be null");
        if (context.isEmpty()) {
            return "";
        }
        StringJoiner joiner = new StringJoiner(", ", " context={", "}");
        for (Map.Entry<String, ?> entry : context.entrySet()) {
            String key = TranslationLogger.sanitiseKey(entry.getKey());
            String value = TranslationLogger.sanitiseValue(entry.getValue());
            joiner.add(key + "=" + value);
        }
        return " " + String.valueOf(joiner);
    }

    @NotNull
    public static String anonymize(@NotNull CharSequence input) {
        Objects.requireNonNull(input, "Input cannot be null");
        try {
            MessageDigest digest = MessageDigest.getInstance(HASH_ALGORITHM);
            byte[] hashed = digest.digest(input.toString().getBytes(StandardCharsets.UTF_8));
            String hex = HEX_FORMAT.formatHex(hashed);
            return hex.substring(0, Math.min(12, hex.length())).toLowerCase(Locale.ROOT);
        }
        catch (NoSuchAlgorithmException ignored) {
            return Integer.toHexString(input.hashCode());
        }
    }

    @NotNull
    public static String anonymize(@NotNull UUID uuid) {
        Objects.requireNonNull(uuid, "UUID cannot be null");
        return TranslationLogger.anonymize(uuid.toString());
    }

    private static void logSanitisationWarning(@NotNull String message, @NotNull Exception exception) {
        Logger logger = TranslationLogger.getLogger(TranslationLogger.class);
        logger.log(Level.FINE, message, exception);
    }

    @NotNull
    private static String sanitiseKey(@Nullable String rawKey) {
        String key;
        String string = key = rawKey == null ? "unknown" : rawKey.trim();
        if (ALLOWED_KEY_PATTERN.matcher(key).matches()) {
            return key;
        }
        StringBuilder builder = new StringBuilder(key.length());
        for (char c : key.toCharArray()) {
            if (Character.isLetterOrDigit(c) || c == '.' || c == '_' || c == '-') {
                builder.append(c);
                continue;
            }
            builder.append('_');
        }
        return builder.toString();
    }

    @NotNull
    private static String sanitiseValue(@Nullable Object value) {
        if (value == null) {
            return "null";
        }
        try {
            String asString = String.valueOf(value);
            if (asString.length() <= 256) {
                return asString;
            }
            return asString.substring(0, 253) + "...";
        }
        catch (Exception exception) {
            TranslationLogger.logSanitisationWarning("Failed to sanitise log value", exception);
            return "<error>";
        }
    }

    static {
        Method byClass = null;
        Method byName = null;
        boolean available = false;
        try {
            Class<?> centralLoggerClass = Class.forName("com.raindropcentral.rplatform.logging.CentralLogger");
            byClass = centralLoggerClass.getMethod("getLogger", Class.class);
            byName = centralLoggerClass.getMethod("getLogger", String.class);
            available = true;
        }
        catch (ClassNotFoundException | NoSuchMethodException ignored) {
            available = false;
        }
        CENTRAL_LOGGER_AVAILABLE = available;
        CENTRAL_LOGGER_BY_CLASS = byClass;
        CENTRAL_LOGGER_BY_NAME = byName;
    }
}

